/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.ide.actions.CopyElementAction;
import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefactoringQuickListPopupAction
extends QuickSwitchSchemeAction {
    public RefactoringQuickListPopupAction() {
        this.setInjectedContext(true);
    }

    protected void fillActions(@Nullable Project project2, @NotNull DefaultActionGroup group, @NotNull DataContext dataContext) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/refactoring/actions/RefactoringQuickListPopupAction", "fillActions"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/refactoring/actions/RefactoringQuickListPopupAction", "fillActions"));
        }
        if (project2 == null) {
            return;
        }
        ActionManager actionManager = ActionManager.getInstance();
        AnAction action2 = actionManager.getAction("RefactoringMenu");
        RefactoringQuickListPopupAction.collectEnabledChildren(action2, group, dataContext, actionManager, false);
    }

    private static void collectEnabledChildren(AnAction action2, @NotNull DefaultActionGroup destinationGroup, @NotNull DataContext dataContext, @NotNull ActionManager actionManager, boolean popup2) {
        if (destinationGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destinationGroup", "com/intellij/refactoring/actions/RefactoringQuickListPopupAction", "collectEnabledChildren"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/refactoring/actions/RefactoringQuickListPopupAction", "collectEnabledChildren"));
        }
        if (actionManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionManager", "com/intellij/refactoring/actions/RefactoringQuickListPopupAction", "collectEnabledChildren"));
        }
        if (action2 instanceof DefaultActionGroup) {
            AnAction[] children2;
            for (AnAction child : children2 = ((DefaultActionGroup)action2).getChildren(null)) {
                if (child instanceof DefaultActionGroup) {
                    boolean isPopup = ((DefaultActionGroup)child).isPopup();
                    if (isPopup) {
                        destinationGroup.add((AnAction)new Separator(child.getTemplatePresentation().getText()));
                    }
                    RefactoringQuickListPopupAction.collectEnabledChildren(child, destinationGroup, dataContext, actionManager, isPopup || popup2);
                    if (!isPopup) continue;
                    destinationGroup.add((AnAction)Separator.getInstance());
                    continue;
                }
                if (child instanceof Separator && !popup2) {
                    destinationGroup.add(child);
                    continue;
                }
                if ((!(child instanceof BaseRefactoringAction) || !((BaseRefactoringAction)child).hasAvailableHandler(dataContext)) && !(child instanceof CopyElementAction)) continue;
                Presentation presentation = new Presentation();
                AnActionEvent event = new AnActionEvent(null, dataContext, "unknown", presentation, actionManager, 0);
                event.setInjectedContext(child.isInInjectedContext());
                child.update(event);
                if (!presentation.isEnabled() || !presentation.isVisible()) continue;
                destinationGroup.add(child);
            }
        }
    }

    protected void showPopup(AnActionEvent e2, ListPopup popup2) {
        Editor editor = (Editor)e2.getData(CommonDataKeys.EDITOR);
        if (editor != null) {
            popup2.showInBestPositionFor(editor);
        } else {
            super.showPopup(e2, popup2);
        }
    }

    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/refactoring/actions/RefactoringQuickListPopupAction", "update"));
        }
        super.update(e2);
        e2.getPresentation().setVisible(ActionPlaces.isMainMenuOrActionSearch((String)e2.getPlace()) || "ActionPlace.QuickListPopupAction".equals(e2.getPlace()));
    }

    protected String getPopupTitle(AnActionEvent e2) {
        return "Refactor This";
    }
}

