/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureUsageProcessor;
import com.intellij.refactoring.changeSignature.PossiblyIncorrectUsage;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.UndoRefactoringElementListener;
import com.intellij.refactoring.listeners.impl.RefactoringTransaction;
import com.intellij.refactoring.rename.ResolveSnapshotProvider;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangeSignatureProcessorBase
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.changeSignature.ChangeSignatureProcessorBase");
    protected static final String REFACTORING_ID = "refactoring.changeSignature";
    protected final ChangeInfo myChangeInfo;
    protected final PsiManager myManager;

    protected ChangeSignatureProcessorBase(Project project2, ChangeInfo changeInfo) {
        super(project2);
        this.myChangeInfo = changeInfo;
        this.myManager = PsiManager.getInstance((Project)project2);
    }

    protected ChangeSignatureProcessorBase(Project project2, @Nullable Runnable prepareSuccessfulCallback, ChangeInfo changeInfo) {
        super(project2, prepareSuccessfulCallback);
        this.myChangeInfo = changeInfo;
        this.myManager = PsiManager.getInstance((Project)project2);
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        UsageInfo[] usageInfoArray = ChangeSignatureProcessorBase.findUsages(this.myChangeInfo);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/changeSignature/ChangeSignatureProcessorBase", "findUsages"));
        }
        return usageInfoArray;
    }

    public static void collectConflictsFromExtensions(@NotNull Ref<UsageInfo[]> refUsages, MultiMap<PsiElement, String> conflictDescriptions, ChangeInfo changeInfo) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/intellij/refactoring/changeSignature/ChangeSignatureProcessorBase", "collectConflictsFromExtensions"));
        }
        for (ChangeSignatureUsageProcessor usageProcessor : (ChangeSignatureUsageProcessor[])ChangeSignatureUsageProcessor.EP_NAME.getExtensions()) {
            MultiMap conflicts = usageProcessor.findConflicts(changeInfo, refUsages);
            for (PsiElement key : conflicts.keySet()) {
                Collection collection = conflictDescriptions.get((Object)key);
                if (collection.isEmpty()) {
                    collection = new HashSet();
                }
                collection.addAll(conflicts.get((Object)key));
                conflictDescriptions.put((Object)key, collection);
            }
        }
    }

    @NotNull
    public static UsageInfo[] findUsages(ChangeInfo changeInfo) {
        ChangeSignatureUsageProcessor[] processors;
        List<UsageInfo> infos = new ArrayList<UsageInfo>();
        for (ChangeSignatureUsageProcessor processor2 : processors = (ChangeSignatureUsageProcessor[])ChangeSignatureUsageProcessor.EP_NAME.getExtensions()) {
            for (UsageInfo info : processor2.findUsages(changeInfo)) {
                LOG.assertTrue(info != null, (Object)processor2);
                infos.add(info);
            }
        }
        infos = ChangeSignatureProcessorBase.filterUsages(infos);
        UsageInfo[] usageInfoArray = infos.toArray(new UsageInfo[infos.size()]);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/changeSignature/ChangeSignatureProcessorBase", "findUsages"));
        }
        return usageInfoArray;
    }

    protected static List<UsageInfo> filterUsages(List<UsageInfo> infos) {
        HashMap moveRenameInfos = new HashMap();
        com.intellij.util.containers.hash.HashSet usedElements = new com.intellij.util.containers.hash.HashSet();
        ArrayList<UsageInfo> result2 = new ArrayList<UsageInfo>(infos.size() / 2);
        for (UsageInfo info : infos) {
            LOG.assertTrue(info != null);
            PsiElement element = info.getElement();
            if (info instanceof MoveRenameUsageInfo) {
                if (usedElements.contains(element)) continue;
                moveRenameInfos.put(element, (MoveRenameUsageInfo)info);
                continue;
            }
            moveRenameInfos.remove(element);
            usedElements.add(element);
            if (info instanceof PossiblyIncorrectUsage && !((PossiblyIncorrectUsage)info).isCorrect()) continue;
            result2.add(info);
        }
        result2.addAll(moveRenameInfos.values());
        return result2;
    }

    @Override
    protected boolean isPreviewUsages(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/changeSignature/ChangeSignatureProcessorBase", "isPreviewUsages"));
        }
        for (ChangeSignatureUsageProcessor processor2 : (ChangeSignatureUsageProcessor[])ChangeSignatureUsageProcessor.EP_NAME.getExtensions()) {
            if (!processor2.shouldPreviewUsages(this.myChangeInfo, usages)) continue;
            return true;
        }
        return super.isPreviewUsages(usages);
    }

    @Override
    @Nullable
    protected String getRefactoringId() {
        return REFACTORING_ID;
    }

    @Override
    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElement(this.getChangeInfo().getMethod());
        return data;
    }

    @Override
    @Nullable
    protected RefactoringEventData getAfterData(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/changeSignature/ChangeSignatureProcessorBase", "getAfterData"));
        }
        RefactoringEventData data = new RefactoringEventData();
        data.addElement(this.getChangeInfo().getMethod());
        return data;
    }

    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/changeSignature/ChangeSignatureProcessorBase", "performRefactoring"));
        }
        RefactoringTransaction transaction = this.getTransaction();
        final ChangeInfo changeInfo = this.myChangeInfo;
        final RefactoringElementListener elementListener = transaction == null ? null : transaction.getElementListener(changeInfo.getMethod());
        final String fqn = CopyReferenceAction.elementToFqn(changeInfo.getMethod());
        if (fqn != null) {
            BasicUndoableAction action2 = new BasicUndoableAction(){

                public void undo() {
                    if (elementListener instanceof UndoRefactoringElementListener) {
                        ((UndoRefactoringElementListener)elementListener).undoElementMovedOrRenamed(changeInfo.getMethod(), fqn);
                    }
                }

                public void redo() {
                }
            };
            UndoManager.getInstance((Project)this.myProject).undoableActionPerformed((UndoableAction)action2);
        }
        try {
            ChangeSignatureProcessorBase.doChangeSignature(changeInfo, usages);
            PsiElement method2 = changeInfo.getMethod();
            LOG.assertTrue(method2.isValid());
            if (elementListener != null && changeInfo.isNameChanged()) {
                elementListener.elementRenamed(method2);
            }
        }
        catch (IncorrectOperationException e2) {
            LOG.error((Throwable)e2);
        }
    }

    public static void doChangeSignature(ChangeInfo changeInfo, @NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/changeSignature/ChangeSignatureProcessorBase", "doChangeSignature"));
        }
        ChangeSignatureUsageProcessor[] processors = (ChangeSignatureUsageProcessor[])ChangeSignatureUsageProcessor.EP_NAME.getExtensions();
        ResolveSnapshotProvider resolveSnapshotProvider = changeInfo.isParameterNamesChanged() ? (ResolveSnapshotProvider)VariableInplaceRenamer.INSTANCE.forLanguage(changeInfo.getMethod().getLanguage()) : null;
        ArrayList snapshots = new ArrayList();
        for (ChangeSignatureUsageProcessor changeSignatureUsageProcessor : processors) {
            if (resolveSnapshotProvider == null) continue;
            changeSignatureUsageProcessor.registerConflictResolvers(snapshots, resolveSnapshotProvider, usages, changeInfo);
        }
        for (ChangeSignatureUsageProcessor changeSignatureUsageProcessor : usages) {
            for (ChangeSignatureUsageProcessor processor3 : processors) {
                if (processor3.processUsage(changeInfo, (UsageInfo)changeSignatureUsageProcessor, true, usages)) break;
            }
        }
        LOG.assertTrue(changeInfo.getMethod().isValid());
        for (ChangeSignatureUsageProcessor changeSignatureUsageProcessor : processors) {
            if (changeSignatureUsageProcessor.processPrimaryMethod(changeInfo)) break;
        }
        for (ChangeSignatureUsageProcessor changeSignatureUsageProcessor : usages) {
            for (ChangeSignatureUsageProcessor processor2 : processors) {
                if (processor2.processUsage(changeInfo, (UsageInfo)changeSignatureUsageProcessor, false, usages)) break;
            }
        }
        if (!snapshots.isEmpty()) {
            for (ChangeSignatureUsageProcessor changeSignatureUsageProcessor : changeInfo.getNewParameters()) {
                for (ResolveSnapshotProvider.ResolveSnapshot snapshot : snapshots) {
                    snapshot.apply(changeSignatureUsageProcessor.getName());
                }
            }
        }
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"changing.signature.of.0", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myChangeInfo.getMethod())});
    }

    public ChangeInfo getChangeInfo() {
        return this.myChangeInfo;
    }
}

