/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature.inplace;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.FinishMarkAction;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.changeSignature.inplace.LanguageChangeSignatureDetector;
import com.intellij.refactoring.changeSignature.inplace.LanguageChangeSignatureDetectors;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.PositionTracker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InplaceChangeSignature
implements DocumentListener {
    public static final Key<InplaceChangeSignature> INPLACE_CHANGE_SIGNATURE = Key.create((String)"EditorInplaceChangeSignature");
    private ChangeInfo myCurrentInfo;
    private ChangeInfo myStableChange;
    private String myInitialSignature;
    private String myInitialName;
    private Editor myEditor;
    private LanguageChangeSignatureDetector<ChangeInfo> myDetector;
    private final Project myProject;
    private final PsiDocumentManager myDocumentManager;
    private final ArrayList<RangeHighlighter> myHighlighters;
    private StartMarkAction myMarkAction;
    private Balloon myBalloon;
    private boolean myDelegate;
    private EditorEx myPreview;

    public InplaceChangeSignature(Project project2, Editor editor, @NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/changeSignature/inplace/InplaceChangeSignature", "<init>"));
        }
        this.myHighlighters = new ArrayList();
        this.myDocumentManager = PsiDocumentManager.getInstance((Project)project2);
        this.myProject = project2;
        try {
            this.myMarkAction = StartMarkAction.start(editor, project2, ChangeSignatureHandler.REFACTORING_NAME);
        }
        catch (StartMarkAction.AlreadyStartedException e2) {
            int exitCode = Messages.showYesNoDialog((Project)this.myProject, (String)e2.getMessage(), (String)ChangeSignatureHandler.REFACTORING_NAME, (String)"Navigate to Started", (String)"Cancel", (Icon)Messages.getErrorIcon());
            if (exitCode == 2) {
                return;
            }
            PsiElement method2 = this.myStableChange.getMethod();
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)method2);
            new OpenFileDescriptor(project2, virtualFile, method2.getTextOffset()).navigate(true);
            return;
        }
        this.myEditor = editor;
        this.myDetector = (LanguageChangeSignatureDetector)LanguageChangeSignatureDetectors.INSTANCE.forLanguage(element.getLanguage());
        this.myStableChange = this.myDetector.createInitialChangeInfo(element);
        this.myInitialSignature = this.myDetector.extractSignature(this.myStableChange);
        this.myInitialName = DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myStableChange.getMethod());
        TextRange highlightingRange = this.myDetector.getHighlightingRange(this.myStableChange);
        HighlightManager highlightManager = HighlightManager.getInstance((Project)this.myProject);
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.LIVE_TEMPLATE_ATTRIBUTES);
        highlightManager.addRangeHighlight(editor, highlightingRange.getStartOffset(), highlightingRange.getEndOffset(), attributes, false, this.myHighlighters);
        for (RangeHighlighter highlighter2 : this.myHighlighters) {
            highlighter2.setGreedyToRight(true);
            highlighter2.setGreedyToLeft(true);
        }
        this.myEditor.getDocument().addDocumentListener((DocumentListener)this);
        this.myEditor.putUserData(INPLACE_CHANGE_SIGNATURE, (Object)this);
        this.myPreview = InplaceRefactoring.createPreviewComponent(project2, this.myDetector.getFileType());
        this.showBalloon();
    }

    @Nullable
    public static InplaceChangeSignature getCurrentRefactoring(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/changeSignature/inplace/InplaceChangeSignature", "getCurrentRefactoring"));
        }
        return (InplaceChangeSignature)editor.getUserData(INPLACE_CHANGE_SIGNATURE);
    }

    public ChangeInfo getCurrentInfo() {
        return this.myCurrentInfo;
    }

    public String getInitialName() {
        return this.myInitialName;
    }

    public String getInitialSignature() {
        return this.myInitialSignature;
    }

    @NotNull
    public ChangeInfo getStableChange() {
        ChangeInfo changeInfo = this.myStableChange;
        if (changeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/changeSignature/inplace/InplaceChangeSignature", "getStableChange"));
        }
        return changeInfo;
    }

    public void cancel() {
        TextRange highlightingRange = this.myDetector.getHighlightingRange(this.getStableChange());
        Document document = this.myEditor.getDocument();
        String initialSignature = this.myInitialSignature;
        this.detach();
        InplaceChangeSignature.temporallyRevertChanges(highlightingRange, document, initialSignature, this.myProject);
    }

    public void beforeDocumentChange(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        RangeMarker marker = event.getDocument().createRangeMarker(event.getOffset(), event.getOffset());
        this.myDocumentManager.performWhenAllCommitted(() -> {
            if (this.myDetector == null) {
                return;
            }
            PsiFile file2 = this.myDocumentManager.getPsiFile(event.getDocument());
            if (file2 == null) {
                return;
            }
            PsiElement element = file2.findElementAt(marker.getStartOffset());
            marker.dispose();
            if (element == null || this.myDetector.ignoreChanges(element)) {
                return;
            }
            if (element instanceof PsiWhiteSpace) {
                PsiElement method2 = this.myStableChange.getMethod();
                if (PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class}) == method2) {
                    return;
                }
            }
            if (!this.myDetector.isChangeSignatureAvailableOnElement(element, this.myStableChange)) {
                this.detach();
                return;
            }
            this.updateCurrentInfo();
        });
    }

    private void updateCurrentInfo() {
        String signature;
        ChangeInfo changeInfo;
        if (this.myCurrentInfo == null) {
            this.myCurrentInfo = this.myStableChange;
        }
        if ((changeInfo = this.myDetector.createNextChangeInfo(signature = this.myDetector.extractSignature(this.myCurrentInfo), this.myCurrentInfo, this.myDelegate)) == null && this.myCurrentInfo != null) {
            this.myStableChange = this.myCurrentInfo;
        }
        if (changeInfo != null) {
            this.updateMethodSignature(changeInfo);
        }
        this.myCurrentInfo = changeInfo;
    }

    private void updateMethodSignature(ChangeInfo changeInfo) {
        ArrayList<TextRange> deleteRanges = new ArrayList<TextRange>();
        ArrayList<TextRange> newRanges = new ArrayList<TextRange>();
        final String methodSignature = this.myDetector.getMethodSignaturePreview(changeInfo, deleteRanges, newRanges);
        this.myPreview.getMarkupModel().removeAllHighlighters();
        new WriteCommandAction(null, new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/refactoring/changeSignature/inplace/InplaceChangeSignature$1", "run"));
                }
                InplaceChangeSignature.this.myPreview.getDocument().replaceString(0, InplaceChangeSignature.this.myPreview.getDocument().getTextLength(), methodSignature);
            }
        }.execute();
        TextAttributes deprecatedAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.DEPRECATED_ATTRIBUTES);
        for (TextRange range : deleteRanges) {
            this.myPreview.getMarkupModel().addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 3000, deprecatedAttributes, HighlighterTargetArea.EXACT_RANGE);
        }
        TextAttributes todoAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.TODO_DEFAULT_ATTRIBUTES);
        for (TextRange range : newRanges) {
            this.myPreview.getMarkupModel().addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 3000, todoAttributes, HighlighterTargetArea.EXACT_RANGE);
        }
    }

    protected void showBalloon() {
        NonFocusableCheckBox checkBox2 = new NonFocusableCheckBox(RefactoringBundle.message((String)"delegation.panel.delegate.via.overloading.method"));
        checkBox2.addActionListener(e2 -> {
            this.myDelegate = checkBox2.isSelected();
            this.updateCurrentInfo();
        });
        JPanel content2 = new JPanel(new BorderLayout());
        content2.add((Component)new JBLabel("Performed signature modifications:"), "North");
        content2.add((Component)this.myPreview.getComponent(), "Center");
        this.updateMethodSignature(this.myStableChange);
        content2.add((Component)checkBox2, "South");
        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createDialogBalloonBuilder((JComponent)content2, null).setSmallVariant(true);
        this.myBalloon = balloonBuilder.createBalloon();
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        this.myBalloon.show((PositionTracker)new PositionTracker<Balloon>((Component)this.myEditor.getContentComponent()){

            public RelativePoint recalculateLocation(Balloon object) {
                int offset = InplaceChangeSignature.this.myStableChange.getMethod().getTextOffset();
                VisualPosition visualPosition = InplaceChangeSignature.this.myEditor.offsetToVisualPosition(offset);
                Point point = InplaceChangeSignature.this.myEditor.visualPositionToXY(new VisualPosition(visualPosition.line, visualPosition.column));
                return new RelativePoint((Component)InplaceChangeSignature.this.myEditor.getContentComponent(), point);
            }
        }, Balloon.Position.above);
        Disposer.register((Disposable)this.myBalloon, () -> {
            EditorFactory.getInstance().releaseEditor((Editor)this.myPreview);
            this.myPreview = null;
        });
    }

    public void detach() {
        this.myEditor.getDocument().removeDocumentListener((DocumentListener)this);
        HighlightManager highlightManager = HighlightManager.getInstance((Project)this.myProject);
        for (RangeHighlighter highlighter2 : this.myHighlighters) {
            highlightManager.removeSegmentHighlighter(this.myEditor, highlighter2);
        }
        this.myHighlighters.clear();
        this.myBalloon.hide();
        this.myDetector = null;
        FinishMarkAction.finish(this.myProject, this.myEditor, this.myMarkAction);
        this.myEditor.putUserData(INPLACE_CHANGE_SIGNATURE, null);
    }

    public static void temporallyRevertChanges(TextRange signatureRange, Document document, String initialSignature, Project project2) {
        WriteCommandAction.runWriteCommandAction((Project)project2, () -> {
            document.replaceString(signatureRange.getStartOffset(), signatureRange.getEndOffset(), (CharSequence)initialSignature);
            PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
        });
    }
}

