/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractSuperclass;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.ui.DocCommentPanel;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.RecentsManager;
import com.intellij.util.IncorrectOperationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public abstract class ExtractSuperBaseDialog<ClassType extends PsiElement, MemberInfoType extends MemberInfoBase>
extends RefactoringDialog {
    private final String myRefactoringName;
    protected final ClassType mySourceClass;
    protected PsiDirectory myTargetDirectory;
    protected final List<MemberInfoType> myMemberInfos;
    private JRadioButton myRbExtractSuperclass;
    private JRadioButton myRbExtractSubclass;
    private JTextField mySourceClassField;
    private JLabel myClassNameLabel;
    private JTextField myExtractedSuperNameField;
    protected JLabel myPackageNameLabel;
    protected ComponentWithBrowseButton myPackageNameField;
    protected DocCommentPanel myDocCommentPanel;
    private JPanel myDestinationRootPanel;

    protected abstract ComponentWithBrowseButton createPackageNameField();

    protected JPanel createDestinationRootPanel() {
        return null;
    }

    protected abstract JTextField createSourceClassField();

    protected abstract String getDocCommentPanelName();

    protected abstract String getExtractedSuperNameNotSpecifiedMessage();

    protected abstract BaseRefactoringProcessor createProcessor();

    protected abstract int getDocCommentPolicySetting();

    protected abstract void setDocCommentPolicySetting(int var1);

    protected abstract String getHelpId();

    @Nullable
    protected abstract String validateName(String var1);

    @Nullable
    protected String validateQualifiedName(String packageName, String extractedSuperName) {
        return null;
    }

    protected abstract String getTopLabelText();

    protected abstract String getClassNameLabelText();

    protected abstract String getPackageNameLabelText();

    protected abstract String getEntityName();

    protected abstract void preparePackage() throws OperationFailedException;

    protected abstract String getDestinationPackageRecentKey();

    public ExtractSuperBaseDialog(Project project2, ClassType sourceClass, List<MemberInfoType> members, String refactoringName) {
        super(project2, true);
        this.myRefactoringName = refactoringName;
        this.mySourceClass = sourceClass;
        this.myMemberInfos = members;
        this.myTargetDirectory = this.mySourceClass.getContainingFile().getContainingDirectory();
    }

    protected void init() {
        this.setTitle(this.myRefactoringName);
        this.myPackageNameField = this.createPackageNameField();
        this.myDestinationRootPanel = this.createDestinationRootPanel();
        this.mySourceClassField = this.createSourceClassField();
        this.myExtractedSuperNameField = this.createExtractedSuperNameField();
        this.myDocCommentPanel = new DocCommentPanel(this.getDocCommentPanelName());
        this.myDocCommentPanel.setPolicy(this.getDocCommentPolicySetting());
        super.init();
        this.updateDialog();
    }

    protected JTextField createExtractedSuperNameField() {
        return new JTextField();
    }

    protected JComponent createActionComponent() {
        Box box = Box.createHorizontalBox();
        String s2 = StringUtil.decapitalize((String)this.getEntityName());
        this.myRbExtractSuperclass = new JRadioButton();
        this.myRbExtractSuperclass.setText(RefactoringBundle.message((String)"extractSuper.extract", (Object[])new Object[]{s2}));
        this.myRbExtractSubclass = new JRadioButton();
        this.myRbExtractSubclass.setText(RefactoringBundle.message((String)"extractSuper.rename.original.class", (Object[])new Object[]{s2}));
        this.myRbExtractSubclass.setEnabled(this.isPossibleToRenameOriginal());
        box.add(this.myRbExtractSuperclass);
        box.add(this.myRbExtractSubclass);
        box.add(Box.createHorizontalGlue());
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.myRbExtractSuperclass);
        buttonGroup2.add(this.myRbExtractSubclass);
        this.customizeRadiobuttons(box, buttonGroup2);
        this.myRbExtractSuperclass.setSelected(true);
        ItemListener listener2 = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                ExtractSuperBaseDialog.this.updateDialog();
            }
        };
        this.myRbExtractSuperclass.addItemListener(listener2);
        this.myRbExtractSubclass.addItemListener(listener2);
        return box;
    }

    protected boolean isPossibleToRenameOriginal() {
        return true;
    }

    protected void customizeRadiobuttons(Box box, ButtonGroup buttonGroup2) {
    }

    protected JComponent createNorthPanel() {
        Box box = Box.createVerticalBox();
        JPanel _panel = new JPanel(new BorderLayout());
        _panel.add((Component)new JLabel(this.getTopLabelText()), "North");
        _panel.add((Component)this.mySourceClassField, "Center");
        box.add(_panel);
        box.add(Box.createVerticalStrut(10));
        box.add(this.createActionComponent());
        box.add(Box.createVerticalStrut(10));
        this.myClassNameLabel = new JLabel();
        _panel = new JPanel(new BorderLayout());
        _panel.add((Component)this.myClassNameLabel, "North");
        _panel.add((Component)this.myExtractedSuperNameField, "Center");
        box.add(_panel);
        box.add(Box.createVerticalStrut(5));
        _panel = new JPanel(new BorderLayout());
        this.myPackageNameLabel = new JLabel();
        _panel.add((Component)this.myPackageNameLabel, "North");
        _panel.add((Component)this.myPackageNameField, "Center");
        if (this.myDestinationRootPanel != null) {
            _panel.add((Component)this.myDestinationRootPanel, "South");
        }
        box.add(_panel);
        box.add(Box.createVerticalStrut(10));
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)box, "Center");
        return panel2;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myExtractedSuperNameField;
    }

    protected void updateDialog() {
        this.myClassNameLabel.setText(this.getClassNameLabelText());
        this.myPackageNameLabel.setText(this.getPackageNameLabelText());
        this.getPreviewAction().setEnabled(!this.isExtractSuperclass());
    }

    public String getExtractedSuperName() {
        return this.myExtractedSuperNameField.getText().trim();
    }

    protected abstract String getTargetPackageName();

    public PsiDirectory getTargetDirectory() {
        return this.myTargetDirectory;
    }

    public int getDocCommentPolicy() {
        return this.myDocCommentPanel.getPolicy();
    }

    public boolean isExtractSuperclass() {
        return this.myRbExtractSuperclass != null && this.myRbExtractSuperclass.isSelected();
    }

    @Override
    protected void doAction() {
        String[] errorString = new String[]{null};
        String extractedSuperName = this.getExtractedSuperName();
        String packageName = this.getTargetPackageName();
        RecentsManager.getInstance(this.myProject).registerRecentEntry(this.getDestinationPackageRecentKey(), packageName);
        if (extractedSuperName != null && extractedSuperName.isEmpty()) {
            errorString[0] = this.getExtractedSuperNameNotSpecifiedMessage();
            this.myExtractedSuperNameField.requestFocusInWindow();
        } else {
            String nameError = this.validateName(extractedSuperName);
            if (nameError == null) {
                nameError = this.validateQualifiedName(packageName, extractedSuperName);
            }
            if (nameError != null) {
                errorString[0] = nameError;
                this.myExtractedSuperNameField.requestFocusInWindow();
            } else {
                CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
                    try {
                        this.preparePackage();
                    }
                    catch (OperationFailedException | IncorrectOperationException e2) {
                        errorString[0] = e2.getMessage();
                        this.myPackageNameField.requestFocusInWindow();
                    }
                }, RefactoringBundle.message((String)"create.directory"), null);
            }
        }
        if (errorString[0] != null) {
            if (errorString[0].length() > 0) {
                CommonRefactoringUtil.showErrorMessage((String)this.myRefactoringName, (String)errorString[0], (String)this.getHelpId(), (Project)this.myProject);
            }
            return;
        }
        if (!this.checkConflicts()) {
            return;
        }
        this.executeRefactoring();
        this.setDocCommentPolicySetting(this.getDocCommentPolicy());
        this.closeOKAction();
    }

    protected void executeRefactoring() {
        if (!this.isExtractSuperclass()) {
            this.invokeRefactoring(this.createProcessor());
        }
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(this.getHelpId());
    }

    protected boolean checkConflicts() {
        return true;
    }

    public Collection<MemberInfoType> getSelectedMemberInfos() {
        ArrayList<MemberInfoBase> result2 = new ArrayList<MemberInfoBase>(this.myMemberInfos.size());
        for (MemberInfoBase info : this.myMemberInfos) {
            if (!info.isChecked()) continue;
            result2.add(info);
        }
        return result2;
    }

    protected static class OperationFailedException
    extends Exception {
        public OperationFailedException(String message2) {
            super(message2);
        }
    }
}

