/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduce;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.introduce.IntroduceTarget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiIntroduceTarget<T extends PsiElement>
implements IntroduceTarget {
    @NotNull
    protected final SmartPsiElementPointer<T> myPointer;

    public PsiIntroduceTarget(@NotNull T psi) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/refactoring/introduce/PsiIntroduceTarget", "<init>"));
        }
        this.myPointer = SmartPointerManager.getInstance((Project)psi.getProject()).createSmartPsiElementPointer(psi);
    }

    @Override
    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.getPlace().getTextRange();
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/introduce/PsiIntroduceTarget", "getTextRange"));
        }
        return textRange;
    }

    @Nullable
    public T getPlace() {
        return (T)this.myPointer.getElement();
    }

    @Override
    @NotNull
    public String render() {
        String string2 = this.getPlace().getText();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/introduce/PsiIntroduceTarget", "render"));
        }
        return string2;
    }

    @Override
    public boolean isValid() {
        return this.myPointer.getElement() != null;
    }
}

