/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduce.inplace;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class OccurrencesChooser<T> {
    private final Set<RangeHighlighter> myRangeHighlighters = new HashSet<RangeHighlighter>();
    private final Editor myEditor;
    private final TextAttributes myAttributes;

    public static <T extends PsiElement> OccurrencesChooser<T> simpleChooser(Editor editor) {
        return new OccurrencesChooser<T>(editor){

            @Override
            protected TextRange getOccurrenceRange(T occurrence) {
                return occurrence.getTextRange();
            }
        };
    }

    public OccurrencesChooser(Editor editor) {
        this.myEditor = editor;
        this.myAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
    }

    public void showChooser(T selectedOccurrence, List<T> allOccurrences, Pass<ReplaceChoice> callback) {
        if (allOccurrences.size() == 1) {
            callback.pass((Object)ReplaceChoice.ALL);
        } else {
            LinkedHashMap occurrencesMap = ContainerUtil.newLinkedHashMap();
            occurrencesMap.put(ReplaceChoice.NO, Collections.singletonList(selectedOccurrence));
            occurrencesMap.put(ReplaceChoice.ALL, allOccurrences);
            this.showChooser(callback, occurrencesMap);
        }
    }

    public void showChooser(Pass<ReplaceChoice> callback, final Map<ReplaceChoice, List<T>> occurrencesMap) {
        if (occurrencesMap.size() == 1) {
            callback.pass((Object)occurrencesMap.keySet().iterator().next());
            return;
        }
        DefaultListModel<ReplaceChoice> model2 = new DefaultListModel<ReplaceChoice>();
        for (ReplaceChoice choice : occurrencesMap.keySet()) {
            model2.addElement(choice);
        }
        JBList list2 = new JBList(model2);
        list2.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                Component rendererComponent = super.getListCellRendererComponent((JList<?>)list2, value2, index, isSelected, cellHasFocus);
                ReplaceChoice choices = (ReplaceChoice)((Object)value2);
                if (choices != null) {
                    String text2 = choices.getDescription();
                    if (choices == ReplaceChoice.ALL) {
                        text2 = MessageFormat.format(text2, ((List)occurrencesMap.get((Object)choices)).size());
                    }
                    this.setText(text2);
                }
                return rendererComponent;
            }
        });
        list2.addListSelectionListener(new ListSelectionListener((JList)list2, occurrencesMap){
            final /* synthetic */ JList val$list;
            final /* synthetic */ Map val$occurrencesMap;
            {
                this.val$list = jList;
                this.val$occurrencesMap = map2;
            }

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                ReplaceChoice value2 = (ReplaceChoice)((Object)this.val$list.getSelectedValue());
                if (value2 == null) {
                    return;
                }
                OccurrencesChooser.this.dropHighlighters();
                MarkupModel markupModel = OccurrencesChooser.this.myEditor.getMarkupModel();
                List occurrenceList = (List)this.val$occurrencesMap.get((Object)value2);
                for (Object occurrence : occurrenceList) {
                    TextRange textRange = OccurrencesChooser.this.getOccurrenceRange(occurrence);
                    RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(textRange.getStartOffset(), textRange.getEndOffset(), 5999, OccurrencesChooser.this.myAttributes, HighlighterTargetArea.EXACT_RANGE);
                    OccurrencesChooser.this.myRangeHighlighters.add(rangeHighlighter);
                }
            }
        });
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list2).setTitle("Multiple occurrences found").setMovable(true).setResizable(false).setRequestFocus(true).setItemChoosenCallback(() -> OccurrencesChooser.lambda$showChooser$0(callback, (JList)list2)).addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(LightweightWindowEvent event) {
                OccurrencesChooser.this.dropHighlighters();
            }
        }).createPopup().showInBestPositionFor(this.myEditor);
    }

    protected abstract TextRange getOccurrenceRange(T var1);

    private void dropHighlighters() {
        for (RangeHighlighter highlight : this.myRangeHighlighters) {
            highlight.dispose();
        }
        this.myRangeHighlighters.clear();
    }

    private static /* synthetic */ void lambda$showChooser$0(Pass callback, JList list2) {
        callback.pass((Object)((ReplaceChoice)((Object)list2.getSelectedValue())));
    }

    public static enum ReplaceChoice {
        NO("Replace this occurrence only"),
        NO_WRITE("Replace all occurrences but write"),
        ALL("Replace all {0} occurrences");

        private final String myDescription;

        private ReplaceChoice(String description) {
            this.myDescription = description;
        }

        public String getDescription() {
            return this.myDescription;
        }
    }
}

