/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.memberPullUp;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.AbstractMemberInfoStorage;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.ui.AbstractMemberSelectionTable;
import com.intellij.refactoring.ui.MemberSelectionPanelBase;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.usageView.UsageViewUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public abstract class PullUpDialogBase<Storage extends AbstractMemberInfoStorage<Member, Class, MemberInfo>, MemberInfo extends MemberInfoBase<Member>, Member extends PsiElement, Class extends PsiElement>
extends RefactoringDialog {
    protected MemberSelectionPanelBase<Member, MemberInfo, AbstractMemberSelectionTable<Member, MemberInfo>> myMemberSelectionPanel;
    protected MemberInfoModel<Member, MemberInfo> myMemberInfoModel;
    protected final Class myClass;
    protected final List<Class> mySuperClasses;
    protected final Storage myMemberInfoStorage;
    protected List<MemberInfo> myMemberInfos;
    private JComboBox myClassCombo;

    public PullUpDialogBase(Project project2, Class aClass, List<Class> superClasses, Storage memberInfoStorage, String title) {
        super(project2, true);
        this.myClass = aClass;
        this.mySuperClasses = superClasses;
        this.myMemberInfoStorage = memberInfoStorage;
        this.myMemberInfos = ((AbstractMemberInfoStorage)this.myMemberInfoStorage).getClassMemberInfos(aClass);
        this.setTitle(title);
    }

    @Nullable
    public Class getSuperClass() {
        if (this.myClassCombo != null) {
            return (Class)((PsiElement)this.myClassCombo.getSelectedItem());
        }
        return null;
    }

    public List<MemberInfo> getSelectedMemberInfos() {
        ArrayList<MemberInfoBase> list2 = new ArrayList<MemberInfoBase>(this.myMemberInfos.size());
        for (MemberInfoBase info : this.myMemberInfos) {
            if (!info.isChecked() || !this.myMemberInfoModel.isMemberEnabled(info)) continue;
            list2.add(info);
        }
        return list2;
    }

    protected JComponent createNorthPanel() {
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = new Insets(4, 0, 4, 8);
        gbConstraints.weighty = 1.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 1;
        gbConstraints.anchor = 17;
        JLabel classComboLabel = new JLabel();
        panel2.add((Component)classComboLabel, gbConstraints);
        this.myClassCombo = new JComboBox<Object>(this.mySuperClasses.toArray());
        this.initClassCombo(this.myClassCombo);
        classComboLabel.setText(RefactoringBundle.message((String)"pull.up.members.to", (Object[])new Object[]{UsageViewUtil.getLongName(this.myClass)}));
        classComboLabel.setLabelFor(this.myClassCombo);
        Class preselection = this.getPreselection();
        int indexToSelect = 0;
        if (preselection != null) {
            indexToSelect = this.mySuperClasses.indexOf(preselection);
        }
        this.myClassCombo.setSelectedIndex(indexToSelect);
        this.myClassCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                if (e2.getStateChange() == 1) {
                    PullUpDialogBase.this.updateMemberInfo();
                }
            }
        });
        ++gbConstraints.gridy;
        panel2.add((Component)this.myClassCombo, gbConstraints);
        return panel2;
    }

    protected abstract void initClassCombo(JComboBox var1);

    protected abstract Class getPreselection();

    protected void updateMemberInfo() {
        PsiElement targetClass = (PsiElement)this.myClassCombo.getSelectedItem();
        this.myMemberInfos = ((AbstractMemberInfoStorage)this.myMemberInfoStorage).getIntermediateMemberInfosList((PsiElement)targetClass);
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        this.myMemberSelectionPanel = new MemberSelectionPanelBase(RefactoringBundle.message((String)"members.to.be.pulled.up"), this.createMemberSelectionTable(this.myMemberInfos));
        this.myMemberInfoModel = this.createMemberInfoModel();
        this.myMemberInfoModel.memberInfoChanged(new MemberInfoChange(this.myMemberInfos));
        this.myMemberSelectionPanel.getTable().setMemberInfoModel(this.myMemberInfoModel);
        this.myMemberSelectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener<Member, MemberInfo>)this.myMemberInfoModel);
        panel2.add(this.myMemberSelectionPanel, "Center");
        this.addCustomElementsToCentralPanel(panel2);
        this.updateMemberInfo();
        return panel2;
    }

    protected void addCustomElementsToCentralPanel(JPanel panel2) {
    }

    protected abstract AbstractMemberSelectionTable<Member, MemberInfo> createMemberSelectionTable(List<MemberInfo> var1);

    protected abstract MemberInfoModel<Member, MemberInfo> createMemberInfoModel();
}

