/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FileReferenceContextUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.FileReferenceContextUtil");
    private static final Key<PsiFileSystemItem> REF_FILE_SYSTEM_ITEM_KEY = Key.create((String)"REF_FILE_SYSTEM_ITEM_KEY");

    private FileReferenceContextUtil() {
    }

    public static Map<String, PsiFileSystemItem> encodeFileReferences(PsiElement element) {
        HashMap map2 = new HashMap();
        if (element == null || element instanceof PsiCompiledElement || FileReferenceContextUtil.isBinary(element)) {
            return map2;
        }
        element.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(true, (Map)map2){
            final /* synthetic */ Map val$map;
            {
                this.val$map = map2;
                super(x0);
            }

            public void visitElement(PsiElement element) {
                PsiFileReference ref;
                PsiReference[] refs;
                if (element instanceof PsiLanguageInjectionHost) {
                    InjectedLanguageUtil.enumerate(element, new PsiLanguageInjectionHost.InjectedPsiVisitor(){

                        public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                            if (injectedPsi == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/intellij/refactoring/move/FileReferenceContextUtil$1$1", "visit"));
                            }
                            if (places == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "places", "com/intellij/refactoring/move/FileReferenceContextUtil$1$1", "visit"));
                            }
                            FileReferenceContextUtil.encodeFileReferences((PsiElement)injectedPsi);
                        }
                    });
                }
                if ((refs = element.getReferences()).length > 0 && refs[0] instanceof FileReferenceOwner && (ref = ((FileReferenceOwner)refs[0]).getLastFileReference()) != null) {
                    ResolveResult[] results;
                    for (ResolveResult result2 : results = ref.multiResolve(false)) {
                        if (!(result2.getElement() instanceof PsiFileSystemItem)) continue;
                        PsiFileSystemItem fileSystemItem = (PsiFileSystemItem)result2.getElement();
                        element.putCopyableUserData(REF_FILE_SYSTEM_ITEM_KEY, (Object)fileSystemItem);
                        this.val$map.put(element.getText(), fileSystemItem);
                        break;
                    }
                }
                super.visitElement(element);
            }
        });
        return map2;
    }

    private static boolean isBinary(PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        return containingFile == null || containingFile.getFileType().isBinary();
    }

    public static void decodeFileReferences(PsiElement element) {
        if (element == null || element instanceof PsiCompiledElement || FileReferenceContextUtil.isBinary(element)) {
            return;
        }
        element.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(true){

            public void visitElement(PsiElement element) {
                PsiFileSystemItem item = (PsiFileSystemItem)element.getCopyableUserData(REF_FILE_SYSTEM_ITEM_KEY);
                element.putCopyableUserData(REF_FILE_SYSTEM_ITEM_KEY, null);
                element = FileReferenceContextUtil.bindElement(element, item);
                if (element != null) {
                    element.acceptChildren((PsiElementVisitor)this);
                }
                if (element instanceof PsiLanguageInjectionHost) {
                    InjectedLanguageUtil.enumerate(element, new PsiLanguageInjectionHost.InjectedPsiVisitor(){

                        public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                            if (injectedPsi == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/intellij/refactoring/move/FileReferenceContextUtil$2$1", "visit"));
                            }
                            if (places == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "places", "com/intellij/refactoring/move/FileReferenceContextUtil$2$1", "visit"));
                            }
                            FileReferenceContextUtil.decodeFileReferences((PsiElement)injectedPsi);
                        }
                    });
                }
            }
        });
    }

    public static void decodeFileReferences(PsiElement element, final Map<String, PsiFileSystemItem> map2, final TextRange range) {
        if (element == null || element instanceof PsiCompiledElement || FileReferenceContextUtil.isBinary(element)) {
            return;
        }
        element.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(true){

            public void visitElement(PsiElement element) {
                if (!range.intersects(element.getTextRange())) {
                    return;
                }
                String text2 = element.getText();
                PsiFileSystemItem item = (PsiFileSystemItem)map2.get(text2);
                element.putCopyableUserData(REF_FILE_SYSTEM_ITEM_KEY, (Object)item);
                element.acceptChildren((PsiElementVisitor)this);
            }
        });
        FileReferenceContextUtil.decodeFileReferences(element);
    }

    private static PsiElement bindElement(PsiElement element, PsiFileSystemItem item) {
        if (item != null && item.isValid() && item.getVirtualFile() != null) {
            PsiReference[] refs;
            for (PsiReference ref : refs = element.getReferences()) {
                if (!(ref instanceof FileReferenceOwner)) continue;
                PsiFileReference fileReference = ((FileReferenceOwner)refs[0]).getLastFileReference();
                if (fileReference == null) break;
                try {
                    PsiElement newElement = fileReference.bindToElement((PsiElement)item);
                    if (newElement != null) {
                        LOG.assertTrue(element.getClass() == newElement.getClass(), (Object)("Reference " + ref + " violated contract of bindToElement()"));
                    }
                    return newElement;
                }
                catch (IncorrectOperationException e2) {
                    LOG.error((Throwable)e2);
                    break;
                }
            }
        }
        return element;
    }
}

