/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveHandler
implements RefactoringActionHandler {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"move.title");

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/move/MoveHandler", "invoke"));
        }
        int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = file2.findElementAt(offset);
        if (element == null) {
            element = file2;
        }
        while (true) {
            PsiElement refElement;
            int relative;
            PsiReference reference;
            if (element == null) {
                String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"the.caret.should.be.positioned.at.the.class.method.or.field.to.be.refactored"));
                CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message2, (String)REFACTORING_NAME, null);
                return;
            }
            if (MoveHandler.tryToMoveElement(element, project2, dataContext, null, editor)) {
                return;
            }
            TextRange range = element.getTextRange();
            if (range != null && (reference = element.findReferenceAt(relative = offset - range.getStartOffset())) != null && (refElement = reference.resolve()) != null && MoveHandler.tryToMoveElement(refElement, project2, dataContext, reference, editor)) {
                return;
            }
            element = element.getParent();
        }
    }

    private static boolean tryToMoveElement(PsiElement element, Project project2, DataContext dataContext, PsiReference reference, Editor editor) {
        for (MoveHandlerDelegate delegate2 : (MoveHandlerDelegate[])Extensions.getExtensions(MoveHandlerDelegate.EP_NAME)) {
            if (!delegate2.tryToMove(element, project2, dataContext, reference, editor)) continue;
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/move/MoveHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/move/MoveHandler", "invoke"));
        }
        PsiElement targetContainer = dataContext == null ? null : (PsiElement)LangDataKeys.TARGET_PSI_ELEMENT.getData(dataContext);
        HashSet<PsiElement> filesOrDirs = new HashSet<PsiElement>();
        for (MoveHandlerDelegate moveHandlerDelegate : (MoveHandlerDelegate[])Extensions.getExtensions(MoveHandlerDelegate.EP_NAME)) {
            if (!moveHandlerDelegate.canMove(dataContext) || !moveHandlerDelegate.isValidTarget(targetContainer, elements)) continue;
            moveHandlerDelegate.collectFilesOrDirsFromContext(dataContext, filesOrDirs);
        }
        if (!filesOrDirs.isEmpty()) {
            for (MoveHandlerDelegate moveHandlerDelegate : elements) {
                if (moveHandlerDelegate instanceof PsiDirectory) {
                    filesOrDirs.add((PsiElement)moveHandlerDelegate);
                    continue;
                }
                PsiFile containingFile = moveHandlerDelegate.getContainingFile();
                if (containingFile == null) continue;
                filesOrDirs.add((PsiElement)containingFile);
            }
            MoveFilesOrDirectoriesUtil.doMove(project2, PsiUtilCore.toPsiElementArray(filesOrDirs), new PsiElement[]{targetContainer}, null);
            return;
        }
        MoveHandler.doMove(project2, elements, targetContainer, dataContext, null);
    }

    public static void doMove(Project project2, @NotNull PsiElement[] elements, PsiElement targetContainer, DataContext dataContext, MoveCallback callback) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/move/MoveHandler", "doMove"));
        }
        if (elements.length == 0) {
            return;
        }
        for (MoveHandlerDelegate delegate2 : (MoveHandlerDelegate[])Extensions.getExtensions(MoveHandlerDelegate.EP_NAME)) {
            if (!delegate2.canMove(elements, targetContainer)) continue;
            delegate2.doMove(project2, elements, delegate2.adjustTargetForMove(dataContext, targetContainer), callback);
            break;
        }
    }

    @Nullable
    public static PsiElement[] adjustForMove(Project project2, PsiElement[] sourceElements, PsiElement targetElement) {
        for (MoveHandlerDelegate delegate2 : (MoveHandlerDelegate[])Extensions.getExtensions(MoveHandlerDelegate.EP_NAME)) {
            if (!delegate2.canMove(sourceElements, targetElement)) continue;
            return delegate2.adjustForMove(project2, sourceElements, targetElement);
        }
        return sourceElements;
    }

    public static boolean canMove(@NotNull PsiElement[] elements, PsiElement targetContainer) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/move/MoveHandler", "canMove"));
        }
        for (MoveHandlerDelegate delegate2 : (MoveHandlerDelegate[])Extensions.getExtensions(MoveHandlerDelegate.EP_NAME)) {
            if (!delegate2.canMove(elements, targetContainer)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidTarget(PsiElement psiElement, PsiElement[] elements) {
        if (psiElement != null) {
            for (MoveHandlerDelegate delegate2 : (MoveHandlerDelegate[])Extensions.getExtensions(MoveHandlerDelegate.EP_NAME)) {
                if (!delegate2.isValidTarget(psiElement, elements)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canMove(DataContext dataContext) {
        for (MoveHandlerDelegate delegate2 : (MoveHandlerDelegate[])Extensions.getExtensions(MoveHandlerDelegate.EP_NAME)) {
            if (!delegate2.canMove(dataContext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMoveRedundant(PsiElement source, PsiElement target) {
        for (MoveHandlerDelegate delegate2 : (MoveHandlerDelegate[])Extensions.getExtensions(MoveHandlerDelegate.EP_NAME)) {
            if (!delegate2.isMoveRedundant(source, target)) continue;
            return true;
        }
        return false;
    }
}

