/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.safeDelete.SafeDeleteDialog;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegate;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegateBase;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SafeDeleteHandler
implements RefactoringActionHandler {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"safe.delete.title");

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/safeDelete/SafeDeleteHandler", "invoke"));
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        if (element == null || !SafeDeleteProcessor.validElement(element)) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"is.not.supported.in.the.current.context", (Object[])new Object[]{REFACTORING_NAME}));
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message2, (String)REFACTORING_NAME, (String)"refactoring.safeDelete");
            return;
        }
        this.invoke(project2, new PsiElement[]{element}, dataContext);
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/safeDelete/SafeDeleteHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/safeDelete/SafeDeleteHandler", "invoke"));
        }
        SafeDeleteHandler.invoke(project2, elements, (Module)LangDataKeys.MODULE.getData(dataContext), true, null);
    }

    public static void invoke(Project project2, PsiElement[] elements, boolean checkDelegates) {
        SafeDeleteHandler.invoke(project2, elements, checkDelegates, null);
    }

    public static void invoke(Project project2, PsiElement[] elements, boolean checkDelegates, @Nullable Runnable successRunnable) {
        SafeDeleteHandler.invoke(project2, elements, null, checkDelegates, successRunnable);
    }

    public static void invoke(final Project project2, PsiElement[] elements, @Nullable Module module2, boolean checkDelegates, final @Nullable Runnable successRunnable) {
        for (PsiElement psiElement : elements) {
            if (SafeDeleteProcessor.validElement(psiElement)) continue;
            return;
        }
        Object[] temptoDelete = PsiTreeUtil.filterAncestors((PsiElement[])elements);
        HashSet elementsSet = new HashSet(Arrays.asList(temptoDelete));
        LinkedHashSet<Object> fullElementsSet = new LinkedHashSet<Object>();
        if (checkDelegates) {
            for (Object element : temptoDelete) {
                boolean found = false;
                for (SafeDeleteProcessorDelegate delegate2 : (SafeDeleteProcessorDelegate[])Extensions.getExtensions(SafeDeleteProcessorDelegate.EP_NAME)) {
                    Collection<? extends PsiElement> addElements;
                    if (!delegate2.handlesElement((PsiElement)element)) continue;
                    found = true;
                    Collection<? extends PsiElement> collection = addElements = delegate2 instanceof SafeDeleteProcessorDelegateBase ? ((SafeDeleteProcessorDelegateBase)delegate2).getElementsToSearch((PsiElement)element, module2, (Collection<PsiElement>)elementsSet) : delegate2.getElementsToSearch((PsiElement)element, (Collection<PsiElement>)elementsSet);
                    if (addElements == null) {
                        return;
                    }
                    fullElementsSet.addAll(addElements);
                    break;
                }
                if (found) continue;
                fullElementsSet.add(element);
            }
        } else {
            ContainerUtil.addAll(fullElementsSet, (Object[])temptoDelete);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project2, fullElementsSet, (boolean)true)) {
            return;
        }
        final PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(fullElementsSet);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            RefactoringSettings settings = RefactoringSettings.getInstance();
            SafeDeleteProcessor.createInstance(project2, null, psiElementArray, settings.SAFE_DELETE_SEARCH_IN_COMMENTS, settings.SAFE_DELETE_SEARCH_IN_NON_JAVA, true).run();
            if (successRunnable != null) {
                successRunnable.run();
            }
        } else {
            SafeDeleteDialog.Callback callback = new SafeDeleteDialog.Callback(){

                @Override
                public void run(SafeDeleteDialog dialog2) {
                    SafeDeleteProcessor.createInstance(project2, () -> {
                        if (successRunnable != null) {
                            successRunnable.run();
                        }
                        dialog2.close(1);
                    }, psiElementArray, dialog2.isSearchInComments(), dialog2.isSearchForTextOccurences(), true).run();
                }
            };
            SafeDeleteDialog dialog2 = new SafeDeleteDialog(project2, psiElementArray, callback);
            dialog2.show();
        }
    }
}

