/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class CodeFragmentTableCellRenderer
implements TableCellRenderer {
    private final Project myProject;
    private final FileType myFileType;

    public CodeFragmentTableCellRenderer(Project project2) {
        this(project2, (FileType)StdFileTypes.JAVA);
    }

    public CodeFragmentTableCellRenderer(Project project2, FileType fileType) {
        this.myProject = project2;
        this.myFileType = fileType;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
        EditorTextField editorTextField;
        PsiCodeFragment codeFragment = (PsiCodeFragment)value2;
        Document document = null;
        if (codeFragment != null) {
            document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument((PsiFile)codeFragment);
            editorTextField = new EditorTextField(document, this.myProject, this.myFileType){

                @Override
                protected boolean shouldHaveBorder() {
                    return false;
                }
            };
        } else {
            editorTextField = new EditorTextField("", this.myProject, this.myFileType){

                @Override
                protected boolean shouldHaveBorder() {
                    return false;
                }
            };
        }
        if (!table2.isShowing()) {
            editorTextField.ensureWillComputePreferredSize();
        }
        editorTextField.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        editorTextField.setBorder(hasFocus || isSelected ? BorderFactory.createLineBorder(table2.getSelectionBackground()) : IdeBorderFactory.createEmptyBorder((int)1));
        if (isSelected && document != null) {
            Color bg = table2.getSelectionBackground();
            Color fg = table2.getSelectionForeground();
            editorTextField.setBackground(bg);
            editorTextField.setForeground(fg);
            editorTextField.setAsRendererWithSelection(bg, fg);
        }
        return editorTextField;
    }
}

