/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.FindUsagesUtil;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageInfoFactory;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class TextOccurrencesUtil {
    private TextOccurrencesUtil() {
    }

    public static void addTextOccurences(@NotNull PsiElement element, @NotNull String stringToSearch, @NotNull GlobalSearchScope searchScope, @NotNull Collection<UsageInfo> results, @NotNull UsageInfoFactory factory2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/util/TextOccurrencesUtil", "addTextOccurences"));
        }
        if (stringToSearch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringToSearch", "com/intellij/refactoring/util/TextOccurrencesUtil", "addTextOccurences"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/refactoring/util/TextOccurrencesUtil", "addTextOccurences"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/intellij/refactoring/util/TextOccurrencesUtil", "addTextOccurences"));
        }
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/refactoring/util/TextOccurrencesUtil", "addTextOccurences"));
        }
        PsiSearchHelperImpl.processTextOccurrences(element, stringToSearch, searchScope, (Processor<UsageInfo>)((Processor)t2 -> {
            if (results == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/intellij/refactoring/util/TextOccurrencesUtil", "lambda$addTextOccurences$0"));
            }
            results.add((UsageInfo)t2);
            return true;
        }), factory2);
    }

    private static boolean processStringLiteralsContainingIdentifier(@NotNull String identifier, @NotNull SearchScope searchScope, PsiSearchHelper helper, Processor<PsiElement> processor2) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/refactoring/util/TextOccurrencesUtil", "processStringLiteralsContainingIdentifier"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/refactoring/util/TextOccurrencesUtil", "processStringLiteralsContainingIdentifier"));
        }
        TextOccurenceProcessor occurenceProcessor = (element, offsetInElement) -> {
            ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(element.getLanguage());
            ASTNode node = element.getNode();
            if (definition != null && node != null && definition.getStringLiteralElements().contains(node.getElementType())) {
                return processor2.process((Object)element);
            }
            return true;
        };
        return helper.processElementsWithWord(occurenceProcessor, searchScope, identifier, (short)4, true);
    }

    public static boolean processUsagesInStringsAndComments(@NotNull PsiElement element, @NotNull String stringToSearch, boolean ignoreReferences, @NotNull PairProcessor<PsiElement, TextRange> processor2) {
        Processor commentOrLiteralProcessor;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/util/TextOccurrencesUtil", "processUsagesInStringsAndComments"));
        }
        if (stringToSearch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringToSearch", "com/intellij/refactoring/util/TextOccurrencesUtil", "processUsagesInStringsAndComments"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/refactoring/util/TextOccurrencesUtil", "processUsagesInStringsAndComments"));
        }
        PsiSearchHelper helper = PsiSearchHelper.SERVICE.getInstance((Project)element.getProject());
        SearchScope scope = helper.getUseScope(element);
        return TextOccurrencesUtil.processStringLiteralsContainingIdentifier(stringToSearch, scope = scope.intersectWith((SearchScope)GlobalSearchScope.projectScope((Project)element.getProject())), helper, (Processor<PsiElement>)(commentOrLiteralProcessor = literal -> {
            if (stringToSearch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringToSearch", "com/intellij/refactoring/util/TextOccurrencesUtil", "lambda$processUsagesInStringsAndComments$2"));
            }
            if (processor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/refactoring/util/TextOccurrencesUtil", "lambda$processUsagesInStringsAndComments$2"));
            }
            return TextOccurrencesUtil.processTextIn(literal, stringToSearch, ignoreReferences, processor2);
        })) && helper.processCommentsContainingIdentifier(stringToSearch, scope, commentOrLiteralProcessor);
    }

    public static void addUsagesInStringsAndComments(@NotNull PsiElement element, @NotNull String stringToSearch, @NotNull Collection<UsageInfo> results, @NotNull UsageInfoFactory factory2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/util/TextOccurrencesUtil", "addUsagesInStringsAndComments"));
        }
        if (stringToSearch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringToSearch", "com/intellij/refactoring/util/TextOccurrencesUtil", "addUsagesInStringsAndComments"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/intellij/refactoring/util/TextOccurrencesUtil", "addUsagesInStringsAndComments"));
        }
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/refactoring/util/TextOccurrencesUtil", "addUsagesInStringsAndComments"));
        }
        Object lock = new Object();
        TextOccurrencesUtil.processUsagesInStringsAndComments(element, stringToSearch, false, (PairProcessor<PsiElement, TextRange>)((PairProcessor)(commentOrLiteral, textRange) -> {
            if (factory2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/refactoring/util/TextOccurrencesUtil", "lambda$addUsagesInStringsAndComments$3"));
            }
            if (results == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/intellij/refactoring/util/TextOccurrencesUtil", "lambda$addUsagesInStringsAndComments$3"));
            }
            UsageInfo usageInfo = factory2.createUsageInfo(commentOrLiteral, textRange.getStartOffset(), textRange.getEndOffset());
            if (usageInfo != null) {
                Object object = lock;
                synchronized (object) {
                    results.add(usageInfo);
                }
            }
            return true;
        }));
    }

    private static boolean processTextIn(PsiElement scope, String stringToSearch, boolean ignoreReferences, PairProcessor<PsiElement, TextRange> processor2) {
        String text2 = scope.getText();
        for (int offset = 0; offset < text2.length() && (offset = text2.indexOf(stringToSearch, offset)) >= 0; ++offset) {
            char c2;
            PsiReference referenceAt = scope.findReferenceAt(offset);
            if (!ignoreReferences && referenceAt != null && (referenceAt.resolve() != null || referenceAt instanceof PsiPolyVariantReference && ((PsiPolyVariantReference)referenceAt).multiResolve(true).length > 0) || offset > 0 && Character.isJavaIdentifierPart(c2 = text2.charAt(offset - 1)) && c2 != '$' && (offset < 2 || text2.charAt(offset - 2) != '\\') || offset + stringToSearch.length() < text2.length() && Character.isJavaIdentifierPart(c2 = text2.charAt(offset + stringToSearch.length())) && c2 != '$') continue;
            TextRange textRange = new TextRange(offset, offset + stringToSearch.length());
            if (!processor2.process((Object)scope, (Object)textRange)) {
                return false;
            }
            offset += stringToSearch.length();
        }
        return true;
    }

    public static boolean isSearchTextOccurencesEnabled(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/util/TextOccurrencesUtil", "isSearchTextOccurencesEnabled"));
        }
        FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)element.getProject())).getFindUsagesManager();
        FindUsagesHandler handler2 = findUsagesManager.getFindUsagesHandler(element, true);
        return FindUsagesUtil.isSearchForTextOccurrencesAvailable(element, false, handler2);
    }

    public static void findNonCodeUsages(PsiElement element, String stringToSearch, boolean searchInStringsAndComments, boolean searchInNonJavaFiles, String newQName, Collection<UsageInfo> results) {
        if (searchInStringsAndComments || searchInNonJavaFiles) {
            UsageInfoFactory factory2 = TextOccurrencesUtil.createUsageInfoFactory(element, newQName);
            if (searchInStringsAndComments) {
                TextOccurrencesUtil.addUsagesInStringsAndComments(element, stringToSearch, results, factory2);
            }
            if (searchInNonJavaFiles) {
                GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)element.getProject());
                TextOccurrencesUtil.addTextOccurences(element, stringToSearch, projectScope, results, factory2);
            }
        }
    }

    private static UsageInfoFactory createUsageInfoFactory(PsiElement element, String newQName) {
        return (usage, startOffset, endOffset) -> {
            int start2 = usage.getTextRange().getStartOffset();
            return NonCodeUsageInfo.create((PsiFile)usage.getContainingFile(), (int)(start2 + startOffset), (int)(start2 + endOffset), (PsiElement)element, (String)newQName);
        };
    }
}

