/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum RemoteConnectionType {
    DEFAULT_SDK,
    DEPLOYMENT_SERVER,
    REMOTE_SDK,
    CURRENT_VAGRANT,
    NONE;

    private static final Logger LOG;

    @NotNull
    public static RemoteConnectionType findByName(@Nullable String name) {
        RemoteConnectionType remoteConnectionType;
        if (name == null) {
            RemoteConnectionType remoteConnectionType2 = NONE;
            if (remoteConnectionType2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remote/RemoteConnectionType", "findByName"));
            }
            return remoteConnectionType2;
        }
        try {
            remoteConnectionType = RemoteConnectionType.valueOf(name);
        }
        catch (Exception e2) {
            LOG.error("Cant find RemoteConnectionType with the name " + name, (Throwable)e2);
            RemoteConnectionType remoteConnectionType3 = NONE;
            if (remoteConnectionType3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remote/RemoteConnectionType", "findByName"));
            }
            return remoteConnectionType3;
        }
        if (remoteConnectionType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remote/RemoteConnectionType", "findByName"));
        }
        return remoteConnectionType;
    }

    static {
        LOG = Logger.getInstance(RemoteConnectionType.class);
    }
}

