/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.util.PasswordUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.remote.RemoteCredentials;
import com.intellij.util.xmlb.annotations.Transient;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class RemoteCredentialsHolder
implements MutableRemoteCredentials {
    public static final String HOST = "HOST";
    public static final String PORT = "PORT";
    public static final String ANONYMOUS = "ANONYMOUS";
    public static final String USERNAME = "USERNAME";
    public static final String PASSWORD = "PASSWORD";
    public static final String USE_KEY_PAIR = "USE_KEY_PAIR";
    public static final String PRIVATE_KEY_FILE = "PRIVATE_KEY_FILE";
    public static final String KNOWN_HOSTS_FILE = "MY_KNOWN_HOSTS_FILE";
    public static final String PASSPHRASE = "PASSPHRASE";
    public static final String SSH_PREFIX = "ssh://";
    private String myHost;
    private int myPort;
    private String myLiteralPort;
    private String myUserName;
    private String myPassword;
    private boolean myUseKeyPair;
    private String myPrivateKeyFile;
    private String myKnownHostsFile;
    private String myPassphrase;
    private boolean myStorePassword;
    private boolean myStorePassphrase;

    public static String getCredentialsString(@NotNull RemoteCredentials cred) {
        if (cred == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/intellij/remote/RemoteCredentialsHolder", "getCredentialsString"));
        }
        return SSH_PREFIX + cred.getUserName() + "@" + cred.getHost() + ":" + cred.getLiteralPort();
    }

    @Override
    public String getHost() {
        return this.myHost;
    }

    @Override
    public void setHost(String host) {
        this.myHost = host;
    }

    @Override
    public int getPort() {
        return this.myPort;
    }

    @Override
    public void setPort(int port) {
        this.myPort = port;
        this.myLiteralPort = Integer.toString(port);
    }

    @Override
    public String getLiteralPort() {
        return this.myLiteralPort;
    }

    @Override
    public void setLiteralPort(String portText) {
        this.myLiteralPort = portText;
        this.myPort = StringUtil.parseInt((String)portText, (int)0);
    }

    @Override
    @Transient
    public String getUserName() {
        return this.myUserName;
    }

    @Override
    public void setUserName(String userName) {
        this.myUserName = userName;
    }

    @Override
    public String getPassword() {
        return this.myPassword;
    }

    @Override
    public void setPassword(String password) {
        this.myPassword = password;
    }

    @Override
    public void setStorePassword(boolean storePassword) {
        this.myStorePassword = storePassword;
    }

    @Override
    public void setStorePassphrase(boolean storePassphrase) {
        this.myStorePassphrase = storePassphrase;
    }

    @Override
    public boolean isStorePassword() {
        return this.myStorePassword;
    }

    @Override
    public boolean isStorePassphrase() {
        return this.myStorePassphrase;
    }

    @Override
    public String getPrivateKeyFile() {
        return this.myPrivateKeyFile;
    }

    @Override
    public void setPrivateKeyFile(String privateKeyFile) {
        this.myPrivateKeyFile = privateKeyFile;
    }

    @Override
    public String getKnownHostsFile() {
        return this.myKnownHostsFile;
    }

    @Override
    public void setKnownHostsFile(String knownHostsFile) {
        this.myKnownHostsFile = knownHostsFile;
    }

    @Override
    @Transient
    public String getPassphrase() {
        return this.myPassphrase;
    }

    @Override
    public void setPassphrase(String passphrase) {
        this.myPassphrase = passphrase;
    }

    @Override
    public boolean isUseKeyPair() {
        return this.myUseKeyPair;
    }

    @Override
    public void setUseKeyPair(boolean useKeyPair) {
        this.myUseKeyPair = useKeyPair;
    }

    @NotNull
    public String getSerializedUserName() {
        if (this.myUserName == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remote/RemoteCredentialsHolder", "getSerializedUserName"));
            }
            return "";
        }
        String string2 = this.myUserName;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remote/RemoteCredentialsHolder", "getSerializedUserName"));
        }
        return string2;
    }

    public void setSerializedUserName(String userName) {
        this.myUserName = StringUtil.isEmpty((String)userName) ? null : userName;
    }

    @NotNull
    public String getSerializedPassword() {
        if (this.myStorePassword) {
            String string2 = PasswordUtil.encodePassword((String)this.myPassword);
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remote/RemoteCredentialsHolder", "getSerializedPassword"));
            }
            return string2;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remote/RemoteCredentialsHolder", "getSerializedPassword"));
        }
        return "";
    }

    public void setSerializedPassword(String serializedPassword) {
        if (!StringUtil.isEmpty((String)serializedPassword)) {
            this.myPassword = PasswordUtil.decodePassword((String)serializedPassword);
            this.myStorePassword = true;
        } else {
            this.myPassword = null;
        }
    }

    @NotNull
    public String getSerializedPassphrase() {
        if (this.myStorePassphrase) {
            String string2 = PasswordUtil.encodePassword((String)this.myPassphrase);
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remote/RemoteCredentialsHolder", "getSerializedPassphrase"));
            }
            return string2;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remote/RemoteCredentialsHolder", "getSerializedPassphrase"));
        }
        return "";
    }

    public void setSerializedPassphrase(String serializedPassphrase) {
        if (!StringUtil.isEmpty((String)serializedPassphrase)) {
            this.myPassphrase = PasswordUtil.decodePassword((String)serializedPassphrase);
            this.myStorePassphrase = true;
        } else {
            this.myPassphrase = null;
            this.myStorePassphrase = false;
        }
    }

    public void copyRemoteCredentialsTo(@NotNull MutableRemoteCredentials to) {
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/remote/RemoteCredentialsHolder", "copyRemoteCredentialsTo"));
        }
        RemoteCredentialsHolder.copyRemoteCredentials(this, to);
    }

    public void copyFrom(RemoteCredentials from) {
        RemoteCredentialsHolder.copyRemoteCredentials(from, this);
    }

    public static void copyRemoteCredentials(@NotNull RemoteCredentials from, @NotNull MutableRemoteCredentials to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/remote/RemoteCredentialsHolder", "copyRemoteCredentials"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/remote/RemoteCredentialsHolder", "copyRemoteCredentials"));
        }
        to.setHost(from.getHost());
        to.setLiteralPort(from.getLiteralPort());
        to.setUserName(from.getUserName());
        to.setPassword(from.getPassword());
        to.setUseKeyPair(from.isUseKeyPair());
        to.setPrivateKeyFile(from.getPrivateKeyFile());
        to.setKnownHostsFile(from.getKnownHostsFile());
        to.setStorePassword(from.isStorePassword());
        to.setStorePassphrase(from.isStorePassphrase());
    }

    public void load(Element element) {
        this.setHost(element.getAttributeValue(HOST));
        this.setLiteralPort(element.getAttributeValue(PORT));
        this.setSerializedUserName(element.getAttributeValue(USERNAME));
        this.setSerializedPassword(element.getAttributeValue(PASSWORD));
        boolean isAnonymous = StringUtil.parseBoolean((String)element.getAttributeValue(ANONYMOUS), (boolean)false);
        if (isAnonymous) {
            this.setSerializedUserName("anonymous");
            this.setSerializedPassword("user@example.com");
        }
        this.setPrivateKeyFile(StringUtil.nullize((String)element.getAttributeValue(PRIVATE_KEY_FILE)));
        this.setKnownHostsFile(StringUtil.nullize((String)element.getAttributeValue(KNOWN_HOSTS_FILE)));
        this.setSerializedPassphrase(element.getAttributeValue(PASSPHRASE));
        this.setUseKeyPair(StringUtil.parseBoolean((String)element.getAttributeValue(USE_KEY_PAIR), (boolean)false));
    }

    public void save(Element rootElement) {
        rootElement.setAttribute(HOST, StringUtil.notNullize((String)this.getHost()));
        rootElement.setAttribute(PORT, StringUtil.notNullize((String)this.getLiteralPort()));
        rootElement.setAttribute(USERNAME, this.getSerializedUserName());
        rootElement.setAttribute(PASSWORD, this.getSerializedPassword());
        rootElement.setAttribute(PRIVATE_KEY_FILE, StringUtil.notNullize((String)this.getPrivateKeyFile()));
        rootElement.setAttribute(KNOWN_HOSTS_FILE, StringUtil.notNullize((String)this.getKnownHostsFile()));
        rootElement.setAttribute(PASSPHRASE, this.getSerializedPassphrase());
        rootElement.setAttribute(USE_KEY_PAIR, Boolean.toString(this.isUseKeyPair()));
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        RemoteCredentialsHolder holder = (RemoteCredentialsHolder)o2;
        if (this.myLiteralPort != null ? !this.myLiteralPort.equals(holder.myLiteralPort) : holder.myLiteralPort != null) {
            return false;
        }
        if (this.myUseKeyPair != holder.myUseKeyPair) {
            return false;
        }
        if (this.myStorePassword != holder.myStorePassword) {
            return false;
        }
        if (this.myStorePassphrase != holder.myStorePassphrase) {
            return false;
        }
        if (this.myHost != null ? !this.myHost.equals(holder.myHost) : holder.myHost != null) {
            return false;
        }
        if (this.myUserName != null ? !this.myUserName.equals(holder.myUserName) : holder.myUserName != null) {
            return false;
        }
        if (this.myPassword != null ? !this.myPassword.equals(holder.myPassword) : holder.myPassword != null) {
            return false;
        }
        if (this.myPrivateKeyFile != null ? !this.myPrivateKeyFile.equals(holder.myPrivateKeyFile) : holder.myPrivateKeyFile != null) {
            return false;
        }
        if (this.myKnownHostsFile != null ? !this.myKnownHostsFile.equals(holder.myKnownHostsFile) : holder.myKnownHostsFile != null) {
            return false;
        }
        return !(this.myPassphrase != null ? !this.myPassphrase.equals(holder.myPassphrase) : holder.myPassphrase != null);
    }

    public int hashCode() {
        int result2 = this.myHost != null ? this.myHost.hashCode() : 0;
        result2 = 31 * result2 + (this.myLiteralPort != null ? this.myLiteralPort.hashCode() : 0);
        result2 = 31 * result2 + (this.myUserName != null ? this.myUserName.hashCode() : 0);
        result2 = 31 * result2 + (this.myPassword != null ? this.myPassword.hashCode() : 0);
        result2 = 31 * result2 + (this.myUseKeyPair ? 1 : 0);
        result2 = 31 * result2 + (this.myPrivateKeyFile != null ? this.myPrivateKeyFile.hashCode() : 0);
        result2 = 31 * result2 + (this.myKnownHostsFile != null ? this.myKnownHostsFile.hashCode() : 0);
        result2 = 31 * result2 + (this.myPassphrase != null ? this.myPassphrase.hashCode() : 0);
        result2 = 31 * result2 + (this.myStorePassword ? 1 : 0);
        result2 = 31 * result2 + (this.myStorePassphrase ? 1 : 0);
        return result2;
    }
}

