/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.execution.ExecutionException;
import com.intellij.remote.RemoteCredentialException;
import java.net.NoRouteToHostException;

public class RemoteSdkException
extends ExecutionException {
    private final boolean myNoRouteToHost;
    private final boolean myAuthFailed;
    private Throwable myCause;

    public RemoteSdkException(String s2, Throwable throwable) {
        super(s2, throwable);
        this.myAuthFailed = false;
        for (Throwable t2 = throwable; t2 != null; t2 = t2.getCause()) {
            if (!(t2 instanceof NoRouteToHostException)) continue;
            this.myCause = t2;
            this.myNoRouteToHost = true;
            return;
        }
        this.myNoRouteToHost = false;
        this.myCause = throwable;
    }

    public RemoteSdkException(String s2) {
        super(s2);
        this.myAuthFailed = false;
        this.myNoRouteToHost = false;
    }

    public boolean isNoRouteToHost() {
        return this.myNoRouteToHost;
    }

    public boolean isAuthFailed() {
        return this.myAuthFailed;
    }

    public String getMessage() {
        if (this.myNoRouteToHost) {
            return this.myCause.getMessage();
        }
        if (this.myAuthFailed) {
            return "Authentication failed";
        }
        return super.getMessage();
    }

    public static RemoteSdkException cantObtainRemoteCredentials(Throwable e2) {
        if (e2.getCause() instanceof RemoteCredentialException) {
            return new RemoteSdkException("Cant obtain remote credentials", e2);
        }
        return new RemoteSdkException(e2.getMessage(), e2);
    }
}

