/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.util.PathMappingSettings;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteSdkPropertiesHolder
implements RemoteSdkProperties {
    private static final String INTERPRETER_PATH = "INTERPRETER_PATH";
    private static final String HELPERS_PATH = "HELPERS_PATH";
    private static final String REMOTE_ROOTS = "REMOTE_ROOTS";
    private static final String REMOTE_PATH = "REMOTE_PATH";
    private static final String INITIALIZED = "INITIALIZED";
    private static final String VALID = "VALID";
    private static final String PATH_MAPPINGS = "PATH_MAPPINGS";
    private String mySdkId;
    private String myInterpreterPath;
    private String myHelpersPath;
    private final String myHelpersDefaultDirName;
    private boolean myHelpersVersionChecked = false;
    private Set<String> myRemoteRoots = Sets.newTreeSet();
    private boolean myInitialized = false;
    private boolean myValid = true;
    @NotNull
    private PathMappingSettings myPathMappings = new PathMappingSettings();

    public RemoteSdkPropertiesHolder(String name) {
        this.myHelpersDefaultDirName = name;
    }

    @Override
    public String getInterpreterPath() {
        return this.myInterpreterPath;
    }

    @Override
    public void setInterpreterPath(String interpreterPath) {
        this.myInterpreterPath = interpreterPath;
    }

    @Override
    public String getHelpersPath() {
        return this.myHelpersPath;
    }

    @Override
    public void setHelpersPath(String helpersPath) {
        this.myHelpersPath = helpersPath;
    }

    @Override
    public String getDefaultHelpersName() {
        return this.myHelpersDefaultDirName;
    }

    @Override
    public void addRemoteRoot(String remoteRoot) {
        this.myRemoteRoots.add(remoteRoot);
    }

    @Override
    public void clearRemoteRoots() {
        this.myRemoteRoots.clear();
    }

    @Override
    public List<String> getRemoteRoots() {
        return Lists.newArrayList(this.myRemoteRoots);
    }

    @Override
    public void setRemoteRoots(List<String> remoteRoots) {
        this.myRemoteRoots = Sets.newTreeSet(remoteRoots);
    }

    @Override
    @NotNull
    public PathMappingSettings getPathMappings() {
        PathMappingSettings pathMappingSettings = this.myPathMappings;
        if (pathMappingSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remote/RemoteSdkPropertiesHolder", "getPathMappings"));
        }
        return pathMappingSettings;
    }

    @Override
    public void setPathMappings(@Nullable PathMappingSettings pathMappings) {
        this.myPathMappings = new PathMappingSettings();
        if (pathMappings != null) {
            this.myPathMappings.addAll(pathMappings);
        }
    }

    @Override
    public boolean isHelpersVersionChecked() {
        return this.myHelpersVersionChecked;
    }

    @Override
    public void setHelpersVersionChecked(boolean helpersVersionChecked) {
        this.myHelpersVersionChecked = helpersVersionChecked;
    }

    @Override
    public void setSdkId(String sdkId) {
        this.mySdkId = sdkId;
    }

    @Override
    public String getSdkId() {
        return this.mySdkId;
    }

    @Override
    public boolean isInitialized() {
        return this.myInitialized;
    }

    @Override
    public void setInitialized(boolean initialized) {
        this.myInitialized = initialized;
    }

    @Override
    public boolean isValid() {
        return this.myValid;
    }

    @Override
    public void setValid(boolean valid) {
        this.myValid = valid;
    }

    public void copyTo(RemoteSdkProperties copy) {
        copy.setInterpreterPath(this.getInterpreterPath());
        copy.setHelpersPath(this.getHelpersPath());
        copy.setHelpersVersionChecked(this.isHelpersVersionChecked());
        copy.setRemoteRoots(this.getRemoteRoots());
        copy.setInitialized(this.isInitialized());
        copy.setValid(this.isValid());
    }

    public void save(Element rootElement) {
        rootElement.setAttribute(INTERPRETER_PATH, StringUtil.notNullize((String)this.getInterpreterPath()));
        rootElement.setAttribute(HELPERS_PATH, StringUtil.notNullize((String)this.getHelpersPath()));
        rootElement.setAttribute(INITIALIZED, Boolean.toString(this.isInitialized()));
        rootElement.setAttribute(VALID, Boolean.toString(this.isValid()));
        PathMappingSettings.writeExternal((Element)rootElement, (PathMappingSettings)this.myPathMappings);
        for (String remoteRoot : this.getRemoteRoots()) {
            Element child = new Element(REMOTE_ROOTS);
            child.setAttribute(REMOTE_PATH, remoteRoot);
            rootElement.addContent(child);
        }
    }

    public void load(Element element) {
        this.setInterpreterPath(StringUtil.nullize((String)element.getAttributeValue(INTERPRETER_PATH)));
        this.setHelpersPath(StringUtil.nullize((String)element.getAttributeValue(HELPERS_PATH)));
        this.setRemoteRoots(JDOMExternalizer.loadStringsList((Element)element, (String)REMOTE_ROOTS, (String)REMOTE_PATH));
        this.setInitialized(StringUtil.parseBoolean((String)element.getAttributeValue(INITIALIZED), (boolean)true));
        this.setValid(StringUtil.parseBoolean((String)element.getAttributeValue(VALID), (boolean)true));
        this.setPathMappings(PathMappingSettings.readExternal((Element)element));
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        RemoteSdkPropertiesHolder holder = (RemoteSdkPropertiesHolder)o2;
        if (this.myHelpersVersionChecked != holder.myHelpersVersionChecked) {
            return false;
        }
        if (this.myInitialized != holder.myInitialized) {
            return false;
        }
        if (this.myValid != holder.myValid) {
            return false;
        }
        if (this.myHelpersDefaultDirName != null ? !this.myHelpersDefaultDirName.equals(holder.myHelpersDefaultDirName) : holder.myHelpersDefaultDirName != null) {
            return false;
        }
        if (this.myHelpersPath != null ? !this.myHelpersPath.equals(holder.myHelpersPath) : holder.myHelpersPath != null) {
            return false;
        }
        if (this.myInterpreterPath != null ? !this.myInterpreterPath.equals(holder.myInterpreterPath) : holder.myInterpreterPath != null) {
            return false;
        }
        if (!this.myPathMappings.equals((Object)holder.myPathMappings)) {
            return false;
        }
        if (this.myRemoteRoots != null ? !this.myRemoteRoots.equals(holder.myRemoteRoots) : holder.myRemoteRoots != null) {
            return false;
        }
        return !(this.mySdkId != null ? !this.mySdkId.equals(holder.mySdkId) : holder.mySdkId != null);
    }

    public int hashCode() {
        int result2 = this.mySdkId != null ? this.mySdkId.hashCode() : 0;
        result2 = 31 * result2 + (this.myInterpreterPath != null ? this.myInterpreterPath.hashCode() : 0);
        result2 = 31 * result2 + (this.myHelpersPath != null ? this.myHelpersPath.hashCode() : 0);
        result2 = 31 * result2 + (this.myHelpersDefaultDirName != null ? this.myHelpersDefaultDirName.hashCode() : 0);
        result2 = 31 * result2 + (this.myHelpersVersionChecked ? 1 : 0);
        result2 = 31 * result2 + (this.myRemoteRoots != null ? this.myRemoteRoots.hashCode() : 0);
        result2 = 31 * result2 + (this.myInitialized ? 1 : 0);
        result2 = 31 * result2 + (this.myValid ? 1 : 0);
        result2 = 31 * result2 + this.myPathMappings.hashCode();
        return result2;
    }
}

