/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebDeploymentCredentialsHolder {
    public static final String WEB_SERVER_CONFIG_ID = "WEB_SERVER_CONFIG_ID";
    public static final String WEB_SERVER_CONFIG_NAME = "WEB_SERVER_CONFIG_NAME";
    private String myWebServerConfigId;
    private final RemoteCredentialsHolder myRemoteCredentials;
    private String myWebServerConfigName;

    public WebDeploymentCredentialsHolder() {
        this.myRemoteCredentials = new RemoteCredentialsHolder();
    }

    public WebDeploymentCredentialsHolder(@NotNull String webServerConfigId, String name, @NotNull RemoteCredentials remoteCredentials) {
        if (webServerConfigId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webServerConfigId", "com/intellij/remote/WebDeploymentCredentialsHolder", "<init>"));
        }
        if (remoteCredentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteCredentials", "com/intellij/remote/WebDeploymentCredentialsHolder", "<init>"));
        }
        this.myRemoteCredentials = new RemoteCredentialsHolder();
        this.myWebServerConfigId = webServerConfigId;
        this.myWebServerConfigName = name;
        this.myRemoteCredentials.copyFrom(remoteCredentials);
    }

    @Nullable
    public String getWebServerConfigId() {
        return this.myWebServerConfigId;
    }

    public void setWebServerConfigId(@NotNull String webServerConfigId) {
        if (webServerConfigId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webServerConfigId", "com/intellij/remote/WebDeploymentCredentialsHolder", "setWebServerConfigId"));
        }
        this.myWebServerConfigId = webServerConfigId;
    }

    public String getWebServerConfigName() {
        return this.myWebServerConfigName;
    }

    public void setWebServerConfigName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/remote/WebDeploymentCredentialsHolder", "setWebServerConfigName"));
        }
        this.myWebServerConfigName = name;
    }

    public void load(Element element) {
        this.myRemoteCredentials.load(element);
        this.setWebServerConfigId(element.getAttributeValue(WEB_SERVER_CONFIG_ID));
        this.setWebServerConfigName(StringUtil.notNullize((String)element.getAttributeValue(WEB_SERVER_CONFIG_NAME)));
    }

    public void save(Element element) {
        element.setAttribute(WEB_SERVER_CONFIG_ID, this.getWebServerConfigId());
        element.setAttribute(WEB_SERVER_CONFIG_NAME, this.getWebServerConfigName());
        this.myRemoteCredentials.save(element);
    }

    public RemoteCredentials getSshCredentials() {
        return this.myRemoteCredentials;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        WebDeploymentCredentialsHolder holder = (WebDeploymentCredentialsHolder)o2;
        return this.myWebServerConfigId.equals(holder.myWebServerConfigId);
    }

    public int hashCode() {
        return this.myWebServerConfigId.hashCode();
    }
}

