/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote.ext;

import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.ext.RemoteCredentialsHandlerBase;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshCredentialsHandler
extends RemoteCredentialsHandlerBase<RemoteCredentialsHolder> {
    public SshCredentialsHandler(RemoteCredentialsHolder credentials) {
        super(credentials);
    }

    @Override
    public String getId() {
        return this.constructSshCredentialsFullPath();
    }

    @Override
    public void save(@NotNull Element rootElement) {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/remote/ext/SshCredentialsHandler", "save"));
        }
        ((RemoteCredentialsHolder)this.getCredentials()).save(rootElement);
    }

    @Override
    public String getPresentableDetails(String interpreterPath) {
        return "(" + this.constructSshCredentialsFullPath() + interpreterPath + ")";
    }

    @Override
    public void load(@Nullable Element rootElement) {
        if (rootElement != null) {
            ((RemoteCredentialsHolder)this.getCredentials()).load(rootElement);
        }
    }

    @NotNull
    private String constructSshCredentialsFullPath() {
        RemoteCredentials cred = (RemoteCredentials)this.getCredentials();
        String string2 = "ssh://" + cred.getUserName() + "@" + cred.getHost() + ":" + cred.getLiteralPort();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remote/ext/SshCredentialsHandler", "constructSshCredentialsFullPath"));
        }
        return string2;
    }
}

