/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote.ext;

import java.util.HashMap;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class UnknownCredentialsHolder {
    private String myInterpreterPath;
    @NotNull
    private final Map<String, String> myAttributes = new HashMap<String, String>();

    public UnknownCredentialsHolder(String interpreterPath) {
        this.myInterpreterPath = interpreterPath;
    }

    public UnknownCredentialsHolder() {
        this.myInterpreterPath = "";
    }

    public String getInterpreterPath() {
        return this.myInterpreterPath;
    }

    public void setInterpreterPath(String interpreterPath) {
        this.myInterpreterPath = interpreterPath;
    }

    @NotNull
    public Map<String, String> getAttributes() {
        Map<String, String> map2 = this.myAttributes;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remote/ext/UnknownCredentialsHolder", "getAttributes"));
        }
        return map2;
    }

    public void save(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/remote/ext/UnknownCredentialsHolder", "save"));
        }
        for (Map.Entry<String, String> entry : this.myAttributes.entrySet()) {
            element.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    public void load(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/remote/ext/UnknownCredentialsHolder", "load"));
        }
        this.myAttributes.clear();
        for (Attribute attribute : element.getAttributes()) {
            this.myAttributes.put(attribute.getName(), attribute.getValue());
        }
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        UnknownCredentialsHolder holder = (UnknownCredentialsHolder)o2;
        if (this.myInterpreterPath != null ? !this.myInterpreterPath.equals(holder.myInterpreterPath) : holder.myInterpreterPath != null) {
            return false;
        }
        return this.myAttributes.equals(holder.myAttributes);
    }

    public int hashCode() {
        int result2 = this.myInterpreterPath != null ? this.myInterpreterPath.hashCode() : 0;
        result2 = 31 * result2 + this.myAttributes.hashCode();
        return result2;
    }
}

