/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.impl.configuration.SingleRemoteServerConfigurable;
import com.intellij.remoteServer.util.CloudBundle;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.Convertor;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteServerListConfigurable
extends MasterDetailsComponent
implements SearchableConfigurable {
    @NonNls
    public static final String ID = "RemoteServers";
    private final RemoteServersManager myServersManager;
    @Nullable
    private final ServerType<?> myServerType;
    private RemoteServer<?> myLastSelectedServer;
    private String myInitialSelectedName;

    public RemoteServerListConfigurable(@NotNull RemoteServersManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/remoteServer/impl/configuration/RemoteServerListConfigurable", "<init>"));
        }
        this(manager, null, null);
    }

    private RemoteServerListConfigurable(@NotNull RemoteServersManager manager, @Nullable ServerType<?> type, @Nullable String initialSelectedName) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/remoteServer/impl/configuration/RemoteServerListConfigurable", "<init>"));
        }
        this.myServersManager = manager;
        this.myServerType = type;
        this.initTree();
        this.myToReInitWholePanel = true;
        this.myInitialSelectedName = initialSelectedName;
        this.reInitWholePanelIfNeeded();
    }

    @Nullable
    private ServerType<?> getSingleServerType() {
        if (this.myServerType != null) {
            return this.myServerType;
        }
        ServerType[] serverTypes = (ServerType[])ServerType.EP_NAME.getExtensions();
        return serverTypes.length == 1 ? serverTypes[0] : null;
    }

    @Nullable
    protected String getEmptySelectionString() {
        String typeNames = StringUtil.join((Object[])ServerType.EP_NAME.getExtensions(), type -> type.getPresentableName(), (String)", ");
        if (typeNames.length() > 0) {
            return CloudBundle.getText("clouds.configure.empty.selection.string", typeNames);
        }
        return null;
    }

    public static RemoteServerListConfigurable createConfigurable(@NotNull ServerType<?> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/remoteServer/impl/configuration/RemoteServerListConfigurable", "createConfigurable"));
        }
        return RemoteServerListConfigurable.createConfigurable(type, null);
    }

    public static RemoteServerListConfigurable createConfigurable(@NotNull ServerType<?> type, @Nullable String nameToSelect) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/remoteServer/impl/configuration/RemoteServerListConfigurable", "createConfigurable"));
        }
        return new RemoteServerListConfigurable(RemoteServersManager.getInstance(), type, nameToSelect);
    }

    @Nls
    public String getDisplayName() {
        ServerType<?> singleServerType = this.getSingleServerType();
        return singleServerType == null ? "Clouds" : singleServerType.getPresentableName();
    }

    public void reset() {
        this.myRoot.removeAllChildren();
        for (RemoteServer<?> server : this.getServers()) {
            this.addServerNode(server, false);
        }
        super.reset();
        if (this.myInitialSelectedName != null) {
            this.selectNodeInTree(this.myInitialSelectedName);
        }
    }

    private List<? extends RemoteServer<?>> getServers() {
        if (this.myServerType == null) {
            return this.myServersManager.getServers();
        }
        return this.myServersManager.getServers(this.myServerType);
    }

    private MasterDetailsComponent.MyNode addServerNode(RemoteServer<?> server, boolean isNew) {
        MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode((NamedConfigurable)new SingleRemoteServerConfigurable(server, this.TREE_UPDATER, isNew));
        this.addNode(node, this.myRoot);
        return node;
    }

    @NotNull
    public String getId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/configuration/RemoteServerListConfigurable", "getId"));
        }
        return ID;
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return () -> ((SpeedSearchSupply)ObjectUtils.assertNotNull((Object)SpeedSearchSupply.getSupply((JComponent)this.myTree, (boolean)true))).findAndSelectElement(option);
    }

    protected void initTree() {
        super.initTree();
        new TreeSpeedSearch(this.myTree, new Convertor<TreePath, String>(){

            public String convert(TreePath treePath) {
                return ((MasterDetailsComponent.MyNode)treePath.getLastPathComponent()).getDisplayName();
            }
        }, true);
    }

    protected void processRemovedItems() {
        HashSet<Object> servers = new HashSet<Object>();
        for (NamedConfigurable<RemoteServer<?>> configurable : this.getConfiguredServers()) {
            servers.add(configurable.getEditableObject());
        }
        ArrayList toDelete = new ArrayList();
        for (RemoteServer<?> remoteServer : this.getServers()) {
            if (servers.contains(remoteServer)) continue;
            toDelete.add(remoteServer);
        }
        for (RemoteServer remoteServer : toDelete) {
            this.myServersManager.removeServer(remoteServer);
        }
    }

    public void apply() throws ConfigurationException {
        super.apply();
        HashSet servers = new HashSet(this.getServers());
        for (NamedConfigurable<RemoteServer<?>> configurable : this.getConfiguredServers()) {
            RemoteServer server = (RemoteServer)configurable.getEditableObject();
            server.setName(configurable.getDisplayName());
            if (servers.contains(server)) continue;
            this.myServersManager.addServer(server);
        }
    }

    @Nullable
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> actions2 = new ArrayList<AnAction>();
        ServerType<?> singleServerType = this.getSingleServerType();
        if (singleServerType == null) {
            actions2.add((AnAction)new AddRemoteServerGroup());
        } else {
            actions2.add((AnAction)new AddRemoteServerAction(singleServerType, IconUtil.getAddIcon()));
        }
        actions2.add((AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this));
        return actions2;
    }

    protected boolean wasObjectStored(Object editableObject) {
        return true;
    }

    public String getHelpTopic() {
        ServerType<?> singleServerType;
        String result2 = super.getHelpTopic();
        if (result2 == null && (singleServerType = this.getSingleServerType()) != null) {
            return singleServerType.getHelpTopic();
        }
        return "reference.settings.clouds";
    }

    public void disposeUIResources() {
        Object selectedObject = this.getSelectedObject();
        this.myLastSelectedServer = selectedObject instanceof RemoteServer ? (RemoteServer)selectedObject : null;
        super.disposeUIResources();
    }

    @Nullable
    public RemoteServer<?> getLastSelectedServer() {
        return this.myLastSelectedServer;
    }

    private List<NamedConfigurable<RemoteServer<?>>> getConfiguredServers() {
        ArrayList configurables = new ArrayList();
        for (int i2 = 0; i2 < this.myRoot.getChildCount(); ++i2) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i2);
            configurables.add(node.getConfigurable());
        }
        return configurables;
    }

    private class AddRemoteServerAction
    extends DumbAwareAction {
        private final ServerType<?> myServerType;

        private AddRemoteServerAction(ServerType<?> serverType, Icon icon) {
            super(serverType.getPresentableName(), null, icon);
            this.myServerType = serverType;
        }

        public void actionPerformed(AnActionEvent e2) {
            String name = UniqueNameGenerator.generateUniqueName((String)this.myServerType.getPresentableName(), s2 -> {
                for (NamedConfigurable configurable : RemoteServerListConfigurable.this.getConfiguredServers()) {
                    if (!configurable.getDisplayName().equals(s2)) continue;
                    return false;
                }
                return true;
            });
            MasterDetailsComponent.MyNode node = RemoteServerListConfigurable.this.addServerNode(RemoteServerListConfigurable.this.myServersManager.createServer(this.myServerType, name), true);
            RemoteServerListConfigurable.this.selectNodeInTree((DefaultMutableTreeNode)node);
        }
    }

    private class AddRemoteServerGroup
    extends ActionGroup
    implements MasterDetailsComponent.ActionGroupWithPreselection {
        private AddRemoteServerGroup() {
            super("Add", "", IconUtil.getAddIcon());
            this.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)RemoteServerListConfigurable.this.myTree);
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e2) {
            ServerType[] serverTypes = (ServerType[])ServerType.EP_NAME.getExtensions();
            AnAction[] actions2 = new AnAction[serverTypes.length];
            for (int i2 = 0; i2 < serverTypes.length; ++i2) {
                actions2[i2] = new AddRemoteServerAction(serverTypes[i2], serverTypes[i2].getIcon());
            }
            if (actions2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/configuration/RemoteServerListConfigurable$AddRemoteServerGroup", "getChildren"));
            }
            return actions2;
        }

        public ActionGroup getActionGroup() {
            return this;
        }

        public int getDefaultIndex() {
            return 0;
        }
    }
}

