/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration.deployment;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurator;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.impl.configuration.RemoteServerListConfigurable;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeployToServerSettingsEditor<S extends ServerConfiguration, D extends DeploymentConfiguration>
extends SettingsEditor<DeployToServerRunConfiguration<S, D>> {
    private final ServerType<S> myServerType;
    private final DeploymentConfigurator<D, S> myDeploymentConfigurator;
    private final Project myProject;
    private final ComboboxWithBrowseButton myServerComboBox;
    private final ComboBox<DeploymentSource> mySourceComboBox;
    private final SortedComboBoxModel<String> myServerListModel;
    private final SortedComboBoxModel<DeploymentSource> mySourceListModel;
    private final JPanel myDeploymentSettingsComponent;
    private SettingsEditor<D> myDeploymentSettingsEditor;
    private DeploymentSource myLastSelectedSource;
    private RemoteServer<S> myLastSelectedServer;

    public DeployToServerSettingsEditor(final ServerType<S> type, DeploymentConfigurator<D, S> deploymentConfigurator, Project project2) {
        this.myServerType = type;
        this.myDeploymentConfigurator = deploymentConfigurator;
        this.myProject = project2;
        this.myServerListModel = new SortedComboBoxModel(String.CASE_INSENSITIVE_ORDER);
        this.myServerComboBox = new ComboboxWithBrowseButton((JComboBox)new ComboBox(this.myServerListModel));
        this.fillApplicationServersList(null);
        this.myServerComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String preSelection = DeployToServerSettingsEditor.this.myLastSelectedServer != null ? DeployToServerSettingsEditor.this.myLastSelectedServer.getName() : null;
                RemoteServerListConfigurable configurable = RemoteServerListConfigurable.createConfigurable(type, preSelection);
                if (ShowSettingsUtil.getInstance().editConfigurable((Component)DeployToServerSettingsEditor.this.myServerComboBox, (Configurable)configurable)) {
                    DeployToServerSettingsEditor.this.fillApplicationServersList(configurable.getLastSelectedServer());
                }
            }
        });
        this.myServerComboBox.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                DeployToServerSettingsEditor.this.updateDeploymentSettingsEditor();
            }
        });
        this.myServerComboBox.getComboBox().setRenderer(new ColoredListCellRenderer<String>(){

            protected void customizeCellRenderer(@NotNull JList<? extends String> list2, String value2, int index, boolean selected, boolean hasFocus) {
                if (list2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerSettingsEditor$3", "customizeCellRenderer"));
                }
                if (value2 == null) {
                    return;
                }
                RemoteServer server = RemoteServersManager.getInstance().findByName(value2, type);
                SimpleTextAttributes attributes = server == null ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
                this.setIcon(server != null ? server.getType().getIcon() : null);
                this.append(value2, attributes);
            }
        });
        this.mySourceListModel = new SortedComboBoxModel((o1, o2) -> o1.getPresentableName().compareToIgnoreCase(o2.getPresentableName()));
        this.mySourceListModel.addAll((Collection)deploymentConfigurator.getAvailableDeploymentSources());
        this.mySourceComboBox = new ComboBox(this.mySourceListModel);
        this.mySourceComboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<DeploymentSource>(){

            public void customize(JList list2, DeploymentSource value2, int index, boolean selected, boolean hasFocus) {
                if (value2 == null) {
                    return;
                }
                this.setIcon(value2.getIcon());
                this.setText(value2.getPresentableName());
            }
        });
        this.myDeploymentSettingsComponent = new JPanel(new BorderLayout());
        this.mySourceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                DeployToServerSettingsEditor.this.updateDeploymentSettingsEditor();
            }
        });
    }

    private void fillApplicationServersList(@Nullable RemoteServer<?> newSelection) {
        String oldSelection = (String)this.myServerListModel.getSelectedItem();
        this.myServerListModel.clear();
        for (RemoteServer server : RemoteServersManager.getInstance().getServers(this.myServerType)) {
            this.myServerListModel.add((Object)server.getName());
        }
        this.myServerComboBox.getComboBox().setSelectedItem(newSelection != null ? newSelection.getName() : oldSelection);
    }

    private void updateDeploymentSettingsEditor() {
        String serverName = (String)this.myServerListModel.getSelectedItem();
        RemoteServer selectedServer = serverName != null ? RemoteServersManager.getInstance().findByName(serverName, this.myServerType) : null;
        DeploymentSource selectedSource = (DeploymentSource)this.mySourceListModel.getSelectedItem();
        if (Comparing.equal((Object)selectedSource, (Object)this.myLastSelectedSource) && Comparing.equal((Object)selectedServer, this.myLastSelectedServer)) {
            return;
        }
        if (!Comparing.equal((Object)selectedSource, (Object)this.myLastSelectedSource)) {
            this.updateBeforeRunOptions(this.myLastSelectedSource, false);
            this.updateBeforeRunOptions(selectedSource, true);
        }
        if (selectedSource != null && selectedServer != null) {
            this.myDeploymentSettingsComponent.removeAll();
            this.myDeploymentSettingsEditor = this.myDeploymentConfigurator.createEditor(selectedSource, selectedServer);
            if (this.myDeploymentSettingsEditor != null) {
                Disposer.register((Disposable)this, this.myDeploymentSettingsEditor);
                this.myDeploymentSettingsComponent.add("Center", this.myDeploymentSettingsEditor.getComponent());
            }
        }
        this.myLastSelectedSource = selectedSource;
        this.myLastSelectedServer = selectedServer;
    }

    private void updateBeforeRunOptions(@Nullable DeploymentSource source, boolean selected) {
        if (source != null) {
            DeploymentSourceType type = source.getType();
            type.updateBuildBeforeRunOption((JComponent)this.myServerComboBox, this.myProject, source, selected);
        }
    }

    protected void resetEditorFrom(@NotNull DeployToServerRunConfiguration<S, D> configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerSettingsEditor", "resetEditorFrom"));
        }
        String serverName = configuration.getServerName();
        if (serverName != null && !this.myServerListModel.getItems().contains(serverName)) {
            this.myServerListModel.add((Object)serverName);
        }
        this.myServerComboBox.getComboBox().setSelectedItem(serverName);
        this.mySourceComboBox.setSelectedItem((Object)configuration.getDeploymentSource());
        D deploymentConfiguration = configuration.getDeploymentConfiguration();
        this.updateDeploymentSettingsEditor();
        if (deploymentConfiguration != null && this.myDeploymentSettingsEditor != null) {
            this.myDeploymentSettingsEditor.resetFrom(deploymentConfiguration);
        }
    }

    protected void applyEditorTo(@NotNull DeployToServerRunConfiguration<S, D> configuration) throws ConfigurationException {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerSettingsEditor", "applyEditorTo"));
        }
        this.updateDeploymentSettingsEditor();
        configuration.setServerName((String)this.myServerListModel.getSelectedItem());
        DeploymentSource deploymentSource = (DeploymentSource)this.mySourceListModel.getSelectedItem();
        configuration.setDeploymentSource(deploymentSource);
        if (deploymentSource != null) {
            Object deployment = configuration.getDeploymentConfiguration();
            if (deployment == null) {
                deployment = this.myDeploymentConfigurator.createDefaultConfiguration(deploymentSource);
                configuration.setDeploymentConfiguration(deployment);
            }
            if (this.myDeploymentSettingsEditor != null) {
                this.myDeploymentSettingsEditor.applyTo(deployment);
            }
        } else {
            configuration.setDeploymentConfiguration(null);
        }
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = FormBuilder.createFormBuilder().addLabeledComponent("Server:", (JComponent)this.myServerComboBox).addLabeledComponent("Deployment:", this.mySourceComboBox).addComponentFillVertically((JComponent)this.myDeploymentSettingsComponent, 4).getPanel();
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerSettingsEditor", "createEditor"));
        }
        return jPanel;
    }
}

