/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.impl.runtime.deployment.DeploymentTaskImpl;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.deployment.debug.DebugConnector;
import com.intellij.remoteServer.runtime.ui.RemoteServersView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeployToServerState<S extends ServerConfiguration, D extends DeploymentConfiguration>
implements RunProfileState {
    @NotNull
    private final RemoteServer<S> myServer;
    @NotNull
    private final DeploymentSource mySource;
    @NotNull
    private final D myConfiguration;
    @NotNull
    private final ExecutionEnvironment myEnvironment;

    public DeployToServerState(@NotNull RemoteServer<S> server, @NotNull DeploymentSource deploymentSource, @NotNull D deploymentConfiguration, @NotNull ExecutionEnvironment environment) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/remoteServer/impl/runtime/DeployToServerState", "<init>"));
        }
        if (deploymentSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentSource", "com/intellij/remoteServer/impl/runtime/DeployToServerState", "<init>"));
        }
        if (deploymentConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentConfiguration", "com/intellij/remoteServer/impl/runtime/DeployToServerState", "<init>"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/remoteServer/impl/runtime/DeployToServerState", "<init>"));
        }
        this.myServer = server;
        this.mySource = deploymentSource;
        this.myConfiguration = deploymentConfiguration;
        this.myEnvironment = environment;
    }

    @Nullable
    public ExecutionResult execute(Executor executor2, @NotNull ProgramRunner runner) throws ExecutionException {
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/remoteServer/impl/runtime/DeployToServerState", "execute"));
        }
        ServerConnection connection = ServerConnectionManager.getInstance().getOrCreateConnection(this.myServer);
        Project project2 = this.myEnvironment.getProject();
        RemoteServersView.getInstance(project2).showServerConnection(connection);
        DebugConnector debugConnector = DefaultDebugExecutor.getDebugExecutorInstance().equals(executor2) ? this.myServer.getType().createDebugConnector() : null;
        connection.deploy(new DeploymentTaskImpl<D>(this.mySource, this.myConfiguration, project2, debugConnector, this.myEnvironment), s2 -> RemoteServersView.getInstance(project2).showDeployment(connection, (String)s2));
        return null;
    }
}

