/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import org.jetbrains.annotations.NotNull;

public interface CloudDeploymentNameProvider {
    public static final CloudDeploymentNameProvider DEFAULT_NAME_PROVIDER = new CloudDeploymentNameProvider(){

        @Override
        @NotNull
        public String getDeploymentName(@NotNull DeploymentSource deploymentSource) {
            if (deploymentSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentSource", "com/intellij/remoteServer/util/CloudDeploymentNameProvider$1", "getDeploymentName"));
            }
            String string2 = FileUtil.sanitizeFileName((String)deploymentSource.getPresentableName()).toLowerCase();
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/util/CloudDeploymentNameProvider$1", "getDeploymentName"));
            }
            return string2;
        }
    };

    @NotNull
    public String getDeploymentName(@NotNull DeploymentSource var1);
}

