/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.ui.MessageType;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudNotifier {
    private final String myNotificationDisplayId;

    public CloudNotifier(String notificationDisplayId) {
        this.myNotificationDisplayId = notificationDisplayId;
    }

    public void showMessage(String message2, MessageType messageType) {
        this.showMessage(message2, messageType, null);
    }

    public Notification showMessage(String message2, MessageType messageType, @Nullable NotificationListener listener2) {
        NotificationGroup notificationGroup = CloudNotifier.findOrCreateBaloonGroup(this.myNotificationDisplayId);
        Notification notification = notificationGroup.createNotification("", message2, messageType.toNotificationType(), listener2);
        notification.notify(null);
        return notification;
    }

    @NotNull
    private static NotificationGroup findOrCreateBaloonGroup(@NotNull String displayId) {
        if (displayId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayId", "com/intellij/remoteServer/util/CloudNotifier", "findOrCreateBaloonGroup"));
        }
        NotificationGroup notificationGroup = Optional.ofNullable(NotificationGroup.findRegisteredGroup((String)displayId)).orElse(NotificationGroup.balloonGroup((String)displayId));
        if (notificationGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/util/CloudNotifier", "findOrCreateBaloonGroup"));
        }
        return notificationGroup;
    }
}

