/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reporting;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.reporting.Base64GzipCompressor;
import com.intellij.reporting.StatsSender;
import com.intellij.reporting.StatsServerInfo;
import com.intellij.reporting.Utils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.Header;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\u000bH\u0002J\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00072\b\b\u0002\u0010\r\u001a\u00020\u000eR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/reporting/StatsSender;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "infoUrl", "", "createRequest", "Lorg/apache/http/client/fluent/Request;", "info", "Lcom/intellij/reporting/StatsServerInfo;", "text", "compress", "", "requestServerUrl", "send", "platform-impl"})
public final class StatsSender {
    private static final String infoUrl = "https://www.jetbrains.com/config/features-service-status.json";
    private static final Logger LOG;
    public static final StatsSender INSTANCE;

    private final StatsServerInfo requestServerUrl() {
        try {
            String response = Request.Get((String)infoUrl).execute().returnContent().asString();
            StatsServerInfo info = (StatsServerInfo)Utils.INSTANCE.getGson().fromJson(response, StatsServerInfo.class);
            if (info.isServiceAlive()) {
                return info;
            }
        }
        catch (Exception e2) {
            LOG.debug((Throwable)e2);
        }
        return null;
    }

    public final boolean send(@NotNull String text2, boolean compress) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        StatsServerInfo statsServerInfo = this.requestServerUrl();
        if (statsServerInfo == null) {
            return false;
        }
        StatsServerInfo info = statsServerInfo;
        try {
            Response response = this.createRequest(info, text2, compress).execute();
            Integer code2 = (Integer)response.handleResponse((ResponseHandler)send.code.1.INSTANCE);
            if (Intrinsics.compare((int)code2, (int)200) >= 0 && Intrinsics.compare((int)code2, (int)300) < 0) {
                return true;
            }
        }
        catch (Exception e2) {
            LOG.debug((Throwable)e2);
        }
        return false;
    }

    public static /* bridge */ /* synthetic */ boolean send$default(StatsSender statsSender, String string2, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        return statsSender.send(string2, bl);
    }

    private final Request createRequest(StatsServerInfo info, String text2, boolean compress) {
        if (compress) {
            byte[] data = Base64GzipCompressor.INSTANCE.compress(text2);
            Request request2 = Request.Post((String)info.urlForZipBase64Content).bodyByteArray(data);
            request2.addHeader((Header)new BasicHeader("Content-Encoding", "gzip"));
            Request request3 = request2;
            Intrinsics.checkExpressionValueIsNotNull((Object)request3, (String)"request");
            return request3;
        }
        Request request4 = Request.Post((String)info.url).bodyString(text2, ContentType.TEXT_HTML);
        Intrinsics.checkExpressionValueIsNotNull((Object)request4, (String)"Request.Post(info.url).b\u2026t, ContentType.TEXT_HTML)");
        return request4;
    }

    private StatsSender() {
        INSTANCE = this;
        infoUrl = infoUrl;
        LOG = Logger.getInstance(StatsSender.class);
    }

    static {
        new StatsSender();
    }
}

