/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CloseTabToolbarAction;
import com.intellij.ide.actions.RefreshAction;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.pom.Navigatable;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceTreeBuilder;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceUsageCellRendererBase;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.impl.UsagePreviewPanel;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SlicePanel
extends JPanel
implements TypeSafeDataProvider,
Disposable {
    private final SliceTreeBuilder myBuilder;
    private final JTree myTree;
    private final AutoScrollToSourceHandler myAutoScrollToSourceHandler;
    private UsagePreviewPanel myUsagePreviewPanel;
    private final Project myProject;
    private boolean isDisposed;
    private final ToolWindow myToolWindow;
    private final SliceLanguageSupportProvider myProvider;

    protected SlicePanel(final @NotNull Project project2, boolean dataFlowToThis, @NotNull SliceNode rootNode, boolean splitByLeafExpressions, final @NotNull ToolWindow toolWindow) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/slicer/SlicePanel", "<init>"));
        }
        if (rootNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootNode", "com/intellij/slicer/SlicePanel", "<init>"));
        }
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/slicer/SlicePanel", "<init>"));
        }
        super(new BorderLayout());
        this.myAutoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return SlicePanel.this.isAutoScroll();
            }

            protected void setAutoScrollMode(boolean state) {
                SlicePanel.this.setAutoScroll(state);
            }
        };
        this.myProvider = rootNode.getProvider();
        this.myToolWindow = toolWindow;
        ToolWindowManagerListener listener2 = new ToolWindowManagerListener(){
            ToolWindowAnchor myAnchor;
            {
                this.myAnchor = toolWindow.getAnchor();
            }

            @Override
            public void toolWindowRegistered(@NotNull String id) {
                if (id == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/slicer/SlicePanel$2", "toolWindowRegistered"));
                }
            }

            @Override
            public void stateChanged() {
                if (!project2.isOpen()) {
                    return;
                }
                if (toolWindow.getAnchor() != this.myAnchor) {
                    this.myAnchor = SlicePanel.this.myToolWindow.getAnchor();
                    SlicePanel.this.layoutPanel();
                }
            }
        };
        ToolWindowManagerEx.getInstanceEx(project2).addToolWindowManagerListener(listener2, this);
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myProject = project2;
        this.myTree = this.createTree();
        this.myBuilder = new SliceTreeBuilder(this.myTree, project2, dataFlowToThis, rootNode, splitByLeafExpressions);
        this.myBuilder.setCanYieldUpdate(!ApplicationManager.getApplication().isUnitTestMode());
        Disposer.register((Disposable)this, (Disposable)this.myBuilder);
        this.myBuilder.addSubtreeToUpdate((DefaultMutableTreeNode)this.myTree.getModel().getRoot(), () -> {
            if (this.isDisposed || this.myBuilder.isDisposed() || this.myProject.isDisposed()) {
                return;
            }
            final SliceNode rootNode1 = this.myBuilder.getRootSliceNode();
            this.myBuilder.expand(rootNode1, new Runnable(){

                @Override
                public void run() {
                    if (SlicePanel.this.isDisposed || SlicePanel.this.myBuilder.isDisposed() || SlicePanel.this.myProject.isDisposed()) {
                        return;
                    }
                    SlicePanel.this.myBuilder.select(rootNode1.myCachedChildren.get(0));
                }
            });
            this.treeSelectionChanged();
        });
        this.layoutPanel();
    }

    private void layoutPanel() {
        if (this.myUsagePreviewPanel != null) {
            Disposer.dispose((Disposable)this.myUsagePreviewPanel);
        }
        this.removeAll();
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        if (this.isPreview()) {
            pane.setBorder(IdeBorderFactory.createBorder((int)5));
            boolean vertical = this.myToolWindow.getAnchor() == ToolWindowAnchor.LEFT || this.myToolWindow.getAnchor() == ToolWindowAnchor.RIGHT;
            Splitter splitter = new Splitter(vertical, UsageViewSettings.getInstance().PREVIEW_USAGES_SPLITTER_PROPORTIONS);
            splitter.setFirstComponent((JComponent)pane);
            this.myUsagePreviewPanel = new UsagePreviewPanel(this.myProject, new UsageViewPresentation());
            this.myUsagePreviewPanel.setBorder(IdeBorderFactory.createBorder((int)1));
            Disposer.register((Disposable)this, (Disposable)this.myUsagePreviewPanel);
            splitter.setSecondComponent((JComponent)this.myUsagePreviewPanel);
            this.add((Component)splitter, "Center");
        } else {
            pane.setBorder(IdeBorderFactory.createBorder((int)1));
            this.add((Component)pane, "Center");
        }
        this.add((Component)this.createToolbar().getComponent(), "West");
        this.myTree.getParent().setBackground(UIManager.getColor("Tree.background"));
        this.revalidate();
    }

    public void dispose() {
        if (this.myUsagePreviewPanel != null) {
            UsageViewSettings.getInstance().PREVIEW_USAGES_SPLITTER_PROPORTIONS = ((Splitter)this.myUsagePreviewPanel.getParent()).getProportion();
            this.myUsagePreviewPanel = null;
        }
        this.isDisposed = true;
        ToolTipManager.sharedInstance().unregisterComponent(this.myTree);
    }

    @NotNull
    private JTree createTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        Tree tree2 = new Tree((TreeModel)new DefaultTreeModel(root));
        tree2.setOpaque(false);
        tree2.setToggleClickCount(-1);
        SliceUsageCellRendererBase renderer = this.myProvider.getRenderer();
        renderer.setOpaque(false);
        tree2.setCellRenderer((TreeCellRenderer)((Object)renderer));
        UIUtil.setLineStyleAngled((JTree)tree2);
        tree2.setRootVisible(false);
        tree2.setShowsRootHandles(true);
        tree2.getSelectionModel().setSelectionMode(1);
        tree2.setSelectionPath(new TreePath(root.getPath()));
        EditSourceOnDoubleClickHandler.install((JTree)tree2);
        new TreeSpeedSearch((JTree)tree2);
        TreeUtil.installActions((JTree)tree2);
        ToolTipManager.sharedInstance().registerComponent((JComponent)tree2);
        this.myAutoScrollToSourceHandler.install((JTree)tree2);
        tree2.getSelectionModel().addTreeSelectionListener(e2 -> this.treeSelectionChanged());
        tree2.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e2) {
                if (10 == e2.getKeyCode()) {
                    List navigatables = SlicePanel.this.getNavigatables();
                    if (navigatables.isEmpty()) {
                        return;
                    }
                    for (Navigatable navigatable : navigatables) {
                        if (navigatable instanceof AbstractTreeNode && ((AbstractTreeNode)navigatable).getValue() instanceof Usage) {
                            navigatable = (Usage)((AbstractTreeNode)navigatable).getValue();
                        }
                        if (!navigatable.canNavigateToSource()) continue;
                        navigatable.navigate(false);
                        if (!(navigatable instanceof Usage)) continue;
                        ((Usage)navigatable).highlightInEditor();
                    }
                    e2.consume();
                }
            }
        });
        tree2.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                SliceNode node = SlicePanel.fromPath(path);
                node.calculateDupNode();
            }
        });
        Tree tree3 = tree2;
        if (tree3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SlicePanel", "createTree"));
        }
        return tree3;
    }

    private void treeSelectionChanged() {
        SwingUtilities.invokeLater(() -> {
            if (this.isDisposed) {
                return;
            }
            List<UsageInfo> infos = this.getSelectedUsageInfos();
            if (infos != null && this.myUsagePreviewPanel != null) {
                this.myUsagePreviewPanel.updateLayout(infos);
            }
        });
    }

    private static SliceNode fromPath(TreePath path) {
        DefaultMutableTreeNode node;
        Object userObject;
        Object lastPathComponent = path.getLastPathComponent();
        if (lastPathComponent instanceof DefaultMutableTreeNode && (userObject = (node = (DefaultMutableTreeNode)lastPathComponent).getUserObject()) instanceof SliceNode) {
            return (SliceNode)userObject;
        }
        return null;
    }

    @Nullable
    private List<UsageInfo> getSelectedUsageInfos() {
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        ArrayList<UsageInfo> result2 = new ArrayList<UsageInfo>();
        for (TreePath path : paths) {
            SliceNode sliceNode = SlicePanel.fromPath(path);
            if (sliceNode == null) continue;
            result2.add(((SliceUsage)((Object)sliceNode.getValue())).getUsageInfo());
        }
        if (result2.isEmpty()) {
            return null;
        }
        return result2;
    }

    public void calcData(DataKey key, DataSink sink) {
        List<Navigatable> navigatables;
        if (key == CommonDataKeys.NAVIGATABLE_ARRAY && !(navigatables = this.getNavigatables()).isEmpty()) {
            sink.put(CommonDataKeys.NAVIGATABLE_ARRAY, (Object)navigatables.toArray(new Navigatable[navigatables.size()]));
        }
    }

    @NotNull
    private List<Navigatable> getNavigatables() {
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null) {
            List<Navigatable> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SlicePanel", "getNavigatables"));
            }
            return list2;
        }
        ArrayList<Navigatable> navigatables = new ArrayList<Navigatable>();
        for (TreePath path : paths) {
            Object lastPathComponent = path.getLastPathComponent();
            if (!(lastPathComponent instanceof DefaultMutableTreeNode)) continue;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)lastPathComponent;
            Object userObject = node.getUserObject();
            if (userObject instanceof Navigatable) {
                navigatables.add((Navigatable)userObject);
                continue;
            }
            if (!(node instanceof Navigatable)) continue;
            navigatables.add((Navigatable)node);
        }
        ArrayList<Navigatable> arrayList = navigatables;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SlicePanel", "getNavigatables"));
        }
        return arrayList;
    }

    @NotNull
    private ActionToolbar createToolbar() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new MyRefreshAction(this.myTree));
        if (this.isToShowAutoScrollButton()) {
            actionGroup.add((AnAction)this.myAutoScrollToSourceHandler.createToggleAction());
        }
        if (this.isToShowCloseButton()) {
            actionGroup.add((AnAction)new CloseAction());
        }
        if (this.isToShowPreviewButton()) {
            actionGroup.add((AnAction)new ToggleAction(UsageViewBundle.message((String)"preview.usages.action.text", (Object[])new Object[]{"usages"}), "preview", AllIcons.Actions.PreviewDetails){

                public boolean isSelected(AnActionEvent e2) {
                    return SlicePanel.this.isPreview();
                }

                public void setSelected(AnActionEvent e2, boolean state) {
                    SlicePanel.this.setPreview(state);
                    SlicePanel.this.layoutPanel();
                }
            });
        }
        this.myProvider.registerExtraPanelActions(actionGroup, this.myBuilder);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("TypeHierarchyViewToolbar", (ActionGroup)actionGroup, false);
        if (actionToolbar == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SlicePanel", "createToolbar"));
        }
        return actionToolbar;
    }

    public boolean isToShowAutoScrollButton() {
        return true;
    }

    public abstract boolean isAutoScroll();

    public abstract void setAutoScroll(boolean var1);

    public boolean isToShowCloseButton() {
        return true;
    }

    public boolean isToShowPreviewButton() {
        return true;
    }

    public abstract boolean isPreview();

    public abstract void setPreview(boolean var1);

    protected void close() {
        ProgressIndicator progress = this.myBuilder.getUi().getProgress();
        if (progress != null) {
            progress.cancel();
        }
    }

    public SliceTreeBuilder getBuilder() {
        return this.myBuilder;
    }

    private final class MyRefreshAction
    extends RefreshAction {
        private MyRefreshAction(JComponent tree2) {
            super(IdeBundle.message((String)"action.refresh", (Object[])new Object[0]), IdeBundle.message((String)"action.refresh", (Object[])new Object[0]), AllIcons.Actions.Refresh);
            this.registerShortcutOn(tree2);
        }

        @Override
        public final void actionPerformed(AnActionEvent e2) {
            SliceNode rootNode = (SliceNode)SlicePanel.this.myBuilder.getRootNode().getUserObject();
            rootNode.setChanged();
            SlicePanel.this.myBuilder.addSubtreeToUpdate(SlicePanel.this.myBuilder.getRootNode());
        }

        @Override
        public final void update(AnActionEvent event) {
            Presentation presentation = event.getPresentation();
            presentation.setEnabled(true);
        }
    }

    private class CloseAction
    extends CloseTabToolbarAction {
        private CloseAction() {
        }

        public final void actionPerformed(AnActionEvent e2) {
            SlicePanel.this.close();
        }
    }
}

