/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.engine.SuggestionProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BaseSuggestionProvider
implements SuggestionProvider {
    private final SpellCheckerManager manager;

    public BaseSuggestionProvider(@NotNull SpellCheckerManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spellchecker/BaseSuggestionProvider", "<init>"));
        }
        this.manager = manager;
    }

    @Override
    @NotNull
    public List<String> getSuggestions(@NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/spellchecker/BaseSuggestionProvider", "getSuggestions"));
        }
        String[] words = NameUtil.nameToWords((String)text2);
        int index = 0;
        List[] res2 = new List[words.length];
        int i2 = 0;
        for (String word : words) {
            List<Object> variants;
            int start2 = text2.indexOf(word, index);
            int end = start2 + word.length();
            if (this.manager.hasProblem(word)) {
                variants = this.manager.getRawSuggestions(word);
                res2[i2++] = variants;
            } else {
                variants = new ArrayList();
                variants.add(word);
                res2[i2++] = variants;
            }
            index = end;
        }
        int[] counter = new int[i2];
        int size = 1;
        for (int j2 = 0; j2 < i2; ++j2) {
            size *= res2[j2].size();
        }
        String[] all2 = new String[size];
        for (int k2 = 0; k2 < size; ++k2) {
            for (int j3 = 0; j3 < i2; ++j3) {
                if (all2[k2] == null) {
                    all2[k2] = "";
                }
                int n2 = k2;
                all2[n2] = all2[n2] + res2[j3].get(counter[j3]);
                int n3 = j3;
                counter[n3] = counter[n3] + 1;
                if (counter[j3] < res2[j3].size()) continue;
                counter[j3] = 0;
            }
        }
        List<String> list2 = Arrays.asList(all2);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/BaseSuggestionProvider", "getSuggestions"));
        }
        return list2;
    }
}

