/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.spellchecker.dictionary.Loader;
import com.intellij.util.Consumer;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public class StreamLoader
implements Loader {
    private final InputStream stream;
    private final String name;

    public StreamLoader(InputStream stream, String name) {
        this.stream = stream;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void load(@NotNull Consumer<String> consumer2) {
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/spellchecker/StreamLoader", "load"));
        }
        StreamLoader.doLoad(this.stream, consumer2);
    }

    static void doLoad(@NotNull InputStream stream, @NotNull Consumer<String> consumer2) {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/spellchecker/StreamLoader", "doLoad"));
        }
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/spellchecker/StreamLoader", "doLoad"));
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                consumer2.consume((Object)line);
            }
        }
        catch (Exception e2) {
            Logger.getInstance(StreamLoader.class).error((Throwable)e2);
        }
    }
}

