/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.compress;

import com.intellij.spellchecker.compress.Alphabet;
import com.intellij.spellchecker.compress.Encoder;
import com.intellij.spellchecker.compress.UnitBitSet;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.dictionary.Loader;
import com.intellij.spellchecker.engine.Transformation;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompressedDictionary
implements Dictionary {
    private final Alphabet alphabet;
    private int wordsCount;
    private byte[][] words;
    private int[] lengths;
    private final Encoder encoder;
    private final String name;
    private TIntObjectHashMap<SortedSet<byte[]>> rawData;
    private static final Comparator<byte[]> COMPARATOR = (o1, o2) -> CompressedDictionary.compareArrays(o1, o2);

    private CompressedDictionary(@NotNull Alphabet alphabet, @NotNull Encoder encoder, @NotNull String name) {
        if (alphabet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alphabet", "com/intellij/spellchecker/compress/CompressedDictionary", "<init>"));
        }
        if (encoder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "encoder", "com/intellij/spellchecker/compress/CompressedDictionary", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spellchecker/compress/CompressedDictionary", "<init>"));
        }
        this.rawData = new TIntObjectHashMap();
        this.alphabet = alphabet;
        this.encoder = encoder;
        this.name = name;
    }

    private void addToDictionary(@NotNull byte[] word) {
        if (word == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word", "com/intellij/spellchecker/compress/CompressedDictionary", "addToDictionary"));
        }
        SortedSet<byte[]> set2 = (SortedSet<byte[]>)this.rawData.get(word.length);
        if (set2 == null) {
            set2 = CompressedDictionary.createSet();
            this.rawData.put(word.length, set2);
        }
        set2.add(word);
        ++this.wordsCount;
    }

    private void pack() {
        this.lengths = new int[this.rawData.size()];
        this.words = new byte[this.rawData.size()][];
        this.rawData.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<SortedSet<byte[]>>(){
            int row = 0;

            public boolean execute(int length, SortedSet<byte[]> value2) {
                ((CompressedDictionary)CompressedDictionary.this).lengths[this.row] = length;
                ((CompressedDictionary)CompressedDictionary.this).words[this.row] = new byte[value2.size() * length];
                int k2 = 0;
                byte[] wordBytes = CompressedDictionary.this.words[this.row];
                for (byte[] bytes : value2) {
                    assert (bytes.length == length);
                    System.arraycopy(bytes, 0, wordBytes, k2, bytes.length);
                    k2 += bytes.length;
                }
                ++this.row;
                return true;
            }
        });
        this.rawData = null;
    }

    @NotNull
    private static SortedSet<byte[]> createSet() {
        TreeSet<byte[]> treeSet = new TreeSet<byte[]>(COMPARATOR);
        if (treeSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/compress/CompressedDictionary", "createSet"));
        }
        return treeSet;
    }

    public List<String> getWords(char first, int minLength, int maxLength) {
        ArrayList<String> result2 = new ArrayList<String>();
        this.getWords(first, minLength, maxLength, result2);
        return result2;
    }

    public List<String> getWords(char first) {
        ArrayList<String> result2 = new ArrayList<String>();
        this.getWords(first, 0, Integer.MAX_VALUE, result2);
        return result2;
    }

    public void getWords(char first, int minLength, int maxLength, @NotNull Collection<String> result2) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spellchecker/compress/CompressedDictionary", "getWords"));
        }
        int index = this.alphabet.getIndex(first, false);
        if (index == -1) {
            return;
        }
        int i2 = 0;
        for (byte[] data : this.words) {
            int length = this.lengths[i2];
            if (length < minLength || length > maxLength) continue;
            for (int x2 = 0; x2 < data.length; x2 += length) {
                if (this.encoder.getFirstLetterIndex(data[x2]) != index) continue;
                byte[] toTest = new byte[length];
                System.arraycopy(data, x2, toTest, 0, length);
                String decoded = this.encoder.decode(toTest);
                result2.add(decoded);
            }
            ++i2;
        }
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = this.name;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/compress/CompressedDictionary", "getName"));
        }
        return string2;
    }

    @Override
    @Nullable
    public Boolean contains(@NotNull String word) {
        if (word == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word", "com/intellij/spellchecker/compress/CompressedDictionary", "contains"));
        }
        UnitBitSet bs = this.encoder.encode(word, false);
        if (bs == Encoder.WORD_OF_ENTIRELY_UNKNOWN_LETTERS) {
            return null;
        }
        if (bs == null) {
            return false;
        }
        byte[] compressed = bs.pack();
        int index = ArrayUtil.indexOf((int[])this.lengths, (int)compressed.length);
        return index != -1 && CompressedDictionary.contains(compressed, this.words[index]);
    }

    @Override
    public boolean isEmpty() {
        return this.wordsCount <= 0;
    }

    @Override
    public void traverse(@NotNull Consumer<String> action2) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/spellchecker/compress/CompressedDictionary", "traverse"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getWords() {
        THashSet words = new THashSet();
        for (int i2 = 0; i2 <= this.alphabet.getLastIndexUsed(); ++i2) {
            char letter = this.alphabet.getLetter(i2);
            this.getWords(letter, 0, Integer.MAX_VALUE, (Collection<String>)words);
        }
        return words;
    }

    @Override
    public int size() {
        return this.wordsCount;
    }

    public String toString() {
        return "CompressedDictionary{wordsCount=" + this.wordsCount + ", name='" + this.name + '\'' + '}';
    }

    @NotNull
    public static CompressedDictionary create(@NotNull Loader loader, @NotNull Transformation transform) {
        if (loader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loader", "com/intellij/spellchecker/compress/CompressedDictionary", "create"));
        }
        if (transform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transform", "com/intellij/spellchecker/compress/CompressedDictionary", "create"));
        }
        Alphabet alphabet = new Alphabet();
        Encoder encoder = new Encoder(alphabet);
        CompressedDictionary dictionary = new CompressedDictionary(alphabet, encoder, loader.getName());
        ArrayList bss = new ArrayList();
        loader.load((Consumer<String>)((Consumer)s2 -> {
            if (transform == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transform", "com/intellij/spellchecker/compress/CompressedDictionary", "lambda$create$1"));
            }
            String transformed = transform.transform((String)s2);
            if (transformed != null) {
                UnitBitSet bs = encoder.encode(transformed, true);
                if (bs == null) {
                    return;
                }
                bss.add(bs);
            }
        }));
        for (UnitBitSet bs : bss) {
            byte[] compressed = bs.pack();
            dictionary.addToDictionary(compressed);
        }
        dictionary.pack();
        CompressedDictionary compressedDictionary = dictionary;
        if (compressedDictionary == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/compress/CompressedDictionary", "create"));
        }
        return compressedDictionary;
    }

    public static int compareArrays(@NotNull byte[] array1, @NotNull byte[] array2) {
        if (array1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array1", "com/intellij/spellchecker/compress/CompressedDictionary", "compareArrays"));
        }
        if (array2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array2", "com/intellij/spellchecker/compress/CompressedDictionary", "compareArrays"));
        }
        return CompressedDictionary.compareArrays(array1, 0, array1.length, array2);
    }

    private static int compareArrays(@NotNull byte[] array1, int start1, int length1, @NotNull byte[] array2) {
        if (array1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array1", "com/intellij/spellchecker/compress/CompressedDictionary", "compareArrays"));
        }
        if (array2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array2", "com/intellij/spellchecker/compress/CompressedDictionary", "compareArrays"));
        }
        if (length1 != array2.length) {
            return length1 < array2.length ? -1 : 1;
        }
        for (int i2 = 0; i2 < length1; ++i2) {
            int d2 = array1[i2 + start1] - array2[i2];
            if (d2 < 0) {
                return -1;
            }
            if (d2 <= 0) continue;
            return 1;
        }
        return 0;
    }

    public static boolean contains(@NotNull byte[] goal, @NotNull byte[] data) {
        if (goal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "goal", "com/intellij/spellchecker/compress/CompressedDictionary", "contains"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/spellchecker/compress/CompressedDictionary", "contains"));
        }
        return CompressedDictionary.binarySearchNew(goal, 0, data.length / goal.length, data) >= 0;
    }

    public static int binarySearchNew(@NotNull byte[] goal, int fromIndex, int toIndex, @NotNull byte[] data) {
        if (goal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "goal", "com/intellij/spellchecker/compress/CompressedDictionary", "binarySearchNew"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/spellchecker/compress/CompressedDictionary", "binarySearchNew"));
        }
        int unitLength = goal.length;
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int check = CompressedDictionary.compareArrays(data, mid * unitLength, unitLength, goal);
            if (check == -1) {
                low = mid + 1;
                continue;
            }
            if (check == 1) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }
}

