/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.compress;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.spellchecker.compress.Alphabet;
import com.intellij.spellchecker.compress.UnitBitSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Encoder {
    private final Alphabet alphabet;
    private static final int offset = 0;
    static final UnitBitSet WORD_OF_ENTIRELY_UNKNOWN_LETTERS = new UnitBitSet(new byte[1], new Alphabet());
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spellchecker.compress");

    public Encoder() {
        this(new Alphabet());
    }

    public Encoder(@NotNull Alphabet alphabet) {
        if (alphabet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alphabet", "com/intellij/spellchecker/compress/Encoder", "<init>"));
        }
        this.alphabet = alphabet;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    @Nullable
    public UnitBitSet encode(@NotNull CharSequence letters, boolean force) {
        if (letters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "letters", "com/intellij/spellchecker/compress/Encoder", "encode"));
        }
        if (64 <= letters.length() + 0) {
            return null;
        }
        int unknownLetters = 0;
        byte[] indices = new byte[letters.length()];
        for (int i2 = 0; i2 < letters.length(); ++i2) {
            char letter = letters.charAt(i2);
            int index = this.alphabet.getIndex(letter, force);
            if (index < 0) {
                ++unknownLetters;
                continue;
            }
            indices[i2] = (byte)index;
        }
        if (unknownLetters == letters.length()) {
            return WORD_OF_ENTIRELY_UNKNOWN_LETTERS;
        }
        if (unknownLetters > 0) {
            return null;
        }
        return new UnitBitSet(indices, this.alphabet);
    }

    @NotNull
    public String decode(@NotNull byte[] compressed) {
        if (compressed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compressed", "com/intellij/spellchecker/compress/Encoder", "decode"));
        }
        String string2 = UnitBitSet.decode(compressed, this.alphabet);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/compress/Encoder", "decode"));
        }
        return string2;
    }

    public int getFirstLetterIndex(byte firstPackedByte) {
        return UnitBitSet.getFirstLetterIndex(firstPackedByte, this.alphabet);
    }
}

