/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.dictionary;

import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.dictionary.ProjectDictionary;
import com.intellij.util.Consumer;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AggregatedDictionary
implements EditableDictionary {
    @NonNls
    private static final String DICTIONARY_NAME = "common";
    private final EditableDictionary cachedDictionary;
    private final ProjectDictionary projectDictionary;

    @Override
    @NotNull
    public String getName() {
        if (DICTIONARY_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/dictionary/AggregatedDictionary", "getName"));
        }
        return DICTIONARY_NAME;
    }

    public AggregatedDictionary(@NotNull ProjectDictionary projectDictionary, @NotNull EditableDictionary cachedDictionary) {
        if (projectDictionary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDictionary", "com/intellij/spellchecker/dictionary/AggregatedDictionary", "<init>"));
        }
        if (cachedDictionary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cachedDictionary", "com/intellij/spellchecker/dictionary/AggregatedDictionary", "<init>"));
        }
        this.projectDictionary = projectDictionary;
        this.cachedDictionary = cachedDictionary;
        this.cachedDictionary.addToDictionary(projectDictionary.getWords());
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @NonNls
    public String toString() {
        return "AggregatedDictionary{cachedDictionary=" + this.cachedDictionary + ", projectDictionary=" + this.projectDictionary + '}';
    }

    @Override
    @Nullable
    public Boolean contains(@NotNull String word) {
        if (word == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word", "com/intellij/spellchecker/dictionary/AggregatedDictionary", "contains"));
        }
        return this.cachedDictionary.contains(word);
    }

    @Override
    public void addToDictionary(String word) {
        this.getProjectDictionary().addToDictionary(word);
        this.getCachedDictionary().addToDictionary(word);
    }

    @Override
    public void removeFromDictionary(String word) {
        this.getProjectDictionary().removeFromDictionary(word);
        this.getCachedDictionary().removeFromDictionary(word);
    }

    @Override
    public void replaceAll(@Nullable Collection<String> words) {
        Set<String> oldWords = this.getProjectDictionary().getWords();
        this.getProjectDictionary().replaceAll(words);
        if (oldWords != null) {
            for (String word : oldWords) {
                if (words != null && words.contains(word)) continue;
                this.getCachedDictionary().removeFromDictionary(word);
            }
        }
    }

    @Override
    public void clear() {
        this.getProjectDictionary().clear();
    }

    @Override
    public void traverse(@NotNull Consumer<String> consumer2) {
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/spellchecker/dictionary/AggregatedDictionary", "traverse"));
        }
        this.cachedDictionary.traverse(consumer2);
    }

    @Override
    public Set<String> getWords() {
        return this.cachedDictionary.getWords();
    }

    @Override
    public int size() {
        return this.cachedDictionary.size();
    }

    @Override
    @Nullable
    public Set<String> getEditableWords() {
        return this.getProjectDictionary().getEditableWords();
    }

    @Override
    public void addToDictionary(@Nullable Collection<String> words) {
        this.getProjectDictionary().addToDictionary(words);
        this.getCachedDictionary().addToDictionary(words);
    }

    public EditableDictionary getCachedDictionary() {
        return this.cachedDictionary;
    }

    public ProjectDictionary getProjectDictionary() {
        return this.projectDictionary;
    }
}

