/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.dictionary;

import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.util.Consumer;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UserDictionary
implements EditableDictionary {
    private final String name;
    @NotNull
    private final Set<String> words;

    public UserDictionary(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spellchecker/dictionary/UserDictionary", "<init>"));
        }
        this.words = new THashSet();
        this.name = name;
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = this.name;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/dictionary/UserDictionary", "getName"));
        }
        return string2;
    }

    @Override
    @Nullable
    public Boolean contains(@NotNull String word) {
        if (word == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word", "com/intellij/spellchecker/dictionary/UserDictionary", "contains"));
        }
        boolean contains = this.words.contains(word);
        if (contains) {
            return true;
        }
        return null;
    }

    @Override
    public int size() {
        return this.words.size();
    }

    @Override
    @NotNull
    public Set<String> getWords() {
        Set<String> set2 = this.words;
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/dictionary/UserDictionary", "getWords"));
        }
        return set2;
    }

    @Override
    @Nullable
    public Set<String> getEditableWords() {
        return this.words;
    }

    @Override
    public void clear() {
        this.words.clear();
    }

    @Override
    public void addToDictionary(String word) {
        if (word == null) {
            return;
        }
        this.words.add(word);
    }

    @Override
    public void removeFromDictionary(String word) {
        if (word == null) {
            return;
        }
        this.words.remove(word);
    }

    @Override
    public void replaceAll(@Nullable Collection<String> words) {
        this.clear();
        this.addToDictionary(words);
    }

    @Override
    public void addToDictionary(@Nullable Collection<String> words) {
        if (words == null || words.isEmpty()) {
            return;
        }
        for (String word : words) {
            this.addToDictionary(word);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.words.isEmpty();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        UserDictionary that = (UserDictionary)o2;
        return this.name.equals(that.name);
    }

    @Override
    public void traverse(@NotNull Consumer<String> consumer2) {
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/spellchecker/dictionary/UserDictionary", "traverse"));
        }
        for (String word : this.words) {
            consumer2.consume((Object)word);
        }
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @NonNls
    public String toString() {
        return "UserDictionary{name='" + this.name + '\'' + ", words.count=" + this.words.size() + '}';
    }
}

