/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.engine;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spellchecker.compress.CompressedDictionary;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.dictionary.Loader;
import com.intellij.spellchecker.engine.SpellCheckerEngine;
import com.intellij.spellchecker.engine.Suggestion;
import com.intellij.spellchecker.engine.Transformation;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.EditDistance;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseSpellChecker
implements SpellCheckerEngine {
    static final Logger LOG = Logger.getInstance((String)"#com.intellij.spellchecker.engine.BaseSpellChecker");
    private final Transformation transform;
    private final Set<EditableDictionary> dictionaries;
    private final List<Dictionary> bundledDictionaries;
    private final AtomicBoolean myLoadingDictionaries;
    private final List<Pair<Loader, Consumer<Dictionary>>> myDictionariesToLoad;
    private final Project myProject;

    public BaseSpellChecker(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spellchecker/engine/BaseSpellChecker", "<init>"));
        }
        this.transform = new Transformation();
        this.dictionaries = new HashSet<EditableDictionary>();
        this.bundledDictionaries = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myLoadingDictionaries = new AtomicBoolean(false);
        this.myDictionariesToLoad = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project2;
    }

    @Override
    public void loadDictionary(@NotNull Loader loader) {
        if (loader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loader", "com/intellij/spellchecker/engine/BaseSpellChecker", "loadDictionary"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.addCompressedFixedDictionary(CompressedDictionary.create(loader, this.transform));
        } else {
            this.loadDictionaryAsync(loader, (Consumer<Dictionary>)((Consumer)this::addCompressedFixedDictionary));
        }
    }

    private void loadDictionaryAsync(@NotNull Loader loader, @NotNull Consumer<Dictionary> consumer2) {
        if (loader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loader", "com/intellij/spellchecker/engine/BaseSpellChecker", "loadDictionaryAsync"));
        }
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/spellchecker/engine/BaseSpellChecker", "loadDictionaryAsync"));
        }
        if (this.myLoadingDictionaries.compareAndSet(false, true)) {
            LOG.debug("Loading " + loader.getName());
            this.doLoadDictionaryAsync(loader, consumer2);
        } else {
            this.queueDictionaryLoad(loader, consumer2);
        }
    }

    private void doLoadDictionaryAsync(Loader loader, Consumer<Dictionary> consumer2) {
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> {
            LOG.debug("Loading " + loader.getName());
            Application app = ApplicationManager.getApplication();
            app.executeOnPooledThread(() -> {
                if (app.isDisposed()) {
                    return;
                }
                CompressedDictionary dictionary = CompressedDictionary.create(loader, this.transform);
                LOG.debug(loader.getName() + " loaded!");
                consumer2.consume((Object)dictionary);
                while (!this.myDictionariesToLoad.isEmpty()) {
                    if (app.isDisposed()) {
                        return;
                    }
                    Pair<Loader, Consumer<Dictionary>> nextDictionary = this.myDictionariesToLoad.remove(0);
                    Loader nextDictionaryLoader = (Loader)nextDictionary.getFirst();
                    dictionary = CompressedDictionary.create(nextDictionaryLoader, this.transform);
                    LOG.debug(nextDictionaryLoader.getName() + " loaded!");
                    ((Consumer)nextDictionary.getSecond()).consume((Object)dictionary);
                }
                LOG.debug("Loading finished, restarting daemon...");
                this.myLoadingDictionaries.set(false);
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (app.isDisposed()) {
                        return;
                    }
                    for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
                        DaemonCodeAnalyzer instance2;
                        if (!project2.isInitialized() || !project2.isOpen() || project2.isDefault() || (instance2 = DaemonCodeAnalyzer.getInstance((Project)project2)) == null) continue;
                        instance2.restart();
                    }
                });
            });
        });
    }

    private void queueDictionaryLoad(Loader loader, Consumer<Dictionary> consumer2) {
        LOG.debug("Queuing load for: " + loader.getName());
        this.myDictionariesToLoad.add((Pair<Loader, Consumer<Dictionary>>)Pair.create((Object)loader, consumer2));
    }

    @Override
    public void addModifiableDictionary(@NotNull EditableDictionary dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dictionary", "com/intellij/spellchecker/engine/BaseSpellChecker", "addModifiableDictionary"));
        }
        this.dictionaries.add(dictionary);
    }

    private void addCompressedFixedDictionary(@NotNull Dictionary dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dictionary", "com/intellij/spellchecker/engine/BaseSpellChecker", "addCompressedFixedDictionary"));
        }
        this.bundledDictionaries.add(dictionary);
    }

    @Override
    public Transformation getTransformation() {
        return this.transform;
    }

    private static void restore(char startFrom, int j2, Collection<? extends Dictionary> dictionaries, Collection<String> result2) {
        for (Dictionary dictionary : dictionaries) {
            BaseSpellChecker.restore(startFrom, j2, dictionary, result2);
        }
    }

    private static void restore(char first, int j2, Dictionary dictionary, Collection<String> result2) {
        if (dictionary instanceof CompressedDictionary) {
            ((CompressedDictionary)dictionary).getWords(first, 0, j2, result2);
        } else {
            dictionary.traverse((Consumer<String>)((Consumer)s2 -> {
                if (!StringUtil.isEmpty((String)s2) && s2.charAt(0) == first && s2.length() >= 0 && s2.length() <= j2) {
                    result2.add((String)s2);
                }
            }));
        }
    }

    private static int isCorrect(@NotNull String transformed, @Nullable Collection<? extends Dictionary> dictionaries) {
        if (transformed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transformed", "com/intellij/spellchecker/engine/BaseSpellChecker", "isCorrect"));
        }
        if (dictionaries == null) {
            return -1;
        }
        int errors = 0;
        for (Dictionary dictionary : dictionaries) {
            if (dictionary == null) continue;
            Boolean contains = dictionary.contains(transformed);
            if (contains == null) {
                ++errors;
                continue;
            }
            if (!contains.booleanValue()) continue;
            return 0;
        }
        if (errors == dictionaries.size()) {
            return errors;
        }
        return -1;
    }

    @Override
    public boolean isCorrect(@NotNull String word) {
        if (word == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word", "com/intellij/spellchecker/engine/BaseSpellChecker", "isCorrect"));
        }
        String transformed = this.transform.transform(word);
        if (this.myLoadingDictionaries.get() || transformed == null) {
            return true;
        }
        int bundled = BaseSpellChecker.isCorrect(transformed, this.bundledDictionaries);
        int user = BaseSpellChecker.isCorrect(transformed, this.dictionaries);
        return bundled == 0 || user == 0 || bundled > 0 && user > 0;
    }

    @Override
    @NotNull
    public List<String> getSuggestions(@NotNull String word, int maxSuggestions, int quality) {
        Suggestion suggestion;
        if (word == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word", "com/intellij/spellchecker/engine/BaseSpellChecker", "getSuggestions"));
        }
        String transformed = this.transform.transform(word);
        if (transformed == null) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/engine/BaseSpellChecker", "getSuggestions"));
            }
            return list2;
        }
        ArrayList<String> rawSuggestions = new ArrayList<String>();
        BaseSpellChecker.restore(transformed.charAt(0), Integer.MAX_VALUE, this.bundledDictionaries, rawSuggestions);
        BaseSpellChecker.restore(word.charAt(0), Integer.MAX_VALUE, this.dictionaries, rawSuggestions);
        if (rawSuggestions.isEmpty()) {
            List<String> list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/engine/BaseSpellChecker", "getSuggestions"));
            }
            return list3;
        }
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>(rawSuggestions.size());
        for (String rawSuggestion : rawSuggestions) {
            int distance = EditDistance.optimalAlignment((CharSequence)transformed, (CharSequence)rawSuggestion, (boolean)true);
            suggestions.add(new Suggestion(rawSuggestion, distance));
        }
        Collections.sort(suggestions);
        int limit = Math.min(maxSuggestions, suggestions.size());
        ArrayList<String> result2 = new ArrayList<String>(limit);
        int bestMetrics = ((Suggestion)suggestions.get(0)).getMetrics();
        for (int i2 = 0; i2 < limit && bestMetrics - (suggestion = (Suggestion)suggestions.get(i2)).getMetrics() <= quality; ++i2) {
            result2.add(i2, suggestion.getWord());
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/engine/BaseSpellChecker", "getSuggestions"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<String> getVariants(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/spellchecker/engine/BaseSpellChecker", "getVariants"));
        }
        List<String> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/engine/BaseSpellChecker", "getVariants"));
        }
        return list2;
    }

    @Override
    public void reset() {
        this.bundledDictionaries.clear();
        this.dictionaries.clear();
    }

    @Override
    public boolean isDictionaryLoad(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spellchecker/engine/BaseSpellChecker", "isDictionaryLoad"));
        }
        return this.getBundledDictionaryByName(name) != null;
    }

    @Override
    public void removeDictionary(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spellchecker/engine/BaseSpellChecker", "removeDictionary"));
        }
        Dictionary dictionaryByName = this.getBundledDictionaryByName(name);
        if (dictionaryByName != null) {
            this.bundledDictionaries.remove(dictionaryByName);
        }
    }

    @Nullable
    public Dictionary getBundledDictionaryByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spellchecker/engine/BaseSpellChecker", "getBundledDictionaryByName"));
        }
        for (Dictionary dictionary : this.bundledDictionaries) {
            if (!name.equals(dictionary.getName())) continue;
            return dictionary;
        }
        return null;
    }
}

