/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.engine;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class Suggestion
implements Comparable<Suggestion> {
    private final String word;
    private final int metrics;

    public Suggestion(String word, int metrics) {
        this.word = word;
        this.metrics = metrics;
    }

    public String getWord() {
        return this.word;
    }

    public int getMetrics() {
        return this.metrics;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        Suggestion result2 = (Suggestion)o2;
        if (this.metrics != result2.metrics) {
            return false;
        }
        return !(this.word != null ? !this.word.equals(result2.word) : result2.word != null);
    }

    public int hashCode() {
        int result2 = this.word != null ? this.word.hashCode() : 0;
        result2 = 31 * result2 + this.metrics;
        return result2;
    }

    @Override
    public int compareTo(@NotNull Suggestion o2) {
        if (o2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/spellchecker/engine/Suggestion", "compareTo"));
        }
        int c2 = new Integer(this.getMetrics()).compareTo(o2.getMetrics());
        return c2 != 0 ? c2 : StringUtil.compare((String)this.word, (String)o2.word, (boolean)true);
    }

    public String toString() {
        return this.word + " : " + this.metrics;
    }
}

