/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.openapi.util.TextRange;
import com.intellij.spellchecker.inspections.BaseSplitter;
import com.intellij.spellchecker.util.Strings;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdentifierSplitter
extends BaseSplitter {
    private static final IdentifierSplitter INSTANCE = new IdentifierSplitter();
    @NonNls
    private static final Pattern WORD = Pattern.compile("\\b\\p{L}*'?\\p{L}*");
    @NonNls
    private static final Pattern WORD_IN_QUOTES = Pattern.compile("'([^']*)'");

    public static IdentifierSplitter getInstance() {
        return INSTANCE;
    }

    @Override
    public void split(@Nullable String text2, @NotNull TextRange range, Consumer<TextRange> consumer2) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/spellchecker/inspections/IdentifierSplitter", "split"));
        }
        if (text2 == null || range.getLength() < 1 || range.getStartOffset() < 0) {
            return;
        }
        List<TextRange> extracted = IdentifierSplitter.excludeByPattern(text2, range, WORD_IN_QUOTES, 1);
        for (TextRange textRange : extracted) {
            List<TextRange> words = IdentifierSplitter.splitByCase(text2, textRange);
            if (words.size() == 0) continue;
            if (words.size() == 1) {
                IdentifierSplitter.addWord(consumer2, false, words.get(0));
                continue;
            }
            boolean isCapitalized = Strings.isCapitalized(text2, words.get(0));
            boolean containsShortWord = IdentifierSplitter.containsShortWord(words);
            if (isCapitalized && containsShortWord) continue;
            boolean isAllWordsAreUpperCased = IdentifierSplitter.isAllWordsAreUpperCased(text2, words);
            for (TextRange word : words) {
                boolean flag;
                boolean uc = Strings.isUpperCased(text2, word);
                boolean bl = flag = uc && !isAllWordsAreUpperCased;
                Matcher matcher = WORD.matcher(text2.substring(word.getStartOffset(), word.getEndOffset()));
                if (!matcher.find()) continue;
                TextRange found = IdentifierSplitter.matcherRange(word, matcher);
                IdentifierSplitter.addWord(consumer2, flag, found);
            }
        }
    }

    @NotNull
    private static List<TextRange> splitByCase(@NotNull String text2, @NotNull TextRange range) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/spellchecker/inspections/IdentifierSplitter", "splitByCase"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/spellchecker/inspections/IdentifierSplitter", "splitByCase"));
        }
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        int i2 = range.getStartOffset();
        int s2 = -1;
        int prevType = 25;
        while (i2 < range.getEndOffset()) {
            char ch = text2.charAt(i2);
            if (ch >= '\u3040' && ch <= '\u309f' || ch >= '\u30a0' && ch <= '\u30ff' || ch >= '\u4e00' && ch <= '\u9fff' || ch >= '\uf900' && ch <= '\ufaff' || ch >= '\uff00' && ch <= '\uffef') {
                if (s2 >= 0) {
                    IdentifierSplitter.add(text2, result2, i2, s2);
                    s2 = -1;
                }
                prevType = 25;
                ++i2;
                continue;
            }
            int type = Character.getType(ch);
            if (type == 2 || type == 1 || type == 3 || type == 5 || type == 4 || type == 24) {
                if (s2 < 0) {
                    s2 = i2;
                } else if (s2 >= 0 && type == 1 && prevType == 2) {
                    IdentifierSplitter.add(text2, result2, i2, s2);
                    s2 = i2;
                } else if (i2 - s2 >= 1 && type == 2 && prevType == 1) {
                    IdentifierSplitter.add(text2, result2, i2 - 1, s2);
                    s2 = i2 - 1;
                }
            } else if (s2 >= 0) {
                IdentifierSplitter.add(text2, result2, i2, s2);
                s2 = -1;
            }
            prevType = type;
            ++i2;
        }
        if (s2 >= 0) {
            IdentifierSplitter.add(text2, result2, i2, s2);
        }
        ArrayList<TextRange> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/inspections/IdentifierSplitter", "splitByCase"));
        }
        return arrayList;
    }

    private static void add(String text2, List<TextRange> result2, int i2, int s2) {
        if (i2 - s2 > 3) {
            TextRange textRange = new TextRange(s2, i2);
            result2.add(textRange);
        }
    }
}

