/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.project.Project;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import icons.SpellcheckerIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class AcceptWordAsCorrect
implements SpellCheckerQuickFix {
    private String myWord;

    public AcceptWordAsCorrect(String word) {
        this.myWord = word;
    }

    public AcceptWordAsCorrect() {
    }

    @NotNull
    public String getName() {
        String string2 = this.myWord != null ? SpellCheckerBundle.message("add.0.to.dictionary", this.myWord) : SpellCheckerBundle.message("add.to.dictionary", new Object[0]);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/quickfixes/AcceptWordAsCorrect", "getName"));
        }
        return string2;
    }

    @NotNull
    public String getFamilyName() {
        String string2 = SpellCheckerBundle.message("add.to.dictionary", new Object[0]);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/quickfixes/AcceptWordAsCorrect", "getFamilyName"));
        }
        return string2;
    }

    @Override
    @NotNull
    public Anchor getPopupActionAnchor() {
        Anchor anchor = Anchor.LAST;
        if (anchor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/quickfixes/AcceptWordAsCorrect", "getPopupActionAnchor"));
        }
        return anchor;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spellchecker/quickfixes/AcceptWordAsCorrect", "applyFix"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spellchecker/quickfixes/AcceptWordAsCorrect", "applyFix"));
        }
        SpellCheckerManager spellCheckerManager = SpellCheckerManager.getInstance(project2);
        if (this.myWord != null) {
            spellCheckerManager.acceptWordAsCorrect(this.myWord, project2);
        } else {
            spellCheckerManager.acceptWordAsCorrect(ProblemDescriptorUtil.extractHighlightedText((CommonProblemDescriptor)descriptor2, descriptor2.getPsiElement()), project2);
        }
    }

    public Icon getIcon(int flags) {
        return SpellcheckerIcons.Spellcheck;
    }
}

