/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.spellchecker.quickfixes.ShowSuggestions;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ChangeTo
extends ShowSuggestions
implements SpellCheckerQuickFix {
    public ChangeTo(String wordWithTypo) {
        super(wordWithTypo);
    }

    @NotNull
    public String getFamilyName() {
        String string2 = SpellCheckerBundle.message("change.to", new Object[0]);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/quickfixes/ChangeTo", "getFamilyName"));
        }
        return string2;
    }

    @Override
    @NotNull
    public Anchor getPopupActionAnchor() {
        Anchor anchor = Anchor.FIRST;
        if (anchor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/quickfixes/ChangeTo", "getPopupActionAnchor"));
        }
        return anchor;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spellchecker/quickfixes/ChangeTo", "applyFix"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spellchecker/quickfixes/ChangeTo", "applyFix"));
        }
        PsiElement element = descriptor2.getPsiElement();
        if (element == null) {
            return;
        }
        Editor editor = PsiUtilBase.findEditor((PsiElement)element);
        if (editor == null) {
            return;
        }
        TextRange textRange = ((ProblemDescriptorBase)descriptor2).getTextRange();
        editor.getSelectionModel().setSelection(textRange.getStartOffset(), textRange.getEndOffset());
        String word = editor.getSelectionModel().getSelectedText();
        if (word == null || StringUtil.isEmpty((String)word)) {
            return;
        }
        ArrayList<LookupElementBuilder> lookupItems = new ArrayList<LookupElementBuilder>();
        for (String variant : this.getSuggestions(project2)) {
            lookupItems.add(LookupElementBuilder.create((String)variant));
        }
        LookupElement[] items2 = new LookupElement[lookupItems.size()];
        items2 = lookupItems.toArray(items2);
        LookupManager lookupManager = LookupManager.getInstance(project2);
        lookupManager.showLookup(editor, items2);
    }
}

