/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.xml;

import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.spellchecker.tokenizer.SuppressibleSpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.spellchecker.xml.NoSpellchecking;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import org.jetbrains.annotations.NotNull;

public class XmlSpellcheckingStrategy
extends SuppressibleSpellcheckingStrategy {
    @Override
    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        PsiFile file2;
        if (element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_DATA_CHARACTERS && ((file2 = element.getContainingFile()) == null || file2.getLanguage() instanceof TemplateLanguage)) {
            Tokenizer tokenizer = EMPTY_TOKENIZER;
            if (tokenizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/xml/XmlSpellcheckingStrategy", "getTokenizer"));
            }
            return tokenizer;
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/xml/XmlSpellcheckingStrategy", "getTokenizer"));
        }
        return tokenizer;
    }

    @Override
    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String name) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spellchecker/xml/XmlSpellcheckingStrategy", "isSuppressedFor"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spellchecker/xml/XmlSpellcheckingStrategy", "isSuppressedFor"));
        }
        DomElement domElement = DomUtil.getDomElement((PsiElement)element);
        return domElement != null && domElement.getAnnotation(NoSpellchecking.class) != null;
    }

    @Override
    public SuppressQuickFix[] getSuppressActions(@NotNull PsiElement element, @NotNull String name) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spellchecker/xml/XmlSpellcheckingStrategy", "getSuppressActions"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spellchecker/xml/XmlSpellcheckingStrategy", "getSuppressActions"));
        }
        return SuppressQuickFix.EMPTY_ARRAY;
    }
}

