/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.jediterm.terminal.TerminalDataStream;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingDeque;

public class AppendableTerminalDataStream
implements TerminalDataStream,
Appendable {
    private LinkedBlockingDeque<Character> myQueue = new LinkedBlockingDeque(10000000);

    public char getChar() throws IOException {
        try {
            return this.myQueue.take().charValue();
        }
        catch (InterruptedException e2) {
            throw new IOException(e2);
        }
    }

    public void pushChar(char c2) throws IOException {
        this.myQueue.push(Character.valueOf(c2));
    }

    public String readNonControlCharacters(int maxLength) throws IOException {
        Character c2;
        StringBuilder sb2 = new StringBuilder();
        while (sb2.length() < maxLength && (c2 = this.myQueue.peek()) != null && c2.charValue() >= ' ') {
            sb2.append(this.myQueue.poll());
        }
        return sb2.toString();
    }

    public void pushBackBuffer(char[] chars, int length) throws IOException {
        for (int i2 = 0; i2 < length; ++i2) {
            this.myQueue.addFirst(Character.valueOf(chars[length - i2 - i2]));
        }
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        for (int i2 = 0; i2 < csq.length(); ++i2) {
            this.append(csq.charAt(i2));
        }
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start2, int end) throws IOException {
        for (int i2 = start2; i2 < end; ++i2) {
            this.append(csq.charAt(i2));
        }
        return this;
    }

    @Override
    public Appendable append(char c2) throws IOException {
        try {
            this.myQueue.put(Character.valueOf(c2));
        }
        catch (InterruptedException e2) {
            throw new IOException(e2);
        }
        return this;
    }
}

