/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.google.common.collect.Lists;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.TerminalSettingsListener;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.RetinaImage;
import com.intellij.util.ui.UIUtil;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.ui.TerminalPanel;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import java.awt.AWTEvent;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public class JBTerminalPanel
extends TerminalPanel
implements FocusListener,
TerminalSettingsListener,
Disposable,
IdeEventQueue.EventDispatcher {
    private static final String[] ACTIONS_TO_SKIP = new String[]{"ActivateTerminalToolWindow", "ActivateMessagesToolWindow", "ActivateProjectToolWindow", "ActivateFavoritesToolWindow", "ActivateFindToolWindow", "ActivateRunToolWindow", "ActivateDebugToolWindow", "ActivateTODOToolWindow", "ActivateStructureToolWindow", "ActivateHierarchyToolWindow", "ActivateVersionControlToolWindow", "HideAllWindows", "ShowBookmarks", "GotoBookmark0", "GotoBookmark1", "GotoBookmark2", "GotoBookmark3", "GotoBookmark4", "GotoBookmark5", "GotoBookmark6", "GotoBookmark7", "GotoBookmark8", "GotoBookmark9", "GotoAction", "GotoFile", "GotoClass", "GotoSymbol", "ShowSettings", "RecentFiles", "Switcher"};
    private final JBTerminalSystemSettingsProviderBase mySettingsProvider;
    private List<AnAction> myActionsToSkip;

    public JBTerminalPanel(@NotNull JBTerminalSystemSettingsProviderBase settingsProvider, @NotNull TerminalTextBuffer backBuffer, @NotNull StyleState styleState) {
        if (settingsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsProvider", "com/intellij/terminal/JBTerminalPanel", "<init>"));
        }
        if (backBuffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backBuffer", "com/intellij/terminal/JBTerminalPanel", "<init>"));
        }
        if (styleState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleState", "com/intellij/terminal/JBTerminalPanel", "<init>"));
        }
        super((SettingsProvider)settingsProvider, backBuffer, styleState);
        this.mySettingsProvider = settingsProvider;
        JBTerminalPanel.registerKeymapActions(this);
        this.addFocusListener(this);
        this.mySettingsProvider.addListener(this);
    }

    private static void registerKeymapActions(final TerminalPanel terminalPanel) {
        ActionManager actionManager = ActionManager.getInstance();
        for (String actionId : ACTIONS_TO_SKIP) {
            final AnAction action2 = actionManager.getAction(actionId);
            if (action2 == null) continue;
            DumbAwareAction a = new DumbAwareAction(){

                public void actionPerformed(AnActionEvent e2) {
                    if (e2.getInputEvent() instanceof KeyEvent) {
                        AnActionEvent event = new AnActionEvent(e2.getInputEvent(), e2.getDataContext(), e2.getPlace(), new Presentation(), e2.getActionManager(), e2.getModifiers());
                        action2.update(event);
                        if (event.getPresentation().isEnabled()) {
                            action2.actionPerformed(event);
                        } else {
                            terminalPanel.handleKeyEvent((KeyEvent)event.getInputEvent());
                        }
                        event.getInputEvent().consume();
                    }
                }
            };
            for (Shortcut sc : action2.getShortcutSet().getShortcuts()) {
                if (!sc.isKeyboard() || !(sc instanceof KeyboardShortcut)) continue;
                KeyboardShortcut ksc = (KeyboardShortcut)sc;
                a.registerCustomShortcutSet(ksc.getFirstKeyStroke().getKeyCode(), ksc.getFirstKeyStroke().getModifiers(), (JComponent)terminalPanel);
            }
        }
    }

    @Override
    public boolean dispatch(AWTEvent e2) {
        if (e2 instanceof KeyEvent && !this.skipKeyEvent((KeyEvent)e2)) {
            this.dispatchEvent(e2);
            return true;
        }
        return false;
    }

    private boolean skipKeyEvent(KeyEvent e2) {
        if (this.myActionsToSkip == null) {
            return false;
        }
        int kc2 = e2.getKeyCode();
        return kc2 == 27 || JBTerminalPanel.skipAction(e2, this.myActionsToSkip);
    }

    private static boolean skipAction(KeyEvent e2, List<AnAction> actionsToSkip) {
        if (actionsToSkip != null) {
            KeyboardShortcut eventShortcut = new KeyboardShortcut(KeyStroke.getKeyStrokeForEvent(e2), null);
            for (AnAction action2 : actionsToSkip) {
                for (Shortcut sc : action2.getShortcutSet().getShortcuts()) {
                    if (!sc.isKeyboard() || !sc.startsWith((Shortcut)eventShortcut)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected void setupAntialiasing(Graphics graphics) {
        UIUtil.setupComposite((Graphics2D)((Graphics2D)graphics));
        UISettings.setupAntialiasing((Graphics)graphics);
    }

    protected void setCopyContents(StringSelection selection) {
        CopyPasteManager.getInstance().setContents((Transferable)selection);
    }

    protected void drawImage(Graphics2D gfx, BufferedImage image, int x2, int y2, ImageObserver observer) {
        UIUtil.drawImage((Graphics)gfx, (Image)image, (int)x2, (int)y2, (ImageObserver)observer);
    }

    protected void drawImage(Graphics2D g2, BufferedImage image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        JBTerminalPanel.drawImage(g2, image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
    }

    public static void drawImage(Graphics g2, Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        if (image instanceof JBHiDPIScaledImage) {
            Graphics2D newG = (Graphics2D)g2.create(0, 0, image.getWidth(observer), image.getHeight(observer));
            newG.scale(0.5, 0.5);
            Image img = ((JBHiDPIScaledImage)image).getDelegate();
            if (img == null) {
                img = image;
            }
            newG.drawImage(img, 2 * dx1, 2 * dy1, 2 * dx2, 2 * dy2, sx1 * 2, sy1 * 2, sx2 * 2, sy2 * 2, observer);
            newG.scale(1.0, 1.0);
            newG.dispose();
        } else if (RetinaImage.isAppleHiDPIScaledImage((Image)image)) {
            g2.drawImage(image, dx1, dy1, dx2, dy2, sx1 * 2, sy1 * 2, sx2 * 2, sy2 * 2, observer);
        } else {
            g2.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
        }
    }

    protected boolean isRetina() {
        return UIUtil.isRetina();
    }

    protected BufferedImage createBufferedImage(int width, int height) {
        return UIUtil.createImage((int)width, (int)height, (int)2);
    }

    @Override
    public void focusGained(FocusEvent event) {
        this.installKeyDispatcher();
        if (GeneralSettings.getInstance().isSaveOnFrameDeactivation()) {
            TransactionGuard.submitTransaction((Disposable)this, () -> FileDocumentManager.getInstance().saveAllDocuments());
        }
    }

    private void installKeyDispatcher() {
        if (this.mySettingsProvider.overrideIdeShortcuts()) {
            this.myActionsToSkip = JBTerminalPanel.setupActionsToSkip();
            IdeEventQueue.getInstance().addDispatcher(this, this);
        } else {
            this.myActionsToSkip = null;
        }
    }

    private static List<AnAction> setupActionsToSkip() {
        ArrayList res2 = Lists.newArrayList();
        ActionManager actionManager = ActionManager.getInstance();
        for (String actionId : ACTIONS_TO_SKIP) {
            AnAction action2 = actionManager.getAction(actionId);
            if (action2 == null) continue;
            res2.add(action2);
        }
        return res2;
    }

    @Override
    public void focusLost(FocusEvent event) {
        if (this.myActionsToSkip != null) {
            this.myActionsToSkip = null;
            IdeEventQueue.getInstance().removeDispatcher(this);
        }
        JBTerminalPanel.refreshAfterExecution();
    }

    protected Font getFontToDisplay(char c2, TextStyle style) {
        FontInfo fontInfo = this.fontForChar(c2, style.hasOption(TextStyle.Option.BOLD) ? 1 : 0);
        return fontInfo.getFont();
    }

    public FontInfo fontForChar(char c2, @JdkConstants.FontStyle int style) {
        return ComplementaryFontsRegistry.getFontAbleToDisplay(c2, style, this.mySettingsProvider.getColorScheme().getConsoleFontPreferences());
    }

    @Override
    public void fontChanged() {
        this.reinitFontAndResize();
    }

    public void dispose() {
        super.dispose();
        this.mySettingsProvider.removeListener(this);
    }

    public static void refreshAfterExecution() {
        if (GeneralSettings.getInstance().isSyncOnFrameActivation()) {
            LocalFileSystem.getInstance().refresh(true);
        }
    }
}

