/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.DefaultEditorTextRepresentationHelper;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapPainter;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapApplianceManager;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.LockSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class EditorTestUtil {
    public static final String CARET_TAG = "<caret>";
    public static final String CARET_TAG_PREFIX = "<caret>".substring(0, "<caret>".length() - 1);
    public static final String SELECTION_START_TAG = "<selection>";
    public static final String SELECTION_END_TAG = "</selection>";
    public static final String BLOCK_SELECTION_START_TAG = "<block>";
    public static final String BLOCK_SELECTION_END_TAG = "</block>";
    public static final char BACKSPACE_FAKE_CHAR = '\uffff';
    public static final char SMART_ENTER_FAKE_CHAR = '\ufffe';
    public static final char SMART_LINE_SPLIT_CHAR = '\ufffd';

    public static void performTypingAction(Editor editor, char c2) {
        EditorActionManager actionManager = EditorActionManager.getInstance();
        if (c2 == '\uffff') {
            EditorTestUtil.executeAction(editor, "EditorBackSpace");
        } else if (c2 == '\ufffe') {
            EditorTestUtil.executeAction(editor, "EditorCompleteStatement");
        } else if (c2 == '\ufffd') {
            EditorTestUtil.executeAction(editor, "EditorSplitLine");
        } else if (c2 == '\n') {
            EditorTestUtil.executeAction(editor, "EditorEnter");
        } else {
            TypedAction action2 = actionManager.getTypedAction();
            action2.actionPerformed(editor, c2, DataManager.getInstance().getDataContext((Component)editor.getContentComponent()));
        }
    }

    public static void executeAction(@NotNull Editor editor, @NotNull String actionId) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/EditorTestUtil", "executeAction"));
        }
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/testFramework/EditorTestUtil", "executeAction"));
        }
        EditorTestUtil.executeAction(editor, actionId, false);
    }

    public static void executeAction(@NotNull Editor editor, @NotNull String actionId, boolean assertActionIsEnabled) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/EditorTestUtil", "executeAction"));
        }
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/testFramework/EditorTestUtil", "executeAction"));
        }
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        AnAction action2 = actionManager.getAction(actionId);
        Assert.assertNotNull((Object)action2);
        EditorTestUtil.executeAction(editor, assertActionIsEnabled, action2);
    }

    public static void executeAction(@NotNull Editor editor, boolean assertActionIsEnabled, @NotNull AnAction action2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/EditorTestUtil", "executeAction"));
        }
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/testFramework/EditorTestUtil", "executeAction"));
        }
        AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)action2, null, (String)"", (DataContext)EditorTestUtil.createEditorContext(editor));
        action2.beforeActionPerformedUpdate(event);
        if (!event.getPresentation().isEnabled()) {
            Assert.assertFalse((String)("Action " + action2 + " is disabled"), (boolean)assertActionIsEnabled);
            return;
        }
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        actionManager.fireBeforeActionPerformed(action2, event.getDataContext(), event);
        action2.actionPerformed(event);
        actionManager.fireAfterActionPerformed(action2, event.getDataContext(), event);
    }

    @NotNull
    private static DataContext createEditorContext(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/EditorTestUtil", "createEditorContext"));
        }
        Editor hostEditor = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
        Map map2 = ContainerUtil.newHashMap((Pair)Pair.create((Object)CommonDataKeys.HOST_EDITOR.getName(), (Object)hostEditor), (Pair[])new Pair[]{Pair.createNonNull((Object)CommonDataKeys.EDITOR.getName(), (Object)editor)});
        DataContext parent = DataManager.getInstance().getDataContext((Component)editor.getContentComponent());
        DataContext dataContext = SimpleDataContext.getSimpleContext(map2, parent);
        if (dataContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/EditorTestUtil", "createEditorContext"));
        }
        return dataContext;
    }

    public static void performReferenceCopy(Editor editor) {
        EditorTestUtil.executeAction(editor, "CopyReference", true);
    }

    public static void performPaste(Editor editor) {
        EditorTestUtil.executeAction(editor, "EditorPaste", true);
    }

    public static List<IElementType> getAllTokens(EditorHighlighter highlighter2) {
        ArrayList<IElementType> tokens = new ArrayList<IElementType>();
        HighlighterIterator iterator2 = highlighter2.createIterator(0);
        while (!iterator2.atEnd()) {
            tokens.add(iterator2.getTokenType());
            iterator2.advance();
        }
        return tokens;
    }

    public static int getCaretPosition(@NotNull String content2) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/testFramework/EditorTestUtil", "getCaretPosition"));
        }
        return EditorTestUtil.getCaretAndSelectionPosition(content2)[0];
    }

    public static int[] getCaretAndSelectionPosition(@NotNull String content2) {
        String visualOffsetString;
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/testFramework/EditorTestUtil", "getCaretAndSelectionPosition"));
        }
        int caretPosInSourceFile = content2.indexOf(CARET_TAG_PREFIX);
        int caretEndInSourceFile = content2.indexOf(">", caretPosInSourceFile);
        int caretLength = caretEndInSourceFile - caretPosInSourceFile;
        int visualColumnOffset = 0;
        if (caretPosInSourceFile >= 0 && (visualOffsetString = content2.substring(caretPosInSourceFile + CARET_TAG_PREFIX.length(), caretEndInSourceFile)).length() > 1) {
            visualColumnOffset = Integer.parseInt(visualOffsetString.substring(1));
        }
        int selectionStartInSourceFile = content2.indexOf(SELECTION_START_TAG);
        int selectionEndInSourceFile = content2.indexOf(SELECTION_END_TAG);
        if (selectionStartInSourceFile >= 0) {
            if (caretPosInSourceFile >= 0) {
                if (caretPosInSourceFile < selectionStartInSourceFile) {
                    selectionStartInSourceFile -= caretLength;
                    selectionEndInSourceFile -= caretLength;
                } else {
                    caretPosInSourceFile = caretPosInSourceFile < selectionEndInSourceFile ? (caretPosInSourceFile -= SELECTION_START_TAG.length()) : (caretPosInSourceFile -= SELECTION_START_TAG.length() + SELECTION_END_TAG.length());
                }
            }
            selectionEndInSourceFile -= SELECTION_START_TAG.length();
        }
        return new int[]{caretPosInSourceFile, visualColumnOffset, selectionStartInSourceFile, selectionEndInSourceFile};
    }

    public static boolean configureSoftWraps(Editor editor, int charCountToWrapAt) {
        int charWidthInPixels = 10;
        return EditorTestUtil.configureSoftWraps(editor, (charCountToWrapAt + 1) * charWidthInPixels + 1, charWidthInPixels);
    }

    public static boolean configureSoftWraps(Editor editor, final int visibleWidth, final int charWidthInPixels) {
        editor.getSettings().setUseSoftWraps(true);
        SoftWrapModelImpl model2 = (SoftWrapModelImpl)editor.getSoftWrapModel();
        model2.setSoftWrapPainter(new SoftWrapPainter(){

            @Override
            public int paint(@NotNull Graphics g2, @NotNull SoftWrapDrawingType drawingType, int x2, int y2, int lineHeight) {
                if (g2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/testFramework/EditorTestUtil$1", "paint"));
                }
                if (drawingType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drawingType", "com/intellij/testFramework/EditorTestUtil$1", "paint"));
                }
                return charWidthInPixels;
            }

            @Override
            public int getDrawingHorizontalOffset(@NotNull Graphics g2, @NotNull SoftWrapDrawingType drawingType, int x2, int y2, int lineHeight) {
                if (g2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/testFramework/EditorTestUtil$1", "getDrawingHorizontalOffset"));
                }
                if (drawingType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drawingType", "com/intellij/testFramework/EditorTestUtil$1", "getDrawingHorizontalOffset"));
                }
                return charWidthInPixels;
            }

            @Override
            public int getMinDrawingWidth(@NotNull SoftWrapDrawingType drawingType) {
                if (drawingType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drawingType", "com/intellij/testFramework/EditorTestUtil$1", "getMinDrawingWidth"));
                }
                return charWidthInPixels;
            }

            @Override
            public boolean canUse() {
                return true;
            }

            @Override
            public void reinit() {
            }
        });
        model2.reinitSettings();
        SoftWrapApplianceManager applianceManager = model2.getApplianceManager();
        applianceManager.setWidthProvider(new SoftWrapApplianceManager.VisibleAreaWidthProvider(){

            @Override
            public int getVisibleAreaWidth() {
                return visibleWidth;
            }
        });
        model2.setEditorTextRepresentationHelper(new DefaultEditorTextRepresentationHelper(editor){

            @Override
            public int charWidth(int c2, int fontType) {
                return charWidthInPixels;
            }
        });
        EditorTestUtil.setEditorVisibleSizeInPixels(editor, visibleWidth, 1000);
        applianceManager.registerSoftWrapIfNecessary();
        return !model2.getRegisteredSoftWraps().isEmpty();
    }

    public static void setEditorVisibleSize(Editor editor, int widthInChars, int heightInChars) {
        EditorTestUtil.setEditorVisibleSizeInPixels(editor, widthInChars * EditorUtil.getSpaceWidth(0, editor), heightInChars * editor.getLineHeight());
    }

    public static void setEditorVisibleSizeInPixels(Editor editor, int widthInPixels, int heightInPixels) {
        Dimension size = new Dimension(widthInPixels, heightInPixels);
        ((EditorEx)editor).getScrollPane().getViewport().setExtentSize(size);
    }

    @NotNull
    public static CaretAndSelectionState extractCaretAndSelectionMarkers(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/testFramework/EditorTestUtil", "extractCaretAndSelectionMarkers"));
        }
        CaretAndSelectionState caretAndSelectionState = EditorTestUtil.extractCaretAndSelectionMarkers(document, true);
        if (caretAndSelectionState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/EditorTestUtil", "extractCaretAndSelectionMarkers"));
        }
        return caretAndSelectionState;
    }

    @NotNull
    public static CaretAndSelectionState extractCaretAndSelectionMarkers(final @NotNull Document document, final boolean processBlockSelection) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/testFramework/EditorTestUtil", "extractCaretAndSelectionMarkers"));
        }
        CaretAndSelectionState caretAndSelectionState = (CaretAndSelectionState)new WriteCommandAction<CaretAndSelectionState>(null, new PsiFile[0]){

            public void run(@NotNull Result<CaretAndSelectionState> actionResult) {
                if (actionResult == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionResult", "com/intellij/testFramework/EditorTestUtil$4", "run"));
                }
                actionResult.setResult((Object)EditorTestUtil.extractCaretAndSelectionMarkersImpl(document, processBlockSelection));
            }
        }.execute().getResultObject();
        if (caretAndSelectionState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/EditorTestUtil", "extractCaretAndSelectionMarkers"));
        }
        return caretAndSelectionState;
    }

    @NotNull
    public static CaretAndSelectionState extractCaretAndSelectionMarkersImpl(@NotNull Document document, boolean processBlockSelection) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/testFramework/EditorTestUtil", "extractCaretAndSelectionMarkersImpl"));
        }
        ArrayList carets = ContainerUtil.newArrayList();
        String fileText = document.getText();
        RangeMarker blockSelectionStartMarker = null;
        RangeMarker blockSelectionEndMarker = null;
        if (processBlockSelection) {
            int blockSelectionEnd;
            int blockSelectionStart = fileText.indexOf(BLOCK_SELECTION_START_TAG);
            if ((blockSelectionStart ^ (blockSelectionEnd = fileText.indexOf(BLOCK_SELECTION_END_TAG))) < 0) {
                throw new IllegalArgumentException("Both block selection opening and closing tag must be present");
            }
            if (blockSelectionStart >= 0) {
                blockSelectionStartMarker = document.createRangeMarker(blockSelectionStart, blockSelectionStart);
                blockSelectionEndMarker = document.createRangeMarker(blockSelectionEnd, blockSelectionEnd);
                document.deleteString(blockSelectionStartMarker.getStartOffset(), blockSelectionStartMarker.getStartOffset() + BLOCK_SELECTION_START_TAG.length());
                document.deleteString(blockSelectionEndMarker.getStartOffset(), blockSelectionEndMarker.getStartOffset() + BLOCK_SELECTION_END_TAG.length());
            }
        }
        boolean multiCaret = StringUtil.getOccurrenceCount((String)document.getText(), (String)CARET_TAG) > 1 || StringUtil.getOccurrenceCount((String)document.getText(), (String)SELECTION_START_TAG) > 1;
        int pos = 0;
        while (pos < document.getTextLength()) {
            RangeMarker selEndMarker;
            int selEndIndex;
            fileText = document.getText();
            int caretIndex = fileText.indexOf(CARET_TAG, pos);
            int selStartIndex = fileText.indexOf(SELECTION_START_TAG, pos);
            if ((selStartIndex ^ (selEndIndex = fileText.indexOf(SELECTION_END_TAG, pos))) < 0) {
                selStartIndex = -1;
                selEndIndex = -1;
            }
            if (0 <= selEndIndex && selEndIndex < selStartIndex) {
                throw new IllegalArgumentException("Wrong order of selection opening and closing tags");
            }
            if (caretIndex < 0 && selStartIndex < 0 && selEndIndex < 0) break;
            if (multiCaret && 0 <= caretIndex && caretIndex < selStartIndex) {
                selStartIndex = -1;
                selEndIndex = -1;
            }
            if (multiCaret && caretIndex > selEndIndex && selEndIndex >= 0) {
                caretIndex = -1;
            }
            RangeMarker caretMarker = caretIndex >= 0 ? document.createRangeMarker(caretIndex, caretIndex) : null;
            RangeMarker selStartMarker = selStartIndex >= 0 ? document.createRangeMarker(selStartIndex, selStartIndex) : null;
            RangeMarker rangeMarker = selEndMarker = selEndIndex >= 0 ? document.createRangeMarker(selEndIndex, selEndIndex) : null;
            if (caretMarker != null) {
                document.deleteString(caretMarker.getStartOffset(), caretMarker.getStartOffset() + CARET_TAG.length());
            }
            if (selStartMarker != null) {
                document.deleteString(selStartMarker.getStartOffset(), selStartMarker.getStartOffset() + SELECTION_START_TAG.length());
            }
            if (selEndMarker != null) {
                document.deleteString(selEndMarker.getStartOffset(), selEndMarker.getStartOffset() + SELECTION_END_TAG.length());
            }
            LogicalPosition caretPosition = null;
            if (caretMarker != null) {
                int line = document.getLineNumber(caretMarker.getStartOffset());
                int column = caretMarker.getStartOffset() - document.getLineStartOffset(line);
                caretPosition = new LogicalPosition(line, column);
            }
            carets.add(new CaretInfo(caretPosition, selStartMarker == null || selEndMarker == null ? null : new TextRange(selStartMarker.getStartOffset(), selEndMarker.getEndOffset())));
            pos = Math.max(caretMarker == null ? -1 : caretMarker.getStartOffset(), selEndMarker == null ? -1 : selEndMarker.getEndOffset());
        }
        if (carets.isEmpty()) {
            carets.add(new CaretInfo(null, null));
        }
        TextRange blockSelection = null;
        if (blockSelectionStartMarker != null) {
            blockSelection = new TextRange(blockSelectionStartMarker.getStartOffset(), blockSelectionEndMarker.getStartOffset());
        }
        CaretAndSelectionState caretAndSelectionState = new CaretAndSelectionState(Arrays.asList(carets.toArray(new CaretInfo[carets.size()])), blockSelection);
        if (caretAndSelectionState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/EditorTestUtil", "extractCaretAndSelectionMarkersImpl"));
        }
        return caretAndSelectionState;
    }

    public static void setCaretsAndSelection(Editor editor, CaretAndSelectionState caretsState) {
        CaretModel caretModel = editor.getCaretModel();
        if (caretModel.supportsMultipleCarets()) {
            ArrayList<CaretState> states = new ArrayList<CaretState>(caretsState.carets.size());
            for (CaretInfo caret : caretsState.carets) {
                states.add(new CaretState(caret.position == null ? null : editor.offsetToLogicalPosition(caret.getCaretOffset(editor.getDocument())), caret.selection == null ? null : editor.offsetToLogicalPosition(caret.selection.getStartOffset()), caret.selection == null ? null : editor.offsetToLogicalPosition(caret.selection.getEndOffset())));
            }
            caretModel.setCaretsAndSelections(states);
        } else {
            Assert.assertEquals((String)"Multiple carets are not supported by the model", (long)1L, (long)caretsState.carets.size());
            CaretInfo caret = caretsState.carets.get(0);
            if (caret.position != null) {
                caretModel.moveToOffset(caret.getCaretOffset(editor.getDocument()));
            }
            if (caret.selection != null) {
                editor.getSelectionModel().setSelection(caret.selection.getStartOffset(), caret.selection.getEndOffset());
            } else {
                editor.getSelectionModel().removeSelection();
            }
        }
        if (caretsState.blockSelection != null) {
            editor.getSelectionModel().setBlockSelection(editor.offsetToLogicalPosition(caretsState.blockSelection.getStartOffset()), editor.offsetToLogicalPosition(caretsState.blockSelection.getEndOffset()));
        }
    }

    public static void verifyCaretAndSelectionState(Editor editor, CaretAndSelectionState caretState) {
        EditorTestUtil.verifyCaretAndSelectionState(editor, caretState, null);
    }

    public static void verifyCaretAndSelectionState(Editor editor, CaretAndSelectionState caretState, String message2) {
        boolean hasChecks = false;
        for (int i2 = 0; i2 < caretState.carets.size(); ++i2) {
            CaretInfo expected = caretState.carets.get(i2);
            if (expected.position == null && expected.selection == null) continue;
            hasChecks = true;
            break;
        }
        if (!hasChecks) {
            return;
        }
        String messageSuffix = message2 == null ? "" : message2 + ": ";
        CaretModel caretModel = editor.getCaretModel();
        ArrayList allCarets = new ArrayList(caretModel.getAllCarets());
        Assert.assertEquals((String)(messageSuffix + " Unexpected number of carets"), (long)caretState.carets.size(), (long)allCarets.size());
        for (int i3 = 0; i3 < caretState.carets.size(); ++i3) {
            String caretDescription = caretState.carets.size() == 1 ? "" : "caret " + (i3 + 1) + "/" + caretState.carets.size() + " ";
            Caret currentCaret = (Caret)allCarets.get(i3);
            int actualCaretLine = editor.getDocument().getLineNumber(currentCaret.getOffset());
            int actualCaretColumn = currentCaret.getOffset() - editor.getDocument().getLineStartOffset(actualCaretLine);
            LogicalPosition actualCaretPosition = new LogicalPosition(actualCaretLine, actualCaretColumn);
            int selectionStart = currentCaret.getSelectionStart();
            int selectionEnd = currentCaret.getSelectionEnd();
            LogicalPosition actualSelectionStart = editor.offsetToLogicalPosition(selectionStart);
            LogicalPosition actualSelectionEnd = editor.offsetToLogicalPosition(selectionEnd);
            CaretInfo expected = caretState.carets.get(i3);
            if (expected.position != null) {
                Assert.assertEquals((String)(messageSuffix + caretDescription + "unexpected caret position"), (Object)expected.position, (Object)actualCaretPosition);
            }
            if (expected.selection != null) {
                LogicalPosition expectedSelectionStart = editor.offsetToLogicalPosition(expected.selection.getStartOffset());
                LogicalPosition expectedSelectionEnd = editor.offsetToLogicalPosition(expected.selection.getEndOffset());
                Assert.assertEquals((String)(messageSuffix + caretDescription + "unexpected selection start"), (Object)expectedSelectionStart, (Object)actualSelectionStart);
                Assert.assertEquals((String)(messageSuffix + caretDescription + "unexpected selection end"), (Object)expectedSelectionEnd, (Object)actualSelectionEnd);
                continue;
            }
            Assert.assertFalse((String)(messageSuffix + caretDescription + "should has no selection, but was: (" + actualSelectionStart + ", " + actualSelectionEnd + ")"), (boolean)currentCaret.hasSelection());
        }
    }

    public static FoldRegion addFoldRegion(@NotNull Editor editor, int startOffset, int endOffset, String placeholder, boolean collapse) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/EditorTestUtil", "addFoldRegion"));
        }
        FoldingModel foldingModel = editor.getFoldingModel();
        Ref ref = new Ref();
        foldingModel.runBatchFoldingOperation(() -> {
            FoldRegion region = foldingModel.addFoldRegion(startOffset, endOffset, placeholder);
            Assert.assertNotNull((Object)region);
            region.setExpanded(!collapse);
            ref.set((Object)region);
        });
        return (FoldRegion)ref.get();
    }

    public static Inlay addInlay(@NotNull Editor editor, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/EditorTestUtil", "addInlay"));
        }
        return editor.getInlayModel().addInlineElement(offset, new EditorCustomElementRenderer(){

            public int calcWidthInPixels(@NotNull Editor editor) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/EditorTestUtil$5", "calcWidthInPixels"));
                }
                return 1;
            }

            public void paint(@NotNull Editor editor, @NotNull Graphics g2, @NotNull Rectangle r2) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/EditorTestUtil$5", "paint"));
                }
                if (g2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/testFramework/EditorTestUtil$5", "paint"));
                }
                if (r2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/testFramework/EditorTestUtil$5", "paint"));
                }
            }
        });
    }

    public static void waitForLoading(Editor editor) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (editor == null) {
            return;
        }
        while (!AsyncEditorLoader.isEditorLoaded(editor)) {
            LockSupport.parkNanos(100000000L);
            UIUtil.dispatchAllInvocationEvents();
        }
    }

    public static class CaretInfo {
        @Nullable
        public final LogicalPosition position;
        @Nullable
        public final TextRange selection;

        public CaretInfo(@Nullable LogicalPosition position, @Nullable TextRange selection) {
            this.position = position;
            this.selection = selection;
        }

        public int getCaretOffset(Document document) {
            return this.position == null ? -1 : document.getLineStartOffset(this.position.line) + this.position.column;
        }
    }

    public static class CaretAndSelectionState {
        public final List<CaretInfo> carets;
        public final TextRange blockSelection;

        public CaretAndSelectionState(List<CaretInfo> carets, @Nullable TextRange blockSelection) {
            this.carets = carets;
            this.blockSelection = blockSelection;
        }

        public boolean hasExplicitCaret() {
            if (this.carets.isEmpty()) {
                return false;
            }
            if (this.blockSelection == null && this.carets.size() == 1) {
                CaretInfo caret = this.carets.get(0);
                return caret.position != null || caret.selection != null;
            }
            return true;
        }
    }
}

