/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.TrailingSpacesStripper;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.EditorTestUtil;
import com.intellij.testFramework.FileBasedTestCaseHelper;
import com.intellij.testFramework.FileBasedTestCaseHelperEx;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.Parameterized;
import com.intellij.testFramework.TestDataPath;
import com.intellij.testFramework.VfsTestUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.After;
import org.junit.Before;
import org.junit.runners.Parameterized;

public abstract class LightPlatformCodeInsightTestCase
extends LightPlatformTestCase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.testFramework.LightCodeInsightTestCase");
    protected static Editor myEditor;
    protected static PsiFile myFile;
    protected static VirtualFile myVFile;
    @Parameterized.Parameter(value=0)
    public String myFileSuffix;
    @Parameterized.Parameter(value=1)
    public String myTestDataPath;

    @Override
    protected void runTest() throws Throwable {
        if (this.isRunInWriteAction()) {
            WriteCommandAction.runWriteCommandAction((Project)LightPlatformCodeInsightTestCase.getProject(), () -> {
                this.doRunTest();
                return null;
            });
        } else {
            new WriteCommandAction.Simple(LightPlatformCodeInsightTestCase.getProject(), new PsiFile[0]){

                protected void run() throws Throwable {
                    LightPlatformCodeInsightTestCase.this.doRunTest();
                }
            }.performCommand();
        }
    }

    protected void doRunTest() throws Throwable {
        super.runTest();
    }

    protected boolean isRunInWriteAction() {
        return false;
    }

    protected void configureByFile(@NonNls @NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "configureByFile"));
        }
        try {
            String fullPath = this.getTestDataPath() + filePath;
            File ioFile = new File(fullPath);
            LightPlatformCodeInsightTestCase.checkCaseSensitiveFS(fullPath, ioFile);
            String fileText = FileUtilRt.loadFile((File)ioFile, (String)"UTF-8", (boolean)true);
            LightPlatformCodeInsightTestCase.configureFromFileText(ioFile.getName(), fileText);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    private static void checkCaseSensitiveFS(String fullOrRelativePath, File ioFile) throws IOException {
        fullOrRelativePath = FileUtil.toSystemDependentName((String)FileUtil.toCanonicalPath((String)fullOrRelativePath));
        if (!ioFile.getCanonicalPath().endsWith(fullOrRelativePath)) {
            throw new RuntimeException("Search for: " + fullOrRelativePath + "; but found: " + ioFile.getCanonicalPath());
        }
    }

    @NonNls
    @NotNull
    protected String getTestDataPath() {
        if (this.myTestDataPath != null) {
            String string2 = this.myTestDataPath;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "getTestDataPath"));
            }
            return string2;
        }
        String string3 = PathManagerEx.getTestDataPath();
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "getTestDataPath"));
        }
        return string3;
    }

    @NotNull
    protected VirtualFile getVirtualFile(@NonNls @NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "getVirtualFile"));
        }
        String fullPath = this.getTestDataPath() + filePath;
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(fullPath.replace(File.separatorChar, '/'));
        LightPlatformCodeInsightTestCase.assertNotNull((String)("file " + fullPath + " not found"), (Object)vFile);
        VirtualFile virtualFile = vFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "getVirtualFile"));
        }
        return virtualFile;
    }

    @NotNull
    protected static Document configureFromFileText(@NonNls @NotNull String fileName, @NonNls @NotNull String fileText) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "configureFromFileText"));
        }
        if (fileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "configureFromFileText"));
        }
        Document document = LightPlatformCodeInsightTestCase.configureFromFileText(fileName, fileText, false);
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "configureFromFileText"));
        }
        return document;
    }

    @NotNull
    protected static Document configureFromFileText(final @NonNls @NotNull String fileName, final @NonNls @NotNull String fileText, final boolean checkCaret) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "configureFromFileText"));
        }
        if (fileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "configureFromFileText"));
        }
        Document document = (Document)new WriteCommandAction<Document>(null, new PsiFile[0]){

            protected void run(@NotNull Result<Document> result2) throws Throwable {
                Document document;
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/LightPlatformCodeInsightTestCase$2", "run"));
                }
                DocumentImpl fakeDocument = new DocumentImpl(fileText);
                EditorTestUtil.CaretAndSelectionState caretsState = EditorTestUtil.extractCaretAndSelectionMarkers(fakeDocument);
                if (checkCaret) {
                    TestCase.assertTrue((String)("No caret specified in " + fileName), (boolean)caretsState.hasExplicitCaret());
                }
                String newFileText = fakeDocument.getText();
                try {
                    document = LightPlatformCodeInsightTestCase.setupFileEditorAndDocument(fileName, newFileText);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
                EditorTestUtil.setCaretsAndSelection(myEditor, caretsState);
                LightPlatformCodeInsightTestCase.setupEditorForInjectedLanguage();
                result2.setResult((Object)document);
            }
        }.execute().getResultObject();
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "configureFromFileText"));
        }
        return document;
    }

    @NotNull
    protected static Editor configureFromFileTextWithoutPSI(final @NonNls @NotNull String fileText) {
        if (fileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "configureFromFileTextWithoutPSI"));
        }
        Editor editor = (Editor)new WriteCommandAction<Editor>(null, new PsiFile[0]){

            protected void run(@NotNull Result<Editor> result2) throws Throwable {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/LightPlatformCodeInsightTestCase$3", "run"));
                }
                Document fakeDocument = EditorFactory.getInstance().createDocument((CharSequence)fileText);
                EditorTestUtil.CaretAndSelectionState caretsState = EditorTestUtil.extractCaretAndSelectionMarkers(fakeDocument);
                String newFileText = fakeDocument.getText();
                Document document = EditorFactory.getInstance().createDocument((CharSequence)newFileText);
                Editor editor = EditorFactory.getInstance().createEditor(document);
                ((EditorImpl)editor).setCaretActive();
                EditorTestUtil.setCaretsAndSelection(editor, caretsState);
                result2.setResult((Object)editor);
            }
        }.execute().getResultObject();
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "configureFromFileTextWithoutPSI"));
        }
        return editor;
    }

    @NotNull
    protected static Editor createEditor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "createEditor"));
        }
        PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
        Editor editor = FileEditorManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).openTextEditor(new OpenFileDescriptor(LightPlatformCodeInsightTestCase.getProject(), file2, 0), false);
        DaemonCodeAnalyzer.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).restart();
        LightPlatformCodeInsightTestCase.assertNotNull((Object)editor);
        ((EditorImpl)editor).setCaretActive();
        Editor editor2 = editor;
        if (editor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "createEditor"));
        }
        return editor2;
    }

    @NotNull
    private static Document setupFileEditorAndDocument(@NotNull String fileName, @NotNull String fileText) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "setupFileEditorAndDocument"));
        }
        if (fileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "setupFileEditorAndDocument"));
        }
        EncodingProjectManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).setEncoding(null, CharsetToolkit.UTF8_CHARSET);
        EncodingProjectManager.getInstance((Project)ProjectManager.getInstance().getDefaultProject()).setEncoding(null, CharsetToolkit.UTF8_CHARSET);
        PostprocessReformattingAspect.getInstance(ourProject).doPostponedFormatting();
        LightPlatformCodeInsightTestCase.deleteVFile();
        myEditor = LightPlatformCodeInsightTestCase.createSaveAndOpenFile(fileName, fileText);
        myVFile = FileDocumentManager.getInstance().getFile(myEditor.getDocument());
        myFile = LightPlatformCodeInsightTestCase.getPsiManager().findFile(myVFile);
        Document document = myEditor.getDocument();
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "setupFileEditorAndDocument"));
        }
        return document;
    }

    @NotNull
    protected static Editor createSaveAndOpenFile(final @NotNull String relativePath, final @NotNull String fileText) throws IOException {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "createSaveAndOpenFile"));
        }
        if (fileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "createSaveAndOpenFile"));
        }
        Editor editor = (Editor)WriteCommandAction.runWriteCommandAction((Project)LightPlatformCodeInsightTestCase.getProject(), (ThrowableComputable)new ThrowableComputable<Editor, IOException>(){

            public Editor compute() throws IOException {
                VirtualFile myVFile = VfsTestUtil.createFile(LightPlatformTestCase.getSourceRoot(), relativePath);
                VfsUtil.saveText((VirtualFile)myVFile, (String)fileText);
                FileDocumentManager manager = FileDocumentManager.getInstance();
                Document document = manager.getDocument(myVFile);
                TestCase.assertNotNull((String)("Can't create document for '" + relativePath + "'"), (Object)document);
                manager.reloadFromDisk(document);
                document.insertString(0, (CharSequence)" ");
                document.deleteString(0, 1);
                PsiFile myFile = LightPlatformTestCase.getPsiManager().findFile(myVFile);
                TestCase.assertNotNull((String)("Can't create PsiFile for '" + relativePath + "'. Unknown file type most probably."), (Object)myFile);
                TestCase.assertTrue((boolean)myFile.isPhysical());
                Editor myEditor = LightPlatformCodeInsightTestCase.createEditor(myVFile);
                myVFile.setCharset(CharsetToolkit.UTF8_CHARSET);
                PsiDocumentManager.getInstance((Project)LightPlatformTestCase.getProject()).commitAllDocuments();
                return myEditor;
            }
        });
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "createSaveAndOpenFile"));
        }
        return editor;
    }

    @NotNull
    protected static VirtualFile createAndSaveFile(@NotNull String relativePath, @NotNull String fileText) throws IOException {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "createAndSaveFile"));
        }
        if (fileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "createAndSaveFile"));
        }
        VirtualFile virtualFile = (VirtualFile)WriteCommandAction.runWriteCommandAction((Project)LightPlatformCodeInsightTestCase.getProject(), () -> {
            if (relativePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "lambda$createAndSaveFile$1"));
            }
            if (fileText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "lambda$createAndSaveFile$1"));
            }
            VirtualFile myVFile = VfsTestUtil.createFile(LightPlatformCodeInsightTestCase.getSourceRoot(), relativePath);
            VfsUtil.saveText((VirtualFile)myVFile, (String)fileText);
            return myVFile;
        });
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "createAndSaveFile"));
        }
        return virtualFile;
    }

    private static void setupEditorForInjectedLanguage() {
        if (myEditor != null) {
            Ref editorWindowRef = new Ref();
            myEditor.getCaretModel().runForEachCaret(caret -> {
                Editor editor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(myEditor, myFile);
                if (caret == myEditor.getCaretModel().getPrimaryCaret() && editor instanceof EditorWindow) {
                    editorWindowRef.set((Object)((EditorWindow)editor));
                }
            });
            if (!editorWindowRef.isNull()) {
                myEditor = (Editor)editorWindowRef.get();
                myFile = ((EditorWindow)editorWindowRef.get()).getInjectedFile();
            }
        }
    }

    private static void deleteVFile() throws IOException {
        if (myVFile != null) {
            WriteAction.run(() -> {
                PsiDocumentManager.getInstance((Project)ourProject).commitAllDocuments();
                FileEditorManager.getInstance((Project)ourProject).closeFile(myVFile);
                myVFile.delete((Object)ourProject);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        try {
            FileEditorManager editorManager = FileEditorManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject());
            for (VirtualFile openFile2 : editorManager.getOpenFiles()) {
                editorManager.closeFile(openFile2);
            }
            LightPlatformCodeInsightTestCase.deleteVFile();
            myEditor = null;
            myFile = null;
            myVFile = null;
        }
        finally {
            super.tearDown();
        }
    }

    protected void checkResultByFile(@NonNls @NotNull String expectedFilePath) {
        if (expectedFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedFilePath", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "checkResultByFile"));
        }
        this.checkResultByFile(null, expectedFilePath, false);
    }

    protected void checkResultByFile(@Nullable String message2, @NotNull String expectedFilePath, boolean ignoreTrailingSpaces) {
        String fileText;
        if (expectedFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedFilePath", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "checkResultByFile"));
        }
        LightPlatformCodeInsightTestCase.bringRealEditorBack();
        ((PostprocessReformattingAspect)LightPlatformCodeInsightTestCase.getProject().getComponent(PostprocessReformattingAspect.class)).doPostponedFormatting();
        if (ignoreTrailingSpaces) {
            Editor editor = myEditor;
            TrailingSpacesStripper.strip(editor.getDocument(), false, true);
            EditorUtil.fillVirtualSpaceUntilCaret(editor);
        }
        PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
        String fullPath = this.getTestDataPath() + expectedFilePath;
        File ioFile = new File(fullPath);
        LightPlatformCodeInsightTestCase.assertTrue((String)LightPlatformCodeInsightTestCase.getMessage("Cannot find file " + fullPath, message2), (boolean)ioFile.exists());
        try {
            LightPlatformCodeInsightTestCase.checkCaseSensitiveFS(fullPath, ioFile);
            fileText = FileUtil.loadFile((File)ioFile, (Charset)CharsetToolkit.UTF8_CHARSET);
        }
        catch (IOException e2) {
            LOG.error((Throwable)e2);
            throw new RuntimeException(e2);
        }
        this.checkResultByText(message2, StringUtil.convertLineSeparators((String)fileText), ignoreTrailingSpaces, this.getTestDataPath() + "/" + expectedFilePath);
    }

    protected void checkResultByText(@NonNls @NotNull String expectedFileText) {
        if (expectedFileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedFileText", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "checkResultByText"));
        }
        this.checkResultByText(null, expectedFileText, false, null);
    }

    protected void checkResultByText(String message2, @NotNull String expectedFileText, boolean ignoreTrailingSpaces) {
        if (expectedFileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedFileText", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "checkResultByText"));
        }
        this.checkResultByText(message2, expectedFileText, ignoreTrailingSpaces, null);
    }

    protected void checkResultByText(String message2, @NotNull String expectedFileText, boolean ignoreTrailingSpaces, String filePath) {
        if (expectedFileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedFileText", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "checkResultByText"));
        }
        LightPlatformCodeInsightTestCase.bringRealEditorBack();
        PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (expectedFileText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedFileText", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "lambda$checkResultByText$4"));
            }
            Document document = EditorFactory.getInstance().createDocument((CharSequence)expectedFileText);
            if (ignoreTrailingSpaces) {
                ((DocumentImpl)document).stripTrailingSpaces(LightPlatformCodeInsightTestCase.getProject());
            }
            EditorTestUtil.CaretAndSelectionState carets = EditorTestUtil.extractCaretAndSelectionMarkers(document);
            PostprocessReformattingAspect.getInstance(LightPlatformCodeInsightTestCase.getProject()).doPostponedFormatting();
            String newFileText = document.getText();
            PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
            String fileText1 = myFile.getText();
            String failMessage = LightPlatformCodeInsightTestCase.getMessage("Text mismatch", message2);
            if (filePath != null && !newFileText.equals(fileText1)) {
                throw new FileComparisonFailure(failMessage, newFileText, fileText1, filePath);
            }
            LightPlatformCodeInsightTestCase.assertEquals((String)failMessage, (String)newFileText, (String)fileText1);
            EditorTestUtil.verifyCaretAndSelectionState(myEditor, carets, message2);
        });
    }

    protected static void checkResultByTextWithoutPSI(String message2, @NotNull Editor editor, @NotNull String fileText, boolean ignoreTrailingSpaces, String filePath) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "checkResultByTextWithoutPSI"));
        }
        if (fileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "checkResultByTextWithoutPSI"));
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (fileText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "lambda$checkResultByTextWithoutPSI$5"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "lambda$checkResultByTextWithoutPSI$5"));
            }
            Document fakeDocument = EditorFactory.getInstance().createDocument((CharSequence)fileText);
            if (ignoreTrailingSpaces) {
                ((DocumentImpl)fakeDocument).stripTrailingSpaces(LightPlatformCodeInsightTestCase.getProject());
            }
            EditorTestUtil.CaretAndSelectionState carets = EditorTestUtil.extractCaretAndSelectionMarkers(fakeDocument);
            String newFileText = fakeDocument.getText();
            String fileText1 = editor.getDocument().getText();
            String failMessage = LightPlatformCodeInsightTestCase.getMessage("Text mismatch", message2);
            if (filePath != null && !newFileText.equals(fileText1)) {
                throw new FileComparisonFailure(failMessage, newFileText, fileText1, filePath);
            }
            LightPlatformCodeInsightTestCase.assertEquals((String)failMessage, (String)newFileText, (String)fileText1);
            EditorTestUtil.verifyCaretAndSelectionState(editor, carets, message2);
        });
    }

    @NotNull
    private static String getMessage(@NonNls @NotNull String engineMessage, String userMessage) {
        if (engineMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "engineMessage", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "getMessage"));
        }
        if (userMessage == null) {
            String string2 = engineMessage;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "getMessage"));
            }
            return string2;
        }
        String string3 = userMessage + " [" + engineMessage + "]";
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "getMessage"));
        }
        return string3;
    }

    protected static Editor getEditor() {
        return myEditor;
    }

    protected static PsiFile getFile() {
        return myFile;
    }

    protected static VirtualFile getVFile() {
        return myVFile;
    }

    protected static void bringRealEditorBack() {
        PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
        if (myEditor instanceof EditorWindow) {
            Document document = ((DocumentWindow)myEditor.getDocument()).getDelegate();
            myFile = PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).getPsiFile(document);
            myEditor = ((EditorWindow)myEditor).getDelegate();
            myVFile = myFile.getVirtualFile();
        }
    }

    protected void caretRight() {
        LightPlatformCodeInsightTestCase.caretRight(LightPlatformCodeInsightTestCase.getEditor());
    }

    public static void caretRight(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "caretRight"));
        }
        LightPlatformCodeInsightTestCase.executeAction("EditorRight", editor);
    }

    protected void caretUp() {
        LightPlatformCodeInsightTestCase.caretUp(LightPlatformCodeInsightTestCase.getEditor());
    }

    public static void caretUp(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "caretUp"));
        }
        LightPlatformCodeInsightTestCase.executeAction("EditorUp", editor);
    }

    protected void deleteLine() {
        LightPlatformCodeInsightTestCase.deleteLine(LightPlatformCodeInsightTestCase.getEditor(), LightPlatformCodeInsightTestCase.getProject());
    }

    public static void deleteLine(@NotNull Editor editor, Project project2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "deleteLine"));
        }
        LightPlatformCodeInsightTestCase.executeAction("EditorDeleteLine", editor, project2);
    }

    protected void type(@NonNls @NotNull String s2) {
        if (s2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "type"));
        }
        for (char c2 : s2.toCharArray()) {
            this.type(c2);
        }
    }

    protected void type(char c2) {
        LightPlatformCodeInsightTestCase.type(c2, LightPlatformCodeInsightTestCase.getEditor(), LightPlatformCodeInsightTestCase.getProject());
    }

    public static void type(char c2, @NotNull Editor editor, Project project2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "type"));
        }
        if (c2 == '\n') {
            LightPlatformCodeInsightTestCase.executeAction("EditorEnter", editor, project2);
        } else {
            EditorActionManager actionManager = EditorActionManager.getInstance();
            DataContext dataContext = DataManager.getInstance().getDataContext();
            TypedAction action2 = actionManager.getTypedAction();
            action2.actionPerformed(editor, c2, dataContext);
        }
    }

    protected void backspace() {
        LightPlatformCodeInsightTestCase.backspace(LightPlatformCodeInsightTestCase.getEditor(), LightPlatformCodeInsightTestCase.getProject());
    }

    public static void backspace(@NotNull Editor editor, Project project2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "backspace"));
        }
        LightPlatformCodeInsightTestCase.executeAction("EditorBackSpace", editor, project2);
    }

    protected void ctrlShiftF7() {
        HighlightUsagesHandler.invoke(LightPlatformCodeInsightTestCase.getProject(), LightPlatformCodeInsightTestCase.getEditor(), LightPlatformCodeInsightTestCase.getFile());
    }

    protected void ctrlW() {
        LightPlatformCodeInsightTestCase.ctrlW(LightPlatformCodeInsightTestCase.getEditor(), LightPlatformCodeInsightTestCase.getProject());
    }

    public static void ctrlW(@NotNull Editor editor, Project project2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "ctrlW"));
        }
        LightPlatformCodeInsightTestCase.executeAction("EditorSelectWord", editor, project2);
    }

    public void ctrlD() {
        LightPlatformCodeInsightTestCase.ctrlD(LightPlatformCodeInsightTestCase.getEditor(), LightPlatformCodeInsightTestCase.getProject());
    }

    public static void ctrlD(@NotNull Editor editor, Project project2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "ctrlD"));
        }
        LightPlatformCodeInsightTestCase.executeAction("EditorDuplicate", editor, project2);
    }

    protected void delete() {
        LightPlatformCodeInsightTestCase.delete(LightPlatformCodeInsightTestCase.getEditor(), LightPlatformCodeInsightTestCase.getProject());
    }

    public static void delete(@NotNull Editor editor, Project project2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "delete"));
        }
        LightPlatformCodeInsightTestCase.executeAction("EditorDelete", editor, project2);
    }

    protected static void home() {
        LightPlatformCodeInsightTestCase.executeAction("EditorLineStart");
    }

    protected static void end() {
        LightPlatformCodeInsightTestCase.executeAction("EditorLineEnd");
    }

    protected static void homeWithSelection() {
        LightPlatformCodeInsightTestCase.executeAction("EditorLineStartWithSelection");
    }

    protected static void endWithSelection() {
        LightPlatformCodeInsightTestCase.executeAction("EditorLineEndWithSelection");
    }

    protected static void copy() {
        LightPlatformCodeInsightTestCase.executeAction("EditorCopy");
    }

    protected static void paste() {
        LightPlatformCodeInsightTestCase.executeAction("EditorPaste");
    }

    protected static void moveCaretToPreviousWordWithSelection() {
        LightPlatformCodeInsightTestCase.executeAction("EditorPreviousWordWithSelection");
    }

    protected static void moveCaretToNextWordWithSelection() {
        LightPlatformCodeInsightTestCase.executeAction("EditorNextWordWithSelection");
    }

    protected static void previousWord() {
        LightPlatformCodeInsightTestCase.executeAction("EditorPreviousWord");
    }

    protected static void nextWord() {
        LightPlatformCodeInsightTestCase.executeAction("EditorNextWord");
    }

    protected static void cutLineBackward() {
        LightPlatformCodeInsightTestCase.executeAction("EditorCutLineBackward");
    }

    protected static void cutToLineEnd() {
        LightPlatformCodeInsightTestCase.executeAction("EditorCutLineEnd");
    }

    protected static void deleteToLineStart() {
        LightPlatformCodeInsightTestCase.executeAction("EditorDeleteToLineStart");
    }

    protected static void deleteToLineEnd() {
        LightPlatformCodeInsightTestCase.executeAction("EditorDeleteToLineEnd");
    }

    protected static void killToWordStart() {
        LightPlatformCodeInsightTestCase.executeAction("EditorKillToWordStart");
    }

    protected static void killToWordEnd() {
        LightPlatformCodeInsightTestCase.executeAction("EditorKillToWordEnd");
    }

    protected static void killRegion() {
        LightPlatformCodeInsightTestCase.executeAction("EditorKillRegion");
    }

    protected static void killRingSave() {
        LightPlatformCodeInsightTestCase.executeAction("EditorKillRingSave");
    }

    protected static void unindent() {
        LightPlatformCodeInsightTestCase.executeAction("EditorUnindentSelection");
    }

    protected static void selectLine() {
        LightPlatformCodeInsightTestCase.executeAction("EditorSelectLine");
    }

    protected static void left() {
        LightPlatformCodeInsightTestCase.executeAction("EditorLeft");
    }

    protected static void right() {
        LightPlatformCodeInsightTestCase.executeAction("EditorRight");
    }

    protected static void leftWithSelection() {
        LightPlatformCodeInsightTestCase.executeAction("EditorLeftWithSelection");
    }

    protected static void rightWithSelection() {
        LightPlatformCodeInsightTestCase.executeAction("EditorRightWithSelection");
    }

    protected static void up() {
        LightPlatformCodeInsightTestCase.executeAction("EditorUp");
    }

    protected static void down() {
        LightPlatformCodeInsightTestCase.executeAction("EditorDown");
    }

    protected static void lineComment() {
        LightPlatformCodeInsightTestCase.executeAction("CommentByLineComment");
    }

    protected static void executeAction(@NonNls @NotNull String actionId) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "executeAction"));
        }
        LightPlatformCodeInsightTestCase.executeAction(actionId, LightPlatformCodeInsightTestCase.getEditor());
    }

    protected static void executeAction(@NonNls @NotNull String actionId, @NotNull Editor editor) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "executeAction"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "executeAction"));
        }
        LightPlatformCodeInsightTestCase.executeAction(actionId, editor, LightPlatformCodeInsightTestCase.getProject());
    }

    public static void executeAction(@NonNls @NotNull String actionId, @NotNull Editor editor, Project project2) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "executeAction"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "executeAction"));
        }
        CommandProcessor.getInstance().executeCommand(project2, () -> {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "lambda$executeAction$6"));
            }
            if (actionId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "lambda$executeAction$6"));
            }
            EditorTestUtil.executeAction(editor, actionId);
        }, "", null, editor.getDocument());
    }

    @NotNull
    protected static DataContext getCurrentEditorDataContext() {
        DataContext defaultContext = DataManager.getInstance().getDataContext();
        DataContext dataContext = dataId -> {
            if (CommonDataKeys.EDITOR.is(dataId)) {
                return LightPlatformCodeInsightTestCase.getEditor();
            }
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return LightPlatformCodeInsightTestCase.getProject();
            }
            if (CommonDataKeys.PSI_FILE.is(dataId)) {
                return LightPlatformCodeInsightTestCase.getFile();
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                PsiFile file2 = LightPlatformCodeInsightTestCase.getFile();
                if (file2 == null) {
                    return null;
                }
                Editor editor = LightPlatformCodeInsightTestCase.getEditor();
                if (editor == null) {
                    return null;
                }
                return file2.findElementAt(editor.getCaretModel().getOffset());
            }
            return defaultContext.getData(dataId);
        };
        if (dataContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "getCurrentEditorDataContext"));
        }
        return dataContext;
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> params() throws Throwable {
        return Collections.emptyList();
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> params(@NotNull Class<?> klass) throws Throwable {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "params"));
        }
        LightPlatformCodeInsightTestCase testCase = (LightPlatformCodeInsightTestCase)((Object)klass.newInstance());
        if (!(testCase instanceof FileBasedTestCaseHelper)) {
            LightPlatformCodeInsightTestCase.fail((String)"Parameterized test should implement FileBasedTestCaseHelper");
        }
        try {
            PathManagerEx.replaceLookupStrategy(klass, Parameterized.class);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        FileBasedTestCaseHelper fileBasedTestCase = (FileBasedTestCaseHelper)((Object)testCase);
        String testDataPath = testCase.getTestDataPath();
        File testDir = null;
        if (fileBasedTestCase instanceof FileBasedTestCaseHelperEx) {
            testDir = new File(testDataPath, ((FileBasedTestCaseHelperEx)fileBasedTestCase).getRelativeBasePath());
        } else {
            TestDataPath annotation = klass.getAnnotation(TestDataPath.class);
            if (annotation == null) {
                LightPlatformCodeInsightTestCase.fail((String)"TestCase should implement com.intellij.testFramework.FileBasedTestCaseHelperEx or be annotated with com.intellij.testFramework.TestDataPath");
            } else {
                String trimmedRoot = StringUtil.trimStart((String)StringUtil.trimStart((String)annotation.value(), (String)"$CONTENT_ROOT"), (String)"$PROJECT_ROOT");
                String lastPathComponent = new File(testDataPath).getName();
                int idx = trimmedRoot.indexOf(lastPathComponent);
                testDataPath = testDataPath.replace(File.separatorChar, '/') + (idx > 0 ? trimmedRoot.substring(idx + lastPathComponent.length()) : trimmedRoot);
                testDir = new File(testDataPath);
            }
        }
        File[] files2 = testDir.listFiles();
        if (files2 == null) {
            LightPlatformCodeInsightTestCase.fail((String)("Test files not found in " + testDir.getPath()));
        }
        ArrayList<Object[]> result2 = new ArrayList<Object[]>();
        for (File file2 : files2) {
            String fileSuffix = fileBasedTestCase.getFileSuffix(file2.getName());
            if (fileSuffix == null) continue;
            result2.add(new Object[]{fileSuffix, testDataPath});
        }
        return result2;
    }

    public String getName() {
        if (this.myFileSuffix != null) {
            return "test" + this.myFileSuffix;
        }
        return super.getName();
    }

    @Before
    public void before() throws Throwable {
        Throwable[] throwables = new Throwable[1];
        this.invokeTestRunnable(() -> {
            try {
                this.setUp();
            }
            catch (Throwable e2) {
                throwables[0] = e2;
            }
        });
        if (throwables[0] != null) {
            throw throwables[0];
        }
    }

    @After
    public void after() throws Throwable {
        Throwable[] throwables = new Throwable[1];
        this.invokeTestRunnable(() -> {
            try {
                this.tearDown();
            }
            catch (Throwable e2) {
                throwables[0] = e2;
            }
        });
        if (throwables[0] != null) {
            throw throwables[0];
        }
    }

    protected void runSingleTest(@NotNull Runnable testRunnable) throws Throwable {
        if (testRunnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testRunnable", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "runSingleTest"));
        }
        Throwable[] throwables = new Throwable[1];
        this.invokeTestRunnable(() -> {
            if (testRunnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testRunnable", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "lambda$runSingleTest$10"));
            }
            try {
                testRunnable.run();
            }
            catch (Throwable e2) {
                throwables[0] = e2;
            }
        });
        if (throwables[0] != null) {
            throw throwables[0];
        }
    }
}

