/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.testFramework.AbstractMockGlyphVector;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class MockFontLayoutService
extends FontLayoutService {
    private final int myCharWidth;
    private final int myLineHeight;
    private final int myDescent;

    public MockFontLayoutService(int charWidth, int lineHeight, int descent) {
        this.myCharWidth = charWidth;
        this.myLineHeight = lineHeight;
        this.myDescent = descent;
    }

    @Override
    @NotNull
    public GlyphVector layoutGlyphVector(@NotNull Font font, @NotNull FontRenderContext fontRenderContext, @NotNull char[] chars, int start2, int end, boolean isRtl) {
        if (font == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "font", "com/intellij/testFramework/MockFontLayoutService", "layoutGlyphVector"));
        }
        if (fontRenderContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontRenderContext", "com/intellij/testFramework/MockFontLayoutService", "layoutGlyphVector"));
        }
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/testFramework/MockFontLayoutService", "layoutGlyphVector"));
        }
        MockGlyphVector mockGlyphVector = new MockGlyphVector(Arrays.copyOfRange(chars, start2, end), isRtl);
        if (mockGlyphVector == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/MockFontLayoutService", "layoutGlyphVector"));
        }
        return mockGlyphVector;
    }

    @Override
    public int charWidth(@NotNull FontMetrics fontMetrics, char c2) {
        if (fontMetrics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontMetrics", "com/intellij/testFramework/MockFontLayoutService", "charWidth"));
        }
        return this.myCharWidth;
    }

    @Override
    public int charWidth(@NotNull FontMetrics fontMetrics, int codePoint) {
        if (fontMetrics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontMetrics", "com/intellij/testFramework/MockFontLayoutService", "charWidth"));
        }
        return this.myCharWidth;
    }

    @Override
    public float charWidth2D(@NotNull FontMetrics fontMetrics, int codePoint) {
        if (fontMetrics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontMetrics", "com/intellij/testFramework/MockFontLayoutService", "charWidth2D"));
        }
        return this.myCharWidth;
    }

    @Override
    public int getHeight(@NotNull FontMetrics fontMetrics) {
        if (fontMetrics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontMetrics", "com/intellij/testFramework/MockFontLayoutService", "getHeight"));
        }
        return this.myLineHeight;
    }

    @Override
    public int getDescent(@NotNull FontMetrics fontMetrics) {
        if (fontMetrics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontMetrics", "com/intellij/testFramework/MockFontLayoutService", "getDescent"));
        }
        return this.myDescent;
    }

    private class MockGlyphVector
    extends AbstractMockGlyphVector {
        private final char[] myChars;
        private final boolean myIsRtl;

        private MockGlyphVector(char[] chars, boolean isRtl) {
            this.myChars = chars;
            this.myIsRtl = isRtl;
        }

        @Override
        public int getNumGlyphs() {
            return this.myChars.length;
        }

        @Override
        public int getGlyphCharIndex(int glyphIndex) {
            return this.myIsRtl ? this.myChars.length - 1 - glyphIndex : glyphIndex;
        }

        @Override
        public Point2D getGlyphPosition(int glyphIndex) {
            return new Point(glyphIndex * MockFontLayoutService.this.myCharWidth, 0);
        }

        @Override
        public Shape getGlyphLogicalBounds(int glyphIndex) {
            return new Rectangle(glyphIndex * MockFontLayoutService.this.myCharWidth, -MockFontLayoutService.this.myDescent, MockFontLayoutService.this.myCharWidth, MockFontLayoutService.this.myLineHeight);
        }

        @Override
        public int getGlyphCode(int glyphIndex) {
            return this.myChars[glyphIndex];
        }
    }
}

