/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.JavaModuleExternalPaths;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.junit.Assert;

public class PsiTestUtil {
    public static VirtualFile createTestProjectStructure(Project project2, Module module2, String rootPath, Collection<File> filesToDelete) throws Exception {
        return PsiTestUtil.createTestProjectStructure(project2, module2, rootPath, filesToDelete, true);
    }

    public static VirtualFile createTestProjectStructure(Project project2, Module module2, Collection<File> filesToDelete) throws IOException {
        return PsiTestUtil.createTestProjectStructure(project2, module2, null, filesToDelete, true);
    }

    public static VirtualFile createTestProjectStructure(Project project2, Module module2, String rootPath, Collection<File> filesToDelete, boolean addProjectRoots) throws IOException {
        VirtualFile vDir = PsiTestUtil.createTestProjectStructure(module2, rootPath, filesToDelete, addProjectRoots);
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        return vDir;
    }

    public static VirtualFile createTestProjectStructure(Module module2, String rootPath, Collection<File> filesToDelete, boolean addProjectRoots) throws IOException {
        return PsiTestUtil.createTestProjectStructure("unitTest", module2, rootPath, filesToDelete, addProjectRoots);
    }

    public static VirtualFile createTestProjectStructure(String tempName, Module module2, String rootPath, Collection<File> filesToDelete, boolean addProjectRoots) throws IOException {
        File dir = FileUtil.createTempDirectory((String)tempName, null, (boolean)false);
        filesToDelete.add(dir);
        VirtualFile vDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(dir.getCanonicalPath().replace(File.separatorChar, '/'));
        assert (vDir != null && vDir.isDirectory()) : dir;
        PlatformTestCase.synchronizeTempDirVfs(vDir);
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> WriteAction.run(() -> {
            if (rootPath != null) {
                VirtualFile vDir1 = LocalFileSystem.getInstance().findFileByPath(rootPath.replace(File.separatorChar, '/'));
                if (vDir1 == null) {
                    throw new Exception(rootPath + " not found");
                }
                VfsUtil.copyDirectory(null, (VirtualFile)vDir1, (VirtualFile)vDir, null);
            }
            if (addProjectRoots) {
                PsiTestUtil.addSourceContentToRoots(module2, vDir);
            }
        })));
        return vDir;
    }

    public static void removeAllRoots(@NotNull Module module2, Sdk jdk) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/testFramework/PsiTestUtil", "removeAllRoots"));
        }
        ModuleRootModificationUtil.updateModel((Module)module2, model2 -> {
            model2.clear();
            model2.setSdk(jdk);
        });
    }

    public static void addSourceContentToRoots(Module module2, @NotNull VirtualFile vDir) {
        if (vDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vDir", "com/intellij/testFramework/PsiTestUtil", "addSourceContentToRoots"));
        }
        PsiTestUtil.addSourceContentToRoots(module2, vDir, false);
    }

    public static void addSourceContentToRoots(Module module2, @NotNull VirtualFile vDir, boolean testSource) {
        if (vDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vDir", "com/intellij/testFramework/PsiTestUtil", "addSourceContentToRoots"));
        }
        ModuleRootModificationUtil.updateModel((Module)module2, model2 -> {
            if (vDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vDir", "com/intellij/testFramework/PsiTestUtil", "lambda$addSourceContentToRoots$3"));
            }
            model2.addContentEntry(vDir).addSourceFolder(vDir, testSource);
        });
    }

    public static void addSourceRoot(Module module2, VirtualFile vDir) {
        PsiTestUtil.addSourceRoot(module2, vDir, false);
    }

    public static void addSourceRoot(Module module2, VirtualFile vDir, boolean isTestSource) {
        PsiTestUtil.addSourceRoot(module2, vDir, isTestSource ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE);
    }

    public static <P extends JpsElement> void addSourceRoot(Module module2, VirtualFile vDir, @NotNull JpsModuleSourceRootType<P> rootType) {
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/testFramework/PsiTestUtil", "addSourceRoot"));
        }
        PsiTestUtil.addSourceRoot(module2, vDir, rootType, (JpsElement)rootType.createDefaultProperties());
    }

    public static <P extends JpsElement> void addSourceRoot(Module module2, VirtualFile vDir, @NotNull JpsModuleSourceRootType<P> rootType, P properties) {
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/testFramework/PsiTestUtil", "addSourceRoot"));
        }
        ModuleRootModificationUtil.updateModel((Module)module2, model2 -> {
            if (rootType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/testFramework/PsiTestUtil", "lambda$addSourceRoot$4"));
            }
            ContentEntry entry = PsiTestUtil.findContentEntry((ModuleRootModel)model2, vDir);
            if (entry == null) {
                entry = model2.addContentEntry(vDir);
            }
            entry.addSourceFolder(vDir, rootType, properties);
        });
    }

    @Nullable
    private static ContentEntry findContentEntry(ModuleRootModel rootModel, VirtualFile file2) {
        return (ContentEntry)ContainerUtil.find((Object[])rootModel.getContentEntries(), object -> {
            VirtualFile entryRoot = object.getFile();
            return entryRoot != null && VfsUtilCore.isAncestor((VirtualFile)entryRoot, (VirtualFile)file2, (boolean)false);
        });
    }

    public static ContentEntry addContentRoot(Module module2, VirtualFile vDir) {
        ModuleRootModificationUtil.updateModel((Module)module2, model2 -> model2.addContentEntry(vDir));
        for (ContentEntry entry : ModuleRootManager.getInstance((Module)module2).getContentEntries()) {
            if (!Comparing.equal((Object)entry.getFile(), (Object)vDir)) continue;
            Assert.assertFalse((boolean)((ContentEntryImpl)entry).isDisposed());
            return entry;
        }
        return null;
    }

    public static void addExcludedRoot(Module module2, VirtualFile dir) {
        ModuleRootModificationUtil.updateModel((Module)module2, model2 -> ApplicationManager.getApplication().runReadAction(() -> PsiTestUtil.findContentEntryWithAssertion(model2, dir).addExcludeFolder(dir)));
    }

    @NotNull
    private static ContentEntry findContentEntryWithAssertion(ModifiableRootModel model2, VirtualFile dir) {
        ContentEntry entry = PsiTestUtil.findContentEntry((ModuleRootModel)model2, dir);
        if (entry == null) {
            throw new RuntimeException(dir + " is not under content roots: " + Arrays.toString(model2.getContentRoots()));
        }
        ContentEntry contentEntry = entry;
        if (contentEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/PsiTestUtil", "findContentEntryWithAssertion"));
        }
        return contentEntry;
    }

    public static void removeContentEntry(Module module2, VirtualFile contentRoot) {
        ModuleRootModificationUtil.updateModel((Module)module2, model2 -> model2.removeContentEntry(PsiTestUtil.findContentEntryWithAssertion(model2, contentRoot)));
    }

    public static void removeSourceRoot(Module module2, VirtualFile root) {
        ModuleRootModificationUtil.updateModel((Module)module2, model2 -> {
            ContentEntry entry = PsiTestUtil.findContentEntryWithAssertion(model2, root);
            for (SourceFolder sourceFolder : entry.getSourceFolders()) {
                if (!root.equals(sourceFolder.getFile())) continue;
                entry.removeSourceFolder(sourceFolder);
                break;
            }
        });
    }

    public static void removeExcludedRoot(Module module2, VirtualFile root) {
        ModuleRootModificationUtil.updateModel((Module)module2, model2 -> {
            ContentEntry entry = PsiTestUtil.findContentEntryWithAssertion(model2, root);
            entry.removeExcludeFolder(root.getUrl());
        });
    }

    public static void checkFileStructure(PsiFile file2) throws IncorrectOperationException {
        String originalTree = DebugUtil.psiTreeToString((PsiElement)file2, false);
        PsiFile dummyFile = PsiFileFactory.getInstance((Project)file2.getProject()).createFileFromText(file2.getName(), file2.getFileType(), (CharSequence)file2.getText());
        String reparsedTree = DebugUtil.psiTreeToString((PsiElement)dummyFile, false);
        Assert.assertEquals((Object)reparsedTree, (Object)originalTree);
    }

    public static void addLibrary(Module module2, String libPath) {
        File file2 = new File(libPath);
        String libName = file2.getName();
        PsiTestUtil.addLibrary(module2, libName, file2.getParent(), libName);
    }

    public static void addLibrary(Module module2, String libName, String libPath, String ... jarArr) {
        ModuleRootModificationUtil.updateModel((Module)module2, model2 -> PsiTestUtil.addLibrary(module2, model2, libName, libPath, jarArr));
    }

    public static void addProjectLibrary(Module module2, String libName, VirtualFile ... classesRoots) {
        PsiTestUtil.addProjectLibrary(module2, libName, Arrays.asList(classesRoots), Collections.emptyList());
    }

    public static Library addProjectLibrary(Module module2, String libName, List<VirtualFile> classesRoots, List<VirtualFile> sourceRoots) {
        Ref result2 = Ref.create();
        ModuleRootModificationUtil.updateModel((Module)module2, model2 -> result2.set((Object)PsiTestUtil.addProjectLibrary(module2, model2, libName, classesRoots, sourceRoots)));
        return (Library)result2.get();
    }

    private static Library addProjectLibrary(Module module2, final ModifiableRootModel model2, final String libName, final List<VirtualFile> classesRoots, final List<VirtualFile> sourceRoots) {
        final LibraryTable libraryTable = ProjectLibraryTable.getInstance(module2.getProject());
        RunResult result2 = new WriteAction<Library>(){

            protected void run(@NotNull Result<Library> result2) throws Throwable {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PsiTestUtil$1", "run"));
                }
                Library library = libraryTable.createLibrary(libName);
                Library.ModifiableModel libraryModel = library.getModifiableModel();
                try {
                    for (VirtualFile root : classesRoots) {
                        libraryModel.addRoot(root, OrderRootType.CLASSES);
                    }
                    for (VirtualFile root : sourceRoots) {
                        libraryModel.addRoot(root, OrderRootType.SOURCES);
                    }
                    libraryModel.commit();
                }
                catch (Throwable t2) {
                    libraryModel.dispose();
                    throw t2;
                }
                model2.addLibraryEntry(library);
                OrderEntry[] orderEntries = model2.getOrderEntries();
                OrderEntry last = orderEntries[orderEntries.length - 1];
                System.arraycopy(orderEntries, 0, orderEntries, 1, orderEntries.length - 1);
                orderEntries[0] = last;
                model2.rearrangeOrderEntries(orderEntries);
                result2.setResult((Object)library);
            }
        }.execute();
        result2.throwException();
        return (Library)result2.getResultObject();
    }

    public static void addLibrary(Module module2, ModifiableRootModel model2, String libName, String libPath, String ... jarArr) {
        ArrayList<VirtualFile> classesRoots = new ArrayList<VirtualFile>();
        for (String jar : jarArr) {
            String path;
            if (!libPath.endsWith("/") && !jar.startsWith("/")) {
                jar = "/" + jar;
            }
            VirtualFile root = (path = libPath + jar).endsWith(".jar") ? JarFileSystem.getInstance().refreshAndFindFileByPath(path + "!/") : LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
            assert (root != null) : "Library root folder not found: " + path + "!/";
            classesRoots.add(root);
        }
        PsiTestUtil.addProjectLibrary(module2, model2, libName, classesRoots, Collections.emptyList());
    }

    public static void addLibrary(Module module2, String libName, String libDir, String[] classRoots, String[] sourceRoots) {
        String proto = (classRoots.length > 0 ? classRoots[0] : sourceRoots[0]).endsWith(".jar!/") ? "jar" : "file";
        String parentUrl = VirtualFileManager.constructUrl((String)proto, (String)libDir);
        ArrayList<String> classesUrls = new ArrayList<String>();
        ArrayList<String> sourceUrls = new ArrayList<String>();
        for (String classRoot : classRoots) {
            classesUrls.add(parentUrl + classRoot);
        }
        for (String sourceRoot : sourceRoots) {
            sourceUrls.add(parentUrl + sourceRoot);
        }
        ModuleRootModificationUtil.addModuleLibrary((Module)module2, (String)libName, classesUrls, sourceUrls);
    }

    public static Module addModule(final Project project2, final ModuleType type, final String name, final VirtualFile root) {
        return (Module)new WriteCommandAction<Module>(project2, new PsiFile[0]){

            protected void run(@NotNull Result<Module> result2) throws Throwable {
                String moduleName;
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PsiTestUtil$2", "run"));
                }
                ModifiableModuleModel moduleModel = ModuleManager.getInstance((Project)project2).getModifiableModel();
                try {
                    moduleName = moduleModel.newModule(root.getPath() + "/" + name + ".iml", type.getId()).getName();
                    moduleModel.commit();
                }
                catch (Throwable t2) {
                    moduleModel.dispose();
                    throw t2;
                }
                Module dep = ModuleManager.getInstance((Project)project2).findModuleByName(moduleName);
                assert (dep != null) : moduleName;
                ModifiableRootModel model2 = ModuleRootManager.getInstance((Module)dep).getModifiableModel();
                try {
                    model2.addContentEntry(root).addSourceFolder(root, false);
                    model2.commit();
                }
                catch (Throwable t3) {
                    model2.dispose();
                    throw t3;
                }
                result2.setResult((Object)dep);
            }
        }.execute().getResultObject();
    }

    public static void setCompilerOutputPath(Module module2, String url, boolean forTests) {
        ModuleRootModificationUtil.updateModel((Module)module2, model2 -> {
            CompilerModuleExtension extension = (CompilerModuleExtension)model2.getModuleExtension(CompilerModuleExtension.class);
            extension.inheritCompilerOutputPath(false);
            if (forTests) {
                extension.setCompilerOutputPathForTests(url);
            } else {
                extension.setCompilerOutputPath(url);
            }
        });
    }

    public static void setExcludeCompileOutput(Module module2, boolean exclude) {
        ModuleRootModificationUtil.updateModel((Module)module2, model2 -> ((CompilerModuleExtension)model2.getModuleExtension(CompilerModuleExtension.class)).setExcludeOutput(exclude));
    }

    public static void setJavadocUrls(Module module2, String ... urls) {
        ModuleRootModificationUtil.updateModel((Module)module2, model2 -> ((JavaModuleExternalPaths)model2.getModuleExtension(JavaModuleExternalPaths.class)).setJavadocUrls(urls));
    }

    @NotNull
    @Contract(pure=true)
    public static Sdk addJdkAnnotations(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/testFramework/PsiTestUtil", "addJdkAnnotations"));
        }
        String path = FileUtil.toSystemIndependentName((String)PlatformTestUtil.getCommunityPath()) + "/java/jdkAnnotations";
        VirtualFile root = LocalFileSystem.getInstance().findFileByPath(path);
        Sdk sdk2 = PsiTestUtil.addRootsToJdk(sdk, AnnotationOrderRootType.getInstance(), root);
        if (sdk2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/PsiTestUtil", "addJdkAnnotations"));
        }
        return sdk2;
    }

    @NotNull
    @Contract(pure=true)
    public static Sdk addRootsToJdk(@NotNull Sdk sdk, @NotNull OrderRootType rootType, VirtualFile ... roots) {
        Sdk clone;
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/testFramework/PsiTestUtil", "addRootsToJdk"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/testFramework/PsiTestUtil", "addRootsToJdk"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/testFramework/PsiTestUtil", "addRootsToJdk"));
        }
        try {
            clone = (Sdk)sdk.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(e2);
        }
        SdkModificator sdkModificator = clone.getSdkModificator();
        for (VirtualFile root : roots) {
            sdkModificator.addRoot(root, rootType);
        }
        sdkModificator.commitChanges();
        Sdk sdk2 = clone;
        if (sdk2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/PsiTestUtil", "addRootsToJdk"));
        }
        return sdk2;
    }
}

