/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.CompoundRuntimeException;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class RunAll
implements Runnable {
    private final List<ThrowableRunnable<?>> myActions;

    @SafeVarargs
    public RunAll(ThrowableRunnable<Throwable> ... actions2) {
        if (actions2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/testFramework/RunAll", "<init>"));
        }
        this(ContainerUtil.newArrayList((Object[])actions2));
    }

    private RunAll(@NotNull List<ThrowableRunnable<?>> actions2) {
        if (actions2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/testFramework/RunAll", "<init>"));
        }
        this.myActions = actions2;
    }

    @SafeVarargs
    @Contract(pure=true)
    public final RunAll append(ThrowableRunnable<Throwable> ... actions2) {
        if (actions2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/testFramework/RunAll", "append"));
        }
        return new RunAll(ContainerUtil.concat(this.myActions, (List)ContainerUtil.newArrayList((Object[])actions2)));
    }

    @Override
    public void run() {
        CompoundRuntimeException.throwIfNotEmpty(this.collectExceptions());
    }

    @NotNull
    private List<Throwable> collectExceptions() {
        SmartList errors = new SmartList();
        for (ThrowableRunnable<?> action2 : this.myActions) {
            try {
                action2.run();
            }
            catch (CompoundRuntimeException e2) {
                errors.addAll(e2.getExceptions());
            }
            catch (Throwable e3) {
                errors.add(e3);
            }
        }
        SmartList smartList = errors;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/RunAll", "collectExceptions"));
        }
        return smartList;
    }
}

