/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.diagnostic.Log4jBasedLogger;
import com.intellij.testFramework.LoggedErrorProcessor;
import com.intellij.testFramework.TestLoggerFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestLogger
extends Log4jBasedLogger {
    TestLogger(@NotNull Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/intellij/testFramework/TestLogger", "<init>"));
        }
        super(logger);
    }

    public void warn(String message2, @Nullable Throwable t2) {
        t2 = TestLogger.checkException((Throwable)t2);
        LoggedErrorProcessor.getInstance().processWarn(message2, t2, this.myLogger);
    }

    public void error(String message2, @Nullable Throwable t2, String ... details) {
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/testFramework/TestLogger", "error"));
        }
        t2 = TestLogger.checkException((Throwable)t2);
        LoggedErrorProcessor.getInstance().processError(message2, t2, details, this.myLogger);
    }

    public void debug(@NonNls String message2) {
        super.debug(message2);
        TestLoggerFactory.log(this.myLogger, Level.DEBUG, message2, null);
    }

    public void debug(@Nullable Throwable t2) {
        super.debug(t2);
        TestLoggerFactory.log(this.myLogger, Level.DEBUG, null, t2);
    }

    public void debug(@NonNls String message2, @Nullable Throwable t2) {
        super.debug(message2, t2);
        TestLoggerFactory.log(this.myLogger, Level.DEBUG, message2, t2);
    }

    public void info(@NonNls String message2) {
        super.info(message2);
        TestLoggerFactory.log(this.myLogger, Level.INFO, message2, null);
    }

    public void info(@NonNls String message2, @Nullable Throwable t2) {
        super.info(message2, t2);
        TestLoggerFactory.log(this.myLogger, Level.INFO, message2, t2);
    }

    public boolean isDebugEnabled() {
        return true;
    }
}

