/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;

public class Timings {
    private static final int IO_PROBES = 42;
    public static final long CPU_TIMING;
    public static final long IO_TIMING;
    public static final long MACHINE_TIMING;
    public static final long ETALON_TIMING = 438L;
    public static final long ETALON_CPU_TIMING = 200L;
    public static final long ETALON_IO_TIMING = 100L;

    private static long measureCPU() {
        long start2 = System.currentTimeMillis();
        BigInteger k2 = new BigInteger("1");
        for (int i2 = 0; i2 < 1000000; ++i2) {
            k2 = k2.add(new BigInteger("1"));
        }
        return System.currentTimeMillis() - start2;
    }

    public static int adjustAccordingToMySpeed(int value2, boolean isParallelizable) {
        return Math.max(1, (int)(1.0 * (double)value2 * 438.0 / (double)MACHINE_TIMING) / 8 * (isParallelizable ? JobSchedulerImpl.CORES_COUNT : 1));
    }

    public static String getStatistics() {
        return " Timings: CPU=" + CPU_TIMING + " (" + (int)((double)CPU_TIMING * 1.0 / 200.0 * 100.0) + "% of the etalon), I/O=" + IO_TIMING + " (" + (int)((double)IO_TIMING * 1.0 / 100.0 * 100.0) + "% of the etalon), total=" + MACHINE_TIMING + " (" + (int)((double)MACHINE_TIMING * 1.0 / 438.0 * 100.0) + "% of the etalon) " + Runtime.getRuntime().availableProcessors() + " cores.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        int N = 20;
        for (int i2 = 0; i2 < N; ++i2) {
            Timings.measureCPU();
        }
        long[] elapsed = new long[N];
        for (int i3 = 0; i3 < N; ++i3) {
            elapsed[i3] = Timings.measureCPU();
        }
        CPU_TIMING = ArrayUtil.averageAmongMedians((long[])elapsed, (int)2);
        long start2 = System.currentTimeMillis();
        for (int i4 = 0; i4 < 42; ++i4) {
            try {
                File tempFile = FileUtil.createTempFile((String)"test", (String)("test" + i4));
                try (FileWriter writer = new FileWriter(tempFile);){
                    for (int j2 = 0; j2 < 15; ++j2) {
                        writer.write("test" + j2);
                        writer.flush();
                    }
                }
                try (FileReader reader = new FileReader(tempFile);){
                    while (reader.read() >= 0) {
                    }
                }
                if (i4 == 41) {
                    try (FileOutputStream stream = new FileOutputStream(tempFile);){
                        stream.getFD().sync();
                    }
                }
                if (tempFile.delete()) continue;
                throw new IOException("Unable to delete: " + tempFile);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
        IO_TIMING = System.currentTimeMillis() - start2;
        MACHINE_TIMING = CPU_TIMING + IO_TIMING;
    }
}

