/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class TempDirTestFixtureImpl
extends BaseFixture
implements TempDirTestFixture {
    private File myTempDir;

    @Override
    @NotNull
    public VirtualFile copyAll(@NotNull String dataDir, @NotNull String targetDir) {
        if (dataDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataDir", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "copyAll"));
        }
        if (targetDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDir", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "copyAll"));
        }
        VirtualFile virtualFile = this.copyAll(dataDir, targetDir, VirtualFileFilter.ALL);
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "copyAll"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile copyAll(final @NotNull String dataDir, final @NotNull String targetDir, final @NotNull VirtualFileFilter filter2) {
        if (dataDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataDir", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "copyAll"));
        }
        if (targetDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDir", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "copyAll"));
        }
        if (filter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "copyAll"));
        }
        this.createTempDirectory();
        VirtualFile virtualFile = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                try {
                    VirtualFile tempDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(TempDirTestFixtureImpl.this.myTempDir.getCanonicalPath().replace(File.separatorChar, '/'));
                    Assert.assertNotNull((Object)tempDir);
                    if (targetDir.length() > 0) {
                        Assert.assertFalse((String)"nested directories not implemented", (boolean)targetDir.contains("/"));
                        VirtualFile child = tempDir.findChild(targetDir);
                        if (child == null) {
                            child = tempDir.createChildDirectory((Object)this, targetDir);
                        }
                        tempDir = child;
                    }
                    VirtualFile from = LocalFileSystem.getInstance().refreshAndFindFileByPath(dataDir);
                    Assert.assertNotNull((String)(dataDir + " not found"), (Object)from);
                    VfsUtil.copyDirectory(null, (VirtualFile)from, (VirtualFile)tempDir, (VirtualFileFilter)filter2);
                    return tempDir;
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        });
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "copyAll"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public String getTempDirPath() {
        String string2 = this.createTempDirectory().getAbsolutePath();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "getTempDirPath"));
        }
        return string2;
    }

    public File createTempFile(String fileName) throws IOException {
        String prefix = StringUtil.getPackageName((String)fileName);
        if (prefix.length() < 3) {
            prefix = prefix + "___";
        }
        String suffix = "." + StringUtil.getShortName((String)fileName);
        return FileUtil.createTempFile((File)new File(this.getTempDirPath()), (String)prefix, (String)suffix, (boolean)true);
    }

    @Override
    public VirtualFile getFile(final @NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "getFile"));
        }
        return (VirtualFile)new WriteAction<VirtualFile>(){

            protected void run(@NotNull Result<VirtualFile> result2) throws IOException {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl$2", "run"));
                }
                String fullPath = TempDirTestFixtureImpl.this.myTempDir.getCanonicalPath() + '/' + path;
                VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(fullPath);
                result2.setResult((Object)file2);
            }
        }.execute().getResultObject();
    }

    @Override
    @NotNull
    public VirtualFile createFile(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "createFile"));
        }
        File file2 = new File(this.createTempDirectory(), name);
        VirtualFile virtualFile = (VirtualFile)ApplicationManager.getApplication().runWriteAction(() -> {
            FileUtil.createIfDoesntExist((File)file2);
            return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
        });
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "createFile"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile findOrCreateDir(@NotNull String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "findOrCreateDir"));
        }
        VirtualFile virtualFile = VfsUtil.createDirectories((String)new File(this.createTempDirectory(), name).getPath());
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "findOrCreateDir"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile createFile(@NotNull String name, final @NotNull String text2) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "createFile"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "createFile"));
        }
        final VirtualFile file2 = this.createFile(name);
        new WriteAction(){

            protected void run(@NotNull Result result2) throws IOException {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl$3", "run"));
                }
                VfsUtil.saveText((VirtualFile)file2, (String)text2);
            }
        }.execute();
        VirtualFile virtualFile = file2;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "createFile"));
        }
        return virtualFile;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createTempDirectory();
    }

    @Override
    public void tearDown() throws Exception {
        try {
            if (this.myTempDir != null) {
                new WriteAction(){

                    protected void run(@NotNull Result result2) throws IOException {
                        if (result2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl$4", "run"));
                        }
                        TempDirTestFixtureImpl.this.findOrCreateDir("").delete((Object)this);
                    }
                }.execute();
            }
        }
        finally {
            super.tearDown();
        }
    }

    protected File getTempHome() {
        return null;
    }

    @NotNull
    protected File createTempDirectory() {
        File file2;
        try {
            if (this.myTempDir == null) {
                File tempHome = this.getTempHome();
                this.myTempDir = tempHome == null ? FileUtil.createTempDirectory((String)"unitTest", null, (boolean)false) : FileUtil.createTempDirectory((File)tempHome, (String)"unitTest", null, (boolean)false);
            }
            file2 = this.myTempDir;
        }
        catch (IOException e2) {
            throw new RuntimeException("Cannot create temp dir", e2);
        }
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "createTempDirectory"));
        }
        return file2;
    }
}

