/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.utils.inlays;

import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettings;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiFile;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.ComparisonFailure;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\nH\u0002J \u0010\u0012\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\u0006\u0010\u0015\u001a\u00020\bJ\u0006\u0010\u0016\u001a\u00020\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsChecker;", "", "myFixture", "Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;", "(Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;)V", "isParamHintsEnabledBefore", "", "checkInlays", "", "extractInlays", "", "Lcom/intellij/codeInsight/hints/InlayInfo;", "document", "Lcom/intellij/openapi/editor/Document;", "getActualInlays", "Lkotlin/Pair;", "", "", "removeText", "realStartOffset", "matchedLength", "setUp", "tearDown", "Companion", "testFramework"})
public final class InlayHintsChecker {
    private boolean isParamHintsEnabledBefore;
    private final CodeInsightTestFixture myFixture;
    @NotNull
    private static final Pattern pattern;
    private static final ParameterNameHintsSettings default;
    public static final Companion Companion;

    public final void setUp() {
        EditorSettingsExternalizable settings = EditorSettingsExternalizable.getInstance();
        this.isParamHintsEnabledBefore = settings.isShowParameterNameHints();
        settings.setShowParameterNameHints(true);
    }

    public final void tearDown() {
        EditorSettingsExternalizable.getInstance().setShowParameterNameHints(this.isParamHintsEnabledBefore);
        ParameterNameHintsSettings hintSettings = ParameterNameHintsSettings.Companion.getInstance();
        hintSettings.loadState(InlayHintsChecker.Companion.getDefault().getState());
    }

    /*
     * WARNING - void declaration
     */
    public final void checkInlays() {
        block9: {
            Object object;
            List<Pair<Integer, String>> actual;
            String originalText;
            Document document;
            PsiFile file2;
            block8: {
                boolean bl;
                block7: {
                    Iterator $receiver$iv$iv;
                    file2 = this.myFixture.getFile();
                    document = this.myFixture.getDocument(file2);
                    originalText = document.getText();
                    Document document2 = document;
                    Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"document");
                    List<InlayInfo> expectedInlays = this.extractInlays(document2);
                    actual = this.getActualInlays();
                    Iterable $receiver$iv = expectedInlays;
                    object = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    Iterator iterator2 = $receiver$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        void it;
                        Object item$iv$iv = iterator2.next();
                        InlayInfo inlayInfo = (InlayInfo)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        Pair pair = new Pair((Object)it.getOffset(), (Object)it.getText());
                        collection.add(pair);
                    }
                    List expected = (List)destination$iv$iv;
                    if (expectedInlays.size() != actual.size()) break block8;
                    $receiver$iv = CollectionsKt.zip((Iterable)actual, (Iterable)expected);
                    for (Iterator element$iv : $receiver$iv) {
                        Pair it = (Pair)element$iv;
                        if (!(Intrinsics.areEqual((Object)((Pair)it.getFirst()), (Object)((Pair)it.getSecond())) ^ true)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
                if (!bl) break block9;
            }
            StringBuilder proposedText = new StringBuilder(document.getText());
            Iterable $receiver$iv = CollectionsKt.asReversed(actual);
            for (Object element$iv : $receiver$iv) {
                Pair it = (Pair)element$iv;
                proposedText.insert(((Number)it.getFirst()).intValue(), "<hint text=" + "\"" + (String)it.getSecond() + "\"" + " />");
            }
            String string2 = (String)VfsTestUtil.TEST_DATA_FILE_PATH.get((UserDataHolder)file2.getVirtualFile());
            if (string2 != null) {
                object = string2;
                String originalPath = (String)object;
                throw (Throwable)new FileComparisonFailure("Hints differ", originalText, proposedText.toString(), originalPath);
            }
            throw (Throwable)new ComparisonFailure("Hints differ", originalText, proposedText.toString());
        }
    }

    private final List<Pair<Integer, String>> getActualInlays() {
        Inlay it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        this.myFixture.doHighlighting();
        Editor editor = this.myFixture.getEditor();
        List allInlays = editor.getInlayModel().getInlineElementsInRange(0, editor.getDocument().getTextLength());
        ParameterHintsPresentationManager hintManager = ParameterHintsPresentationManager.getInstance();
        Iterable iterable = allInlays;
        Iterable iterable2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Inlay)element$iv$iv;
            if (!hintManager.isParameterHint(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (Inlay)item$iv$iv;
            Collection collection = destination$iv$iv;
            Pair pair = TuplesKt.to((Object)it.getOffset(), (Object)hintManager.getHintText(it));
            collection.add(pair);
        }
        $receiver$iv = (List)destination$iv$iv;
        iterable2 = $receiver$iv;
        Comparator comparator2 = new Comparator<Pair<? extends Integer, ? extends String>>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public int compare(Object a, Object b2) {
                Pair it = (Pair)a;
                Comparable comparable = Integer.valueOf(((Number)it.getFirst()).intValue());
                it = (Pair)b2;
                Comparable comparable2 = comparable;
                Integer n2 = ((Number)it.getFirst()).intValue();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n2);
            }
        };
        return CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)comparator2);
    }

    @NotNull
    public final List<InlayInfo> extractInlays(@NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        String text2 = document.getText();
        Matcher matcher = Companion.getPattern().matcher(text2);
        List inlays = new ArrayList();
        int extractedLength = 0;
        while (matcher.find()) {
            int start2 = matcher.start();
            int matchedLength = matcher.end() - start2;
            int realStartOffset = start2 - extractedLength;
            Collection collection = inlays;
            String string2 = matcher.group(1);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"matcher.group(1)");
            InlayInfo inlayInfo = new InlayInfo(string2, realStartOffset);
            collection.add(inlayInfo);
            this.removeText(document, realStartOffset, matchedLength);
            extractedLength += matcher.end() - start2;
        }
        return inlays;
    }

    private final void removeText(Document document, int realStartOffset, int matchedLength) {
        WriteCommandAction.runWriteCommandAction((Project)this.myFixture.getProject(), (Runnable)new Runnable(document, realStartOffset, matchedLength){
            final /* synthetic */ Document $document;
            final /* synthetic */ int $realStartOffset;
            final /* synthetic */ int $matchedLength;

            public final void run() {
                this.$document.replaceString(this.$realStartOffset, this.$realStartOffset + this.$matchedLength, (CharSequence)"");
            }
            {
                this.$document = document;
                this.$realStartOffset = n2;
                this.$matchedLength = n3;
            }
        });
    }

    public InlayHintsChecker(@NotNull CodeInsightTestFixture myFixture) {
        Intrinsics.checkParameterIsNotNull((Object)myFixture, (String)"myFixture");
        this.myFixture = myFixture;
    }

    static {
        Companion = new Companion(null);
        Pattern pattern = Pattern.compile("<hint\\s+text=\"([^\"\n\r]+)\"\\s*/>");
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(\"<hint\\\\\u2026=\\\"([^\\\"\\n\\r]+)\\\"\\\\s*/>\")");
        InlayHintsChecker.pattern = pattern;
        default = new ParameterNameHintsSettings();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsChecker$Companion;", "", "()V", "default", "Lcom/intellij/codeInsight/hints/settings/ParameterNameHintsSettings;", "getDefault", "()Lcom/intellij/codeInsight/hints/settings/ParameterNameHintsSettings;", "pattern", "Ljava/util/regex/Pattern;", "getPattern", "()Ljava/util/regex/Pattern;", "testFramework"})
    public static final class Companion {
        @NotNull
        public final Pattern getPattern() {
            return pattern;
        }

        private final ParameterNameHintsSettings getDefault() {
            return default;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

