/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tools.SimpleActionGroup;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolAction;
import com.intellij.tools.ToolsGroup;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class BaseExternalToolsGroup<T extends Tool>
extends SimpleActionGroup
implements DumbAware {
    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        this.removeAll();
        String context2 = event.getPlace();
        Project project2 = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            presentation.setVisible(false);
            presentation.setEnabled(false);
            return;
        }
        presentation.setEnabled(true);
        List<ToolsGroup<T>> groups2 = this.getToolsGroups();
        for (ToolsGroup<T> group : groups2) {
            String groupName = group.getName();
            if (!StringUtil.isEmptyOrSpaces((String)groupName)) {
                SimpleActionGroup subgroup = new SimpleActionGroup();
                subgroup.getTemplatePresentation().setText(groupName, false);
                subgroup.setPopup(true);
                this.fillGroup(context2, groupName, subgroup);
                if (subgroup.getChildrenCount() <= 0) continue;
                this.add((AnAction)subgroup);
                continue;
            }
            this.fillGroup(context2, null, this);
        }
        presentation.setVisible(this.getChildrenCount() > 0);
    }

    protected abstract List<ToolsGroup<T>> getToolsGroups();

    private void fillGroup(String context2, @Nullable String groupName, SimpleActionGroup group) {
        List<T> tools = this.getToolsByGroupName(groupName);
        for (Tool tool : tools) {
            if (!this.isToolVisible(tool, context2)) continue;
            this.addToolToGroup(tool, group);
        }
    }

    protected abstract List<T> getToolsByGroupName(String var1);

    private void addToolToGroup(T tool, SimpleActionGroup group) {
        String id = ((Tool)tool).getActionId();
        AnAction action2 = ActionManager.getInstance().getAction(id);
        if (action2 == null) {
            action2 = this.createToolAction(tool);
        }
        group.add(action2);
    }

    protected abstract ToolAction createToolAction(T var1);

    private boolean isToolVisible(T tool, String context2) {
        if (!((Tool)tool).isEnabled()) {
            return false;
        }
        if ("EditorPopup".equals(context2) || "EditorTabPopup".equals(context2)) {
            return ((Tool)tool).isShownInEditor();
        }
        if ("ProjectViewPopup".equals(context2) || "CommanderPopup".equals(context2) || "J2EEViewPopup".equals(context2) || "TypeHierarchyViewPopup".equals(context2) || "CallHierarchyViewPopup".equals(context2) || "MethodHierarchyViewPopup".equals(context2) || "FavoritesPopup".equals(context2) || "ScopeViewPopup".equals(context2) || "NavBar".equals(context2)) {
            return ((Tool)tool).isShownInProjectViews();
        }
        if (ActionPlaces.isMainMenuOrActionSearch((String)context2)) {
            return ((Tool)tool).isShownInMainMenu();
        }
        if ("UsageViewPopup".equals(context2)) {
            return ((Tool)tool).isShownInSearchResultsPopup();
        }
        return false;
    }
}

